/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.List;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DispatchHandler.class);
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private boolean sign = false;

    public DispatchHandler(PeerBean peerBean, ConnectionBean connectionBean) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
    }

    public void register(int ... names) {
        this.connectionBean.dispatcher().registerIoHandler(this.peerBean.serverPeerAddress().peerId(), this, names);
    }

    public void sign(boolean sign) {
        this.sign = sign;
    }

    public PeerBean peerBean() {
        return this.peerBean;
    }

    public ConnectionBean connectionBean() {
        return this.connectionBean;
    }

    public Message createMessage(PeerAddress recipient, byte name, Message.Type type) {
        return new Message().recipient(recipient).sender(this.peerBean().serverPeerAddress()).command(name).type(type).version(this.connectionBean().p2pId());
    }

    public Message createResponseMessage(Message requestMessage, Message.Type replyType) {
        return DispatchHandler.createResponseMessage(requestMessage, replyType, this.peerBean().serverPeerAddress());
    }

    public static Message createResponseMessage(Message requestMessage, Message.Type replyType, PeerAddress peerAddress) {
        Message replyMessage = new Message();
        replyMessage.senderSocket(requestMessage.senderSocket());
        replyMessage.recipientSocket(requestMessage.recipientSocket());
        replyMessage.recipient(requestMessage.sender());
        replyMessage.sender(peerAddress);
        replyMessage.command(requestMessage.command());
        replyMessage.type(replyType);
        replyMessage.version(requestMessage.version());
        replyMessage.messageId(requestMessage.messageId());
        replyMessage.udp(requestMessage.isUdp());
        return replyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardMessage(Message requestMessage, PeerConnection peerConnection, Responder responder) {
        List<PeerStatusListener> list = this.peerBean.peerStatusListeners();
        synchronized (list) {
            for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                peerStatusListener.peerFound(requestMessage.sender(), requestMessage.sender());
            }
        }
        try {
            this.handleResponse(requestMessage, peerConnection, this.sign, responder);
        }
        catch (Throwable e) {
            List<PeerStatusListener> list2 = this.peerBean.peerStatusListeners();
            synchronized (list2) {
                for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                    peerStatusListener.peerFailed(requestMessage.sender(), PeerStatusListener.FailReason.Exception);
                }
            }
            LOG.error("Exception in custom handler", e);
            responder.failed(Message.Type.EXCEPTION, e.toString());
        }
    }

    public abstract void handleResponse(Message var1, PeerConnection var2, boolean var3, Responder var4) throws Exception;
}

