/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;

public class FutureForkJoin<K extends BaseFuture>
extends BaseFutureImpl<FutureForkJoin<K>>
implements BaseFuture {
    private final AtomicReferenceArray<K> forks;
    private final int nrFutures;
    private final int nrFinishFuturesSuccess;
    private final boolean cancelFuturesOnFinish;
    private final List<K> forksCopy = new ArrayList<K>();
    private int counter = 0;
    private int successCounter = 0;

    public FutureForkJoin(AtomicReferenceArray<K> forks) {
        this(forks.length(), false, forks);
    }

    public FutureForkJoin(int nrFinishFuturesSuccess, boolean cancelFuturesOnFinish, AtomicReferenceArray<K> forks) {
        this.nrFinishFuturesSuccess = nrFinishFuturesSuccess;
        this.forks = forks;
        this.cancelFuturesOnFinish = cancelFuturesOnFinish;
        this.nrFutures = forks.length();
        if (this.nrFutures <= 0) {
            this.failed("We have no futures: " + this.nrFutures);
        } else {
            this.join();
        }
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() {
        for (int i = 0; i < this.nrFutures; ++i) {
            Object object = this.lock;
            synchronized (object) {
                if (this.completed) {
                    return;
                }
            }
            final int index = i;
            if (this.forks.get(index) != null) {
                ((BaseFuture)this.forks.get(index)).addListener(new BaseFutureAdapter<K>(){

                    @Override
                    public void operationComplete(K future) throws Exception {
                        FutureForkJoin.this.evaluate(future, index);
                    }
                });
                continue;
            }
            boolean notifyNow = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (++this.counter >= this.nrFutures) {
                    notifyNow = this.finish(BaseFuture.FutureType.FAILED);
                }
            }
            if (!notifyNow) continue;
            this.notifyListeners();
            this.cancelAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(K finished, int index) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.forksCopy.add(finished);
            this.forks.set(index, null);
            if (finished.isSuccess() && ++this.successCounter >= this.nrFinishFuturesSuccess) {
                notifyNow = this.finish(BaseFuture.FutureType.OK);
            } else if (++this.counter >= this.nrFutures) {
                notifyNow = this.finish(BaseFuture.FutureType.FAILED);
            }
        }
        if (notifyNow) {
            this.notifyListeners();
            this.cancelAll();
        }
    }

    private void cancelAll() {
        if (this.cancelFuturesOnFinish) {
            for (int i = 0; i < this.nrFutures; ++i) {
                BaseFuture future = (BaseFuture)this.forks.get(i);
                if (future == null) continue;
                future.cancel();
            }
        }
    }

    private boolean finish(BaseFuture.FutureType type) {
        if (!this.completedAndNotify()) {
            return false;
        }
        this.type = type;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String failedReason() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder("FFJ:").append(this.reason);
            sb.append(", type:").append((Object)this.type);
            for (BaseFuture k : this.completed()) {
                sb.append(",").append(k.failedReason());
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K last() {
        Object object = this.lock;
        synchronized (object) {
            return (K)((BaseFuture)this.forksCopy.get(this.forksCopy.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> completed() {
        Object object = this.lock;
        synchronized (object) {
            return this.forksCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int successCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.successCounter;
        }
    }
}

