/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.builder.AddTrackerBuilder;
import net.tomp2p.p2p.builder.GetTrackerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerRPC.class);
    public static final int MAX_MSG_SIZE_UDP = 35;

    public TrackerRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.TRACKER_ADD.getNr(), RPC.Commands.TRACKER_GET.getNr());
    }

    public static boolean isPrimary(FutureResponse response) {
        return response.getRequest().getType() == Message.Type.REQUEST_3;
    }

    public static boolean isSecondary(FutureResponse response) {
        return response.getRequest().getType() == Message.Type.REQUEST_1;
    }

    public FutureResponse addToTracker(PeerAddress remotePeer, AddTrackerBuilder builder, ChannelCreator channelCreator) {
        Utils.nullCheck(remotePeer, builder.getLocationKey(), builder.getDomainKey());
        Message message = this.createMessage(remotePeer, RPC.Commands.TRACKER_ADD.getNr(), builder.isPrimary() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        if (builder.isSign()) {
            message.setPublicKeyAndSign(builder.keyPair());
        }
        message.setKey(builder.getLocationKey());
        message.setKey(builder.getDomainKey());
        if (builder.getBloomFilter() != null) {
            message.setBloomFilter(builder.getBloomFilter());
        }
        FutureResponse futureResponse = new FutureResponse(message);
        TrackerRequest requestHandler = new TrackerRequest(futureResponse, this.peerBean(), this.connectionBean(), message, builder.getLocationKey(), builder.getDomainKey(), builder);
        TrackerData trackerData = new TrackerData(new HashMap<PeerAddress, Data>(), null);
        PeerAddress peerAddressToAnnounce = builder.peerAddressToAnnounce();
        if (peerAddressToAnnounce == null) {
            peerAddressToAnnounce = this.peerBean().serverPeerAddress();
        }
        trackerData.put(peerAddressToAnnounce, builder.getAttachement());
        message.setTrackerData(trackerData);
        if (builder.isForceTCP()) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.sendUDP(channelCreator);
    }

    public FutureResponse getFromTracker(PeerAddress remotePeer, GetTrackerBuilder builder, ChannelCreator channelCreator) {
        Utils.nullCheck(remotePeer, builder.getLocationKey(), builder.getDomainKey());
        Message message = this.createMessage(remotePeer, RPC.Commands.TRACKER_GET.getNr(), Message.Type.REQUEST_1);
        if (builder.isSign()) {
            message.setPublicKeyAndSign(builder.keyPair());
        }
        message.setKey(builder.getLocationKey());
        message.setKey(builder.getDomainKey());
        if (builder.getKnownPeers() != null && builder.getKnownPeers() instanceof SimpleBloomFilter) {
            message.setBloomFilter((SimpleBloomFilter)builder.getKnownPeers());
        }
        FutureResponse futureResponse = new FutureResponse(message);
        TrackerRequest requestHandler = new TrackerRequest(futureResponse, this.peerBean(), this.connectionBean(), message, builder.getLocationKey(), builder.getDomainKey(), builder);
        if (builder.isExpectAttachement() || builder.isForceTCP()) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.sendUDP(channelCreator);
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_3 || message.getKey(0) == null || message.getKey(1) == null) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        Number160 locationKey = message.getKey(0);
        Number160 domainKey = message.getKey(1);
        SimpleBloomFilter<Number160> knownPeers = message.getBloomFilter(0);
        PublicKey publicKey = message.getPublicKey(0);
        TrackerStorage trackerStorage = this.peerBean().trackerStorage();
        TrackerData meshPeers = trackerStorage.meshPeers(locationKey, domainKey);
        boolean couldProvideMoreData = false;
        if (meshPeers != null) {
            int size;
            if (knownPeers != null) {
                meshPeers = Utils.disjunction(meshPeers, knownPeers);
            }
            couldProvideMoreData = (size = meshPeers.size()) > (meshPeers = Utils.limit(meshPeers, 35)).size();
            responseMessage.setTrackerData(meshPeers);
        }
        if (couldProvideMoreData) {
            responseMessage.setType(Message.Type.PARTIALLY_OK);
        }
        if (message.getCommand() == RPC.Commands.TRACKER_ADD.getNr()) {
            TrackerData trackerData = message.getTrackerData(0);
            if (trackerData.size() != 1) {
                responseMessage.setType(Message.Type.EXCEPTION);
            } else {
                Map.Entry<PeerAddress, Data> entry = trackerData.getPeerAddresses().entrySet().iterator().next();
                if (!trackerStorage.put(locationKey, domainKey, entry.getKey(), publicKey, entry.getValue())) {
                    responseMessage.setType(Message.Type.DENIED);
                    LOG.debug("tracker NOT put on({}) locationKey:{}, domainKey:{}, address:{}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, entry.getKey()});
                } else {
                    LOG.debug("tracker put on({}) locationKey:{}, domainKey:{}, address: {} sizeP: {}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, entry.getKey(), trackerStorage.sizePrimary(locationKey, domainKey)});
                }
            }
        } else {
            LOG.debug("tracker get on({}) locationKey:{}, domainKey:{}, address:{}, returning: {}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, message.getSender(), meshPeers == null ? "0" : Integer.valueOf(meshPeers.size())});
        }
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.peerBean().getKeyPair());
        }
        responder.response(responseMessage);
    }

    private void preHandleMessage(Message message, TrackerStorage trackerStorage, PeerAddress referrer, Number160 locationKey, Number160 domainKey) throws IOException, ClassNotFoundException {
        TrackerData tmp = message.getTrackerData(0);
        if (tmp == null || tmp.size() == 0) {
            return;
        }
        for (Map.Entry<PeerAddress, Data> trackerData : tmp.getPeerAddresses().entrySet()) {
            trackerStorage.putReferred(locationKey, domainKey, trackerData.getKey(), referrer, trackerData.getValue(), TrackerStorage.ReferrerType.MESH);
        }
    }

    private class TrackerRequest<K>
    extends RequestHandler<FutureResponse> {
        private final Message message;
        private final Number160 locationKey;
        private final Number160 domainKey;

        public TrackerRequest(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message, Number160 locationKey, Number160 domainKey, ConnectionConfiguration configuration) {
            super(futureResponse, peerBean, connectionBean, configuration);
            this.message = message;
            this.locationKey = locationKey;
            this.domainKey = domainKey;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Message responseMessage) throws Exception {
            TrackerRPC.this.preHandleMessage(responseMessage, this.peerBean().trackerStorage(), this.message.getRecipient(), this.locationKey, this.domainKey);
            super.channelRead0(ctx, responseMessage);
        }
    }
}

