/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.builder.ShutdownBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuitRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(QuitRPC.class);
    private final List<PeerStatusListener> listeners = new ArrayList<PeerStatusListener>();

    public QuitRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.QUIT.getNr());
    }

    public QuitRPC addPeerStatusListener(PeerStatusListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public FutureResponse quit(PeerAddress remotePeer, ShutdownBuilder shutdownBuilder, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, RPC.Commands.QUIT.getNr(), Message.Type.REQUEST_FF_1);
        if (shutdownBuilder.isSign()) {
            message.setPublicKeyAndSign(shutdownBuilder.keyPair());
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> requestHandler = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), shutdownBuilder);
        LOG.debug("send QUIT message {}" + message);
        if (!shutdownBuilder.isForceTCP()) {
            return requestHandler.fireAndForgetUDP(channelCreator);
        }
        return requestHandler.sendTCP(channelCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getType() != Message.Type.REQUEST_FF_1 || message.getCommand() != RPC.Commands.QUIT.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        LOG.debug("received QUIT message {}" + message);
        List<PeerStatusListener> list = this.listeners;
        synchronized (list) {
            for (PeerStatusListener listener : this.listeners) {
                listener.peerFailed(message.getSender(), PeerStatusListener.FailReason.Shutdown);
            }
        }
        if (message.isUdp()) {
            responder.responseFireAndForget();
        } else {
            responder.response(this.createResponseMessage(message, Message.Type.OK));
        }
    }
}

