/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Timings;

public class PeerStatatistic
implements Serializable {
    private static final long serialVersionUID = -6225586345726672194L;
    private final AtomicLong lastSeenOnline = new AtomicLong(0L);
    private final long created = Timings.currentTimeMillis();
    private final AtomicInteger successfullyChecked = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private PeerAddress peerAddress;

    public PeerStatatistic(PeerAddress peerAddress) {
        if (peerAddress == null) {
            throw new IllegalArgumentException("PeerAddress cannot be null");
        }
        this.peerAddress = peerAddress;
    }

    public int successfullyChecked() {
        this.lastSeenOnline.set(Timings.currentTimeMillis());
        this.failed.set(0);
        return this.successfullyChecked.incrementAndGet();
    }

    public long getLastSeenOnline() {
        return this.lastSeenOnline.get();
    }

    public int getSuccessfullyChecked() {
        return this.successfullyChecked.get();
    }

    public int failed() {
        return this.failed.incrementAndGet();
    }

    public long getCreated() {
        return this.created;
    }

    public int onlineTime() {
        return (int)(this.lastSeenOnline.get() - this.created);
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public PeerAddress setPeerAddress(PeerAddress peerAddress) {
        if (!this.peerAddress.getPeerId().equals(peerAddress.getPeerId())) {
            throw new IllegalArgumentException("can only update the same peer address");
        }
        PeerAddress previousPeerAddress = this.peerAddress;
        this.peerAddress = peerAddress;
        return previousPeerAddress;
    }
}

