/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.NavigableSet;
import net.tomp2p.futures.FutureShutdown;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class ShutdownBuilder
extends DHTBuilder<ShutdownBuilder> {
    private static final FutureShutdown FUTURE_SHUTDOWN = (FutureShutdown)new FutureShutdown(null).setFailed("shutdown builder - peer is shutting down");
    private Filter filter;

    public ShutdownBuilder(Peer peer) {
        super(peer, peer.getPeerID());
        this.self(this);
    }

    public ShutdownBuilder filter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter filter() {
        return this.filter;
    }

    @Override
    public FutureShutdown start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.setForceUDP();
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(0, 0, 0);
        }
        if (this.requestP2PConfiguration == null) {
            this.requestP2PConfiguration = new RequestP2PConfiguration(10, 0, 10);
        }
        this.preBuild("shutdown-builder");
        if (this.filter == null) {
            this.filter = new Filter(){

                @Override
                public NavigableSet<PeerAddress> filter(NavigableSet<PeerAddress> closePeers) {
                    return closePeers;
                }
            };
        }
        return this.peer.getDistributedHashMap().quit(this);
    }

    @Override
    public ShutdownBuilder setDomainKey(Number160 domainKey) {
        throw new IllegalArgumentException("Cannot be set here");
    }

    public NavigableSet<PeerAddress> filter(NavigableSet<PeerAddress> closePeers) {
        return this.filter.filter(closePeers);
    }

    public static interface Filter {
        public NavigableSet<PeerAddress> filter(NavigableSet<PeerAddress> var1);
    }
}

