/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;

public class PutBuilder
extends DHTBuilder<PutBuilder> {
    private static final FuturePut FUTURE_SHUTDOWN = (FuturePut)new FuturePut(null, 0, 0).setFailed("put builder - peer is shutting down");
    private Map.Entry<Number640, Data> data;
    private Map<Number640, Data> dataMap;
    private Map<Number160, Data> dataMapConvert;
    private boolean putIfAbsent = false;
    private boolean putMeta = false;
    private PublicKey changePublicKey = null;

    public PutBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Map.Entry<Number640, Data> getData() {
        return this.data;
    }

    public PutBuilder setData(Data data) {
        return this.setData(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, Number160.ZERO, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder setData(Number160 contentKey, Data data) {
        return this.setData(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, contentKey, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder setData(Number160 domainKey, Number160 contentKey, Data data) {
        return this.setData(this.locationKey, domainKey, contentKey, this.versionKey == null ? Number160.ZERO : this.versionKey, data);
    }

    public PutBuilder setData(Data data, Number160 versionKey) {
        return this.setData(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, Number160.ZERO, versionKey, data);
    }

    public PutBuilder setData(Number160 contentKey, Data data, Number160 versionKey) {
        return this.setData(this.locationKey, this.domainKey == null ? Number160.ZERO : this.domainKey, contentKey, versionKey, data);
    }

    public PutBuilder setData(final Number160 locationKey, final Number160 domainKey, final Number160 contentKey, final Number160 versionKey, final Data data) {
        this.data = new Map.Entry<Number640, Data>(){

            @Override
            public Data setValue(Data value) {
                return null;
            }

            @Override
            public Data getValue() {
                return data;
            }

            @Override
            public Number640 getKey() {
                return new Number640(locationKey, domainKey, contentKey, versionKey);
            }
        };
        return this;
    }

    @Override
    public PutBuilder setDomainKey(Number160 domainKey) {
        if (this.data != null) {
            this.setData(this.data.getKey().getLocationKey(), domainKey, this.data.getKey().getContentKey(), this.data.getKey().getVersionKey(), this.data.getValue());
        }
        super.setDomainKey(domainKey);
        return this;
    }

    @Override
    public PutBuilder setVersionKey(Number160 versionKey) {
        if (this.data != null) {
            this.setData(this.data.getKey().getLocationKey(), this.data.getKey().getDomainKey(), this.data.getKey().getContentKey(), versionKey, this.data.getValue());
        }
        super.setVersionKey(versionKey);
        return this;
    }

    public PutBuilder setObject(Object object) throws IOException {
        return this.setData(new Data(object));
    }

    public PutBuilder setKeyObject(Number160 contentKey, Object object) throws IOException {
        return this.setData(contentKey, new Data(object));
    }

    public Map<Number640, Data> getDataMap() {
        return this.dataMap;
    }

    public PutBuilder setDataMap(Map<Number640, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public Map<Number160, Data> getDataMapContent() {
        return this.dataMapConvert;
    }

    public PutBuilder setDataMapContent(Map<Number160, Data> dataMapConvert) {
        this.dataMapConvert = dataMapConvert;
        return this;
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public PutBuilder setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
        return this;
    }

    public PutBuilder setPutIfAbsent() {
        this.putIfAbsent = true;
        return this;
    }

    public boolean isPutMeta() {
        return this.putMeta;
    }

    public PutBuilder putMeta(boolean putMeta) {
        this.putMeta = putMeta;
        return this;
    }

    public PutBuilder putMeta() {
        this.putMeta = true;
        return this;
    }

    public PutBuilder changePublicKey(PublicKey changePublicKey) {
        this.changePublicKey = changePublicKey;
        this.putMeta = true;
        this.setSign();
        return this;
    }

    public PublicKey changePublicKey() {
        return this.changePublicKey;
    }

    @Override
    public FuturePut start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("put-builder");
        if (this.data != null) {
            if (this.dataMap == null) {
                this.setDataMap(new HashMap<Number640, Data>(1));
            }
            this.getDataMap().put(this.getData().getKey(), this.getData().getValue());
        }
        if (!this.putMeta && this.dataMap == null && this.dataMapConvert == null) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        if (this.locationKey == null) {
            throw new IllegalArgumentException("You must provide a location key.");
        }
        if (this.domainKey == null) {
            this.domainKey = Number160.ZERO;
        }
        if (this.versionKey == null) {
            this.versionKey = Number160.ZERO;
        }
        return this.peer.getDistributedHashMap().put(this);
    }
}

