/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.Set;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.TrackerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;

public class GetTrackerBuilder
extends TrackerBuilder<GetTrackerBuilder> {
    private EvaluatingSchemeTracker evaluatingScheme;
    private Set<Number160> knownPeers;
    private boolean expectAttachement = false;
    private boolean useSecondaryTrackers = false;

    public GetTrackerBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public EvaluatingSchemeTracker getEvaluatingScheme() {
        return this.evaluatingScheme;
    }

    public GetTrackerBuilder setEvaluatingScheme(EvaluatingSchemeTracker evaluatingScheme) {
        this.evaluatingScheme = evaluatingScheme;
        return this;
    }

    public boolean isExpectAttachement() {
        return this.expectAttachement;
    }

    public GetTrackerBuilder setExpectAttachement() {
        this.expectAttachement = true;
        return this;
    }

    public GetTrackerBuilder setExpectAttachement(boolean expectAttachement) {
        this.expectAttachement = expectAttachement;
        return this;
    }

    public boolean isUseSecondaryTrackers() {
        return this.useSecondaryTrackers;
    }

    public GetTrackerBuilder setUseSecondaryTrackers() {
        this.useSecondaryTrackers = true;
        return this;
    }

    public GetTrackerBuilder setUseSecondaryTrackers(boolean useSecondaryTrackers) {
        this.useSecondaryTrackers = useSecondaryTrackers;
        return this;
    }

    @Override
    public FutureTracker start() {
        if (this.peer.isShutdown()) {
            return FUTURE_TRACKER_SHUTDOWN;
        }
        this.preBuild("get-tracker-builder");
        if (this.knownPeers == null) {
            this.knownPeers = new SimpleBloomFilter<Number160>(1024, 1024);
        }
        return this.peer.getDistributedTracker().get(this);
    }
}

