/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelServerConficuration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.DSASignatureFactory;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerCreator;
import net.tomp2p.connection.PingBuilderFactory;
import net.tomp2p.connection.PipelineFilter;
import net.tomp2p.connection.Ports;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.DefaultBroadcastHandler;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.p2p.MaintenanceTask;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerInit;
import net.tomp2p.p2p.Replication;
import net.tomp2p.p2p.ReplicationExecutor;
import net.tomp2p.p2p.ReplicationFactor;
import net.tomp2p.p2p.ReplicationSender;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.rpc.BroadcastRPC;
import net.tomp2p.rpc.DefaultBloomfilterFactory;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.PingRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.IdentityManagement;
import net.tomp2p.storage.Storage;
import net.tomp2p.storage.StorageLayer;
import net.tomp2p.storage.StorageMemory;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;

public class PeerMaker {
    public static final PublicKey EMPTY_PUBLICKEY = new PublicKey(){
        private static final long serialVersionUID = 4041565007522454573L;

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        @Override
        public String getAlgorithm() {
            return null;
        }
    };
    private static final KeyPair EMPTY_KEYPAIR = new KeyPair(EMPTY_PUBLICKEY, null);
    private static final int MAX_PERMITS_PERMANENT_TCP = 250;
    private static final int MAX_PERMITS_UDP = 250;
    private static final int MAX_PERMITS_TCP = 250;
    private final Number160 peerId;
    private KeyPair keyPair = null;
    private int p2pID = -1;
    private int tcpPort = -1;
    private int udpPort = -1;
    private Bindings interfaceBindings = null;
    private Bindings externalBindings = null;
    private PeerMap peerMap = null;
    private Peer masterPeer = null;
    private ChannelServerConficuration channelServerConfiguration = null;
    private ChannelClientConfiguration channelClientConfiguration = null;
    private PeerStatusListener[] peerStatusListeners = null;
    private Storage storage = null;
    private TrackerStorage trackerStorage = null;
    private Boolean behindFirewall = null;
    private BroadcastHandler broadcastHandler;
    private BloomfilterFactory bloomfilterFactory;
    private ScheduledExecutorService scheduledExecutorService = null;
    private MaintenanceTask maintenanceTask = null;
    private ReplicationExecutor replicationExecutor = null;
    private List<AutomaticFuture> automaticFutures = null;
    private Random random = null;
    private int delayMillis = -1;
    private boolean allPeersReplicate = false;
    private int intervalMillis = -1;
    private int storageIntervalMillis = -1;
    private ReplicationFactor replicationFactor = null;
    private ReplicationSender replicationSender = null;
    private List<PeerInit> toInitialize = new ArrayList<PeerInit>(1);
    private boolean enableHandShakeRPC = true;
    private boolean enableStorageRPC = true;
    private boolean enableNeighborRPC = true;
    private boolean enableQuitRPC = true;
    private boolean enablePeerExchangeRPC = true;
    private boolean enableDirectDataRPC = true;
    private boolean enableTrackerRPC = true;
    private boolean enableTaskRPC = true;
    private boolean enableSynchronizationRPC = true;
    private boolean enableRouting = true;
    private boolean enableDHT = true;
    private boolean enableTracker = true;
    private boolean enableTask = true;
    private boolean enableMaintenance = true;
    private boolean enableIndirectReplication = false;
    private boolean enableBroadcast = true;

    public PeerMaker(Number160 peerId) {
        this.peerId = peerId;
    }

    public PeerMaker(KeyPair keyPair) {
        this.peerId = Utils.makeSHAHash(keyPair.getPublic().getEncoded());
        this.keyPair = keyPair;
    }

    public Peer makeAndListen() throws IOException {
        if (this.behindFirewall == null) {
            this.behindFirewall = false;
        }
        if (this.channelServerConfiguration == null) {
            this.channelServerConfiguration = PeerMaker.createDefaultChannelServerConfiguration();
        }
        if (this.channelClientConfiguration == null) {
            this.channelClientConfiguration = PeerMaker.createDefaultChannelClientConfiguration();
        }
        if (this.keyPair == null) {
            this.keyPair = EMPTY_KEYPAIR;
        }
        if (this.p2pID == -1) {
            this.p2pID = 1;
        }
        if (this.tcpPort == -1) {
            this.tcpPort = 7700;
        }
        if (this.udpPort == -1) {
            this.udpPort = 7700;
        }
        this.channelServerConfiguration.ports(new Ports(this.tcpPort, this.udpPort));
        if (this.interfaceBindings == null) {
            this.interfaceBindings = new Bindings();
        }
        this.channelServerConfiguration.interfaceBindings(this.interfaceBindings);
        if (this.externalBindings == null) {
            this.externalBindings = new Bindings();
        }
        this.channelClientConfiguration.externalBindings(this.externalBindings);
        if (this.peerMap == null) {
            this.peerMap = new PeerMap(new PeerMapConfiguration(this.peerId));
        }
        if (this.storage == null) {
            this.storage = new StorageMemory();
        }
        if (this.storageIntervalMillis == -1) {
            this.storageIntervalMillis = 60000;
        }
        if (this.peerStatusListeners == null) {
            this.peerStatusListeners = new PeerStatusListener[]{this.peerMap};
        }
        if (this.masterPeer == null && this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        PeerCreator peerCreator = this.masterPeer != null ? new PeerCreator(this.masterPeer.peerCreator(), this.peerId, this.keyPair) : new PeerCreator(this.p2pID, this.peerId, this.keyPair, this.channelServerConfiguration, this.channelClientConfiguration, this.peerStatusListeners, this.scheduledExecutorService);
        final Peer peer = new Peer(this.p2pID, this.peerId, peerCreator);
        PeerBean peerBean = peerCreator.peerBean();
        ConnectionBean connectionBean = peerCreator.connectionBean();
        peerBean.peerMap(this.peerMap);
        peerBean.keyPair(this.keyPair);
        StorageLayer sl = new StorageLayer(this.storage);
        peerBean.storage(sl);
        sl.init(connectionBean.timer(), this.storageIntervalMillis);
        if (this.trackerStorage == null) {
            this.trackerStorage = new TrackerStorage(new IdentityManagement(peerBean.serverPeerAddress()), 300, peerBean.getReplicationTracker(), new Maintenance());
        }
        peerBean.trackerStorage(this.trackerStorage);
        if (this.bloomfilterFactory == null) {
            peerBean.bloomfilterFactory(new DefaultBloomfilterFactory());
        }
        if (this.broadcastHandler == null) {
            this.broadcastHandler = new DefaultBroadcastHandler(peer, new Random());
        }
        Replication replicationStorage = new Replication(new StorageLayer(this.storage), peerBean.serverPeerAddress(), this.peerMap, 5);
        peerBean.replicationStorage(replicationStorage);
        this.initRPC(peer, connectionBean, peerBean);
        this.initP2P(peer, connectionBean, peerBean);
        if (this.maintenanceTask == null && this.isEnableMaintenance()) {
            this.maintenanceTask = new MaintenanceTask();
        }
        if (this.maintenanceTask != null) {
            this.maintenanceTask.init(peer, connectionBean.timer());
            this.maintenanceTask.addMaintainable(this.peerMap);
        }
        peerBean.maintenanceTask(this.maintenanceTask);
        if (this.random == null) {
            this.random = new Random();
        }
        if (this.intervalMillis == -1) {
            this.intervalMillis = 60000;
        }
        if (this.delayMillis == -1) {
            this.delayMillis = 30000;
        }
        if (this.replicationFactor == null) {
            this.replicationFactor = new ReplicationFactor(){

                @Override
                public int replicationFactor() {
                    return 6;
                }

                @Override
                public void init(Peer peer) {
                }
            };
        }
        this.replicationFactor.init(peer);
        if (this.replicationSender == null) {
            this.replicationSender = new ReplicationExecutor.DefaultReplicationSender();
        }
        this.replicationSender.init(peer);
        if (this.replicationExecutor == null && this.isEnableIndirectReplication() && this.isEnableStorageRPC()) {
            this.replicationExecutor = new ReplicationExecutor(peer, this.replicationFactor, this.replicationSender, this.random, connectionBean.timer(), this.delayMillis, this.allPeersReplicate);
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.init(this.intervalMillis);
        }
        peerBean.replicationExecutor(this.replicationExecutor);
        if (this.automaticFutures != null) {
            peer.setAutomaticFutures(this.automaticFutures);
        }
        connectionBean.sender().pingBuilderFactory(new PingBuilderFactory(){

            @Override
            public PingBuilder create() {
                return peer.ping();
            }
        });
        for (PeerInit peerInit : this.toInitialize) {
            peerInit.init(peer);
        }
        return peer;
    }

    public static ChannelServerConficuration createDefaultChannelServerConfiguration() {
        ChannelServerConficuration channelServerConfiguration = new ChannelServerConficuration();
        channelServerConfiguration.interfaceBindings(new Bindings());
        channelServerConfiguration.ports(new Ports(7700, 7700));
        channelServerConfiguration.setBehindFirewall(false);
        channelServerConfiguration.pipelineFilter(new DefaultPipelineFilter());
        channelServerConfiguration.signatureFactory(new DSASignatureFactory());
        return channelServerConfiguration;
    }

    public static ChannelClientConfiguration createDefaultChannelClientConfiguration() {
        ChannelClientConfiguration channelClientConfiguration = new ChannelClientConfiguration();
        channelClientConfiguration.externalBindings(new Bindings());
        channelClientConfiguration.maxPermitsPermanentTCP(250);
        channelClientConfiguration.maxPermitsTCP(250);
        channelClientConfiguration.maxPermitsUDP(250);
        channelClientConfiguration.pipelineFilter(new DefaultPipelineFilter());
        channelClientConfiguration.signatureFactory(new DSASignatureFactory());
        return channelClientConfiguration;
    }

    private void initRPC(Peer peer, ConnectionBean connectionBean, PeerBean peerBean) {
        if (this.isEnableHandShakeRPC()) {
            PingRPC handshakeRCP = new PingRPC(peerBean, connectionBean);
            peer.pingRPC(handshakeRCP);
        }
        if (this.isEnableStorageRPC()) {
            StorageRPC storageRPC = new StorageRPC(peerBean, connectionBean);
            peer.setStorageRPC(storageRPC);
        }
        if (this.isEnableNeighborRPC()) {
            NeighborRPC neighborRPC = new NeighborRPC(peerBean, connectionBean);
            peer.setNeighborRPC(neighborRPC);
        }
        if (this.isEnableDirectDataRPC()) {
            DirectDataRPC directDataRPC = new DirectDataRPC(peerBean, connectionBean);
            peer.setDirectDataRPC(directDataRPC);
        }
        if (this.isEnableQuitRPC()) {
            QuitRPC quitRCP = new QuitRPC(peerBean, connectionBean);
            quitRCP.addPeerStatusListener(this.peerMap);
            peer.setQuitRPC(quitRCP);
        }
        if (this.isEnablePeerExchangeRPC()) {
            PeerExchangeRPC peerExchangeRPC = new PeerExchangeRPC(peerBean, connectionBean);
            peer.setPeerExchangeRPC(peerExchangeRPC);
        }
        if (this.isEnableTrackerRPC()) {
            TrackerRPC trackerRPC = new TrackerRPC(peerBean, connectionBean);
            peer.setTrackerRPC(trackerRPC);
        }
        if (this.isEnableBroadcast()) {
            BroadcastRPC broadcastRPC = new BroadcastRPC(peerBean, connectionBean, this.broadcastHandler);
            peer.setBroadcastRPC(broadcastRPC);
        }
    }

    private void initP2P(Peer peer, ConnectionBean connectionBean, PeerBean peerBean) {
        if (this.isEnableRouting() && this.isEnableNeighborRPC()) {
            DistributedRouting routing = new DistributedRouting(peerBean, peer.getNeighborRPC());
            peer.setDistributedRouting(routing);
        }
        if (this.isEnableRouting() && this.isEnableStorageRPC() && this.isEnableDirectDataRPC()) {
            DistributedHashTable dht = new DistributedHashTable(peer.getDistributedRouting(), peer.getStoreRPC(), peer.getDirectDataRPC(), peer.getQuitRPC());
            peer.setDistributedHashMap(dht);
        }
        if (this.isEnableRouting() && this.isEnableTrackerRPC() && this.isEnablePeerExchangeRPC()) {
            DistributedTracker tracker = new DistributedTracker(peerBean, peer.getDistributedRouting(), peer.getTrackerRPC(), peer.getPeerExchangeRPC());
            peer.setDistributedTracker(tracker);
        }
    }

    public Number160 peerId() {
        return this.peerId;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public PeerMaker keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public int p2pId() {
        return this.p2pID;
    }

    public PeerMaker p2pId(int p2pID) {
        this.p2pID = p2pID;
        return this;
    }

    public int tcpPort() {
        return this.tcpPort;
    }

    public PeerMaker tcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
        return this;
    }

    public int udpPort() {
        return this.udpPort;
    }

    public PeerMaker udpPort(int udpPort) {
        this.udpPort = udpPort;
        return this;
    }

    public PeerMaker ports(int port) {
        this.udpPort = port;
        this.tcpPort = port;
        return this;
    }

    public PeerMaker bindings(Bindings bindings) {
        this.interfaceBindings = bindings;
        this.externalBindings = bindings;
        return this;
    }

    public Bindings interfaceBindings() {
        return this.interfaceBindings;
    }

    public PeerMaker interfaceBindings(Bindings interfaceBindings) {
        this.interfaceBindings = interfaceBindings;
        return this;
    }

    public Bindings externalBindings() {
        return this.externalBindings;
    }

    public PeerMaker externalBindings(Bindings externalBindings) {
        this.externalBindings = externalBindings;
        return this;
    }

    public PeerMap peerMap() {
        return this.peerMap;
    }

    public PeerMaker peerMap(PeerMap peerMap) {
        this.peerMap = peerMap;
        return this;
    }

    public Storage storage() {
        return this.storage;
    }

    public PeerMaker storage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public Peer masterPeer() {
        return this.masterPeer;
    }

    public PeerMaker masterPeer(Peer masterPeer) {
        this.masterPeer = masterPeer;
        return this;
    }

    public ChannelServerConficuration channelServerConfiguration() {
        return this.channelServerConfiguration;
    }

    public PeerMaker channelServerConfiguration(ChannelServerConficuration channelServerConfiguration) {
        this.channelServerConfiguration = channelServerConfiguration;
        return this;
    }

    public ChannelClientConfiguration channelClientConfiguration() {
        return this.channelClientConfiguration;
    }

    public PeerMaker channelClientConfiguration(ChannelClientConfiguration channelClientConfiguration) {
        this.channelClientConfiguration = channelClientConfiguration;
        return this;
    }

    public PeerStatusListener[] peerStatusListeners() {
        return this.peerStatusListeners;
    }

    public PeerMaker peerStatusListeners(PeerStatusListener[] peerStatusListeners) {
        this.peerStatusListeners = peerStatusListeners;
        return this;
    }

    public BroadcastHandler broadcastHandler() {
        return this.broadcastHandler;
    }

    public PeerMaker broadcastHandler(BroadcastHandler broadcastHandler) {
        this.broadcastHandler = broadcastHandler;
        return this;
    }

    public BloomfilterFactory bloomfilterFactory() {
        return this.bloomfilterFactory;
    }

    public PeerMaker bloomfilterFactory(BloomfilterFactory bloomfilterFactory) {
        this.bloomfilterFactory = bloomfilterFactory;
        return this;
    }

    public MaintenanceTask maintenanceTask() {
        return this.maintenanceTask;
    }

    public PeerMaker maintenanceTask(MaintenanceTask maintenanceTask) {
        this.maintenanceTask = maintenanceTask;
        return this;
    }

    public ReplicationExecutor replicationExecutor() {
        return this.replicationExecutor;
    }

    public PeerMaker replicationExecutor(ReplicationExecutor replicationExecutor) {
        this.replicationExecutor = replicationExecutor;
        return this;
    }

    public Random random() {
        return this.random;
    }

    public PeerMaker random(Random random) {
        this.random = random;
        return this;
    }

    public int delayMillis() {
        return this.delayMillis;
    }

    public PeerMaker delayMillis(int delayMillis) {
        this.delayMillis = delayMillis;
        return this;
    }

    public boolean isAllPeersReplicate() {
        return this.allPeersReplicate;
    }

    public PeerMaker allPeersReplicate() {
        this.allPeersReplicate = true;
        return this;
    }

    public PeerMaker allPeersReplicate(boolean allPeersReplicate) {
        this.allPeersReplicate = allPeersReplicate;
        return this;
    }

    public int intervalMillis() {
        return this.intervalMillis;
    }

    public PeerMaker intervalMillis(int intervalMillis) {
        this.intervalMillis = intervalMillis;
        return this;
    }

    public int storageIntervalMillis() {
        return this.storageIntervalMillis;
    }

    public PeerMaker storageIntervalMillis(int storageIntervalMillis) {
        this.storageIntervalMillis = storageIntervalMillis;
        return this;
    }

    public ReplicationFactor replicationFactor() {
        return this.replicationFactor;
    }

    public PeerMaker replicationFactor(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public ReplicationSender replicationSender() {
        return this.replicationSender;
    }

    public PeerMaker replicationSender(ReplicationSender replicationSender) {
        this.replicationSender = replicationSender;
        return this;
    }

    public PeerMaker init(PeerInit init) {
        this.toInitialize.add(init);
        return this;
    }

    public PeerMaker init(PeerInit ... inits) {
        for (PeerInit init : inits) {
            this.toInitialize.add(init);
        }
        return this;
    }

    public ScheduledExecutorService timer() {
        return this.scheduledExecutorService;
    }

    public PeerMaker timer(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public boolean isEnableHandShakeRPC() {
        return this.enableHandShakeRPC;
    }

    public PeerMaker setEnableHandShakeRPC(boolean enableHandShakeRPC) {
        this.enableHandShakeRPC = enableHandShakeRPC;
        return this;
    }

    public boolean isEnableStorageRPC() {
        return this.enableStorageRPC;
    }

    public PeerMaker setEnableStorageRPC(boolean enableStorageRPC) {
        this.enableStorageRPC = enableStorageRPC;
        return this;
    }

    public boolean isEnableNeighborRPC() {
        return this.enableNeighborRPC;
    }

    public PeerMaker setEnableNeighborRPC(boolean enableNeighborRPC) {
        this.enableNeighborRPC = enableNeighborRPC;
        return this;
    }

    public boolean isEnableQuitRPC() {
        return this.enableQuitRPC;
    }

    public PeerMaker setEnableQuitRPC(boolean enableQuitRPC) {
        this.enableQuitRPC = enableQuitRPC;
        return this;
    }

    public boolean isEnablePeerExchangeRPC() {
        return this.enablePeerExchangeRPC;
    }

    public PeerMaker setEnablePeerExchangeRPC(boolean enablePeerExchangeRPC) {
        this.enablePeerExchangeRPC = enablePeerExchangeRPC;
        return this;
    }

    public boolean isEnableDirectDataRPC() {
        return this.enableDirectDataRPC;
    }

    public PeerMaker setEnableDirectDataRPC(boolean enableDirectDataRPC) {
        this.enableDirectDataRPC = enableDirectDataRPC;
        return this;
    }

    public boolean isEnableTrackerRPC() {
        return this.enableTrackerRPC;
    }

    public PeerMaker setEnableTrackerRPC(boolean enableTrackerRPC) {
        this.enableTrackerRPC = enableTrackerRPC;
        return this;
    }

    public boolean isEnableTaskRPC() {
        return this.enableTaskRPC;
    }

    public PeerMaker setEnableTaskRPC(boolean enableTaskRPC) {
        this.enableTaskRPC = enableTaskRPC;
        return this;
    }

    public boolean isEnableSynchronizationRPC() {
        return this.enableSynchronizationRPC;
    }

    public PeerMaker setEnableSynchronizationRPC(boolean enableQuitRPC) {
        this.enableQuitRPC = enableQuitRPC;
        return this;
    }

    public boolean isEnableRouting() {
        return this.enableRouting;
    }

    public PeerMaker setEnableRouting(boolean enableRouting) {
        this.enableRouting = enableRouting;
        return this;
    }

    public boolean isEnableDHT() {
        return this.enableDHT;
    }

    public PeerMaker setEnableDHT(boolean enableDHT) {
        this.enableDHT = enableDHT;
        return this;
    }

    public boolean isEnableTracker() {
        return this.enableTracker;
    }

    public PeerMaker setEnableTracker(boolean enableTracker) {
        this.enableTracker = enableTracker;
        return this;
    }

    public boolean isEnableTask() {
        return this.enableTask;
    }

    public PeerMaker setEnableTask(boolean enableTask) {
        this.enableTask = enableTask;
        return this;
    }

    public boolean isEnableMaintenance() {
        return this.enableMaintenance;
    }

    public PeerMaker setEnableMaintenance(boolean enableMaintenance) {
        this.enableMaintenance = enableMaintenance;
        return this;
    }

    public boolean isEnableIndirectReplication() {
        return this.enableIndirectReplication;
    }

    public PeerMaker setEnableIndirectReplication(boolean enableIndirectReplication) {
        this.enableIndirectReplication = enableIndirectReplication;
        return this;
    }

    public boolean isEnableBroadcast() {
        return this.enableBroadcast;
    }

    public PeerMaker setEnableBroadcast(boolean enableBroadcast) {
        this.enableBroadcast = enableBroadcast;
        return this;
    }

    public boolean isBehindFirewall() {
        return this.behindFirewall == null ? false : this.behindFirewall;
    }

    public PeerMaker setBehindFirewall(boolean behindFirewall) {
        this.behindFirewall = behindFirewall;
        return this;
    }

    public PeerMaker setBehindFirewall() {
        this.behindFirewall = true;
        return this;
    }

    public PeerMaker addAutomaticFuture(AutomaticFuture automaticFuture) {
        if (this.automaticFutures == null) {
            this.automaticFutures = new ArrayList<AutomaticFuture>(1);
        }
        this.automaticFutures.add(automaticFuture);
        return this;
    }

    public static class EventExecutorGroupFilter
    implements PipelineFilter {
        private final EventExecutorGroup eventExecutorGroup;

        public EventExecutorGroupFilter(EventExecutorGroup eventExecutorGroup) {
            this.eventExecutorGroup = eventExecutorGroup;
        }

        @Override
        public Map<String, Pair<EventExecutorGroup, ChannelHandler>> filter(Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, boolean tcp, boolean client) {
            this.setExecutor("handler", channelHandlers);
            this.setExecutor("dispatcher", channelHandlers);
            return channelHandlers;
        }

        private void setExecutor(String handlerName, Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers) {
            Pair<EventExecutorGroup, ChannelHandler> pair = channelHandlers.get(handlerName);
            if (pair != null) {
                channelHandlers.put(handlerName, pair.element0(this.eventExecutorGroup));
            }
        }
    }

    public static class DefaultPipelineFilter
    implements PipelineFilter {
        @Override
        public Map<String, Pair<EventExecutorGroup, ChannelHandler>> filter(Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, boolean tcp, boolean client) {
            return channelHandlers;
        }
    }
}

