/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;

public class MessageID
implements Comparable<MessageID> {
    private final int id;
    private final PeerAddress peerAddress;

    public MessageID(Message message) {
        this(message.getMessageId(), message.isRequest() ? message.getSender() : message.getRecipient());
    }

    private MessageID(int id, PeerAddress nodeAddress) {
        this.id = id;
        this.peerAddress = nodeAddress;
    }

    public int getId() {
        return this.id;
    }

    public PeerAddress getNodeAddress() {
        return this.peerAddress;
    }

    @Override
    public int compareTo(MessageID o) {
        int diff = this.id - o.id;
        if (diff == 0) {
            return this.peerAddress.compareTo(o.peerAddress);
        }
        return diff;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessageID)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.compareTo((MessageID)obj) == 0;
    }

    public int hashCode() {
        return this.id ^ this.peerAddress.hashCode();
    }

    public String toString() {
        return "MessageId:" + this.id + "/" + this.peerAddress;
    }
}

