/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;

public class DataMap {
    private final Map<Number640, Data> dataMap;
    private final Map<Number160, Data> dataMapConvert;
    private final Number160 locationKey;
    private final Number160 domainKey;
    private final Number160 versionKey;
    private final boolean convertMeta;

    public DataMap(Map<Number640, Data> dataMap) {
        this(dataMap, false);
    }

    public DataMap(Map<Number640, Data> dataMap, boolean convertMeta) {
        this.dataMap = dataMap;
        this.dataMapConvert = null;
        this.locationKey = null;
        this.domainKey = null;
        this.versionKey = null;
        this.convertMeta = convertMeta;
    }

    public DataMap(Number160 locationKey, Number160 domainKey, Number160 versionKey, Map<Number160, Data> dataMapConvert) {
        this(locationKey, domainKey, versionKey, dataMapConvert, false);
    }

    public DataMap(Number160 locationKey, Number160 domainKey, Number160 versionKey, Map<Number160, Data> dataMapConvert, boolean convertMeta) {
        this.dataMap = null;
        this.dataMapConvert = dataMapConvert;
        this.locationKey = locationKey;
        this.domainKey = domainKey;
        this.versionKey = versionKey;
        this.convertMeta = convertMeta;
    }

    public boolean isConvertMeta() {
        return this.convertMeta;
    }

    public Map<Number640, Data> dataMap() {
        return this.dataMap;
    }

    public Map<Number160, Data> dataMapConvert() {
        return this.dataMapConvert;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 versionKey() {
        return this.versionKey;
    }

    public int size() {
        if (this.dataMap != null) {
            return this.dataMap.size();
        }
        if (this.dataMapConvert != null) {
            return this.dataMapConvert.size();
        }
        return 0;
    }

    public boolean isConvert() {
        return this.dataMapConvert != null;
    }

    public Map<Number640, Data> convertToMap640() {
        return DataMap.convert(this);
    }

    public Map<Number640, Number160> convertToHash() {
        HashMap<Number640, Number160> retVal;
        block3: {
            block2: {
                retVal = new HashMap<Number640, Number160>();
                if (this.dataMap == null) break block2;
                for (Map.Entry<Number640, Data> entry : this.dataMap.entrySet()) {
                    retVal.put(entry.getKey(), entry.getValue().hash());
                }
                break block3;
            }
            if (this.dataMapConvert == null) break block3;
            for (Map.Entry<Number160, Data> entry : this.dataMapConvert.entrySet()) {
                retVal.put(new Number640(this.locationKey, this.domainKey, entry.getKey(), this.versionKey), entry.getValue().hash());
            }
        }
        return retVal;
    }

    private static Map<Number640, Data> convert(DataMap d) {
        Map<Number640, Data> dataMap3;
        if (d.dataMapConvert != null) {
            dataMap3 = new HashMap<Number640, Data>(d.dataMapConvert.size());
            for (Map.Entry<Number160, Data> entry : d.dataMapConvert.entrySet()) {
                dataMap3.put(new Number640(d.locationKey, d.domainKey, entry.getKey(), d.versionKey), entry.getValue());
            }
        } else {
            dataMap3 = d.dataMap;
        }
        return dataMap3;
    }

    public int hashCode() {
        Map<Number640, Data> dataMap = DataMap.convert(this);
        return dataMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataMap)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DataMap d = (DataMap)obj;
        Map<Number640, Data> dataMap2 = DataMap.convert(this);
        Map<Number640, Data> dataMap3 = DataMap.convert(d);
        boolean test1 = Utils.isSameSets(dataMap2.keySet(), dataMap3.keySet());
        boolean test2 = Utils.isSameSets(dataMap2.values(), dataMap3.values());
        return test1 && test2;
    }
}

