/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.DHTBuilder;

public class Reservation {
    private final int maxPermitsUDP;
    private final int maxPermitsTCP;
    private final int maxPermitsPermanentTCP;
    private final Semaphore semaphoreUPD;
    private final Semaphore semaphoreTCP;
    private final Semaphore semaphorePermanentTCP;
    private final ChannelClientConfiguration channelClientConfiguration;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue);
    private final EventLoopGroup workerGroup;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private boolean shutdown = false;
    private final Collection<ChannelCreator> channelCreators = Collections.synchronizedList(new ArrayList());
    private final FutureDone<Void> futureReservationDone = new FutureDone();

    public Reservation(EventLoopGroup workerGroup, ChannelClientConfiguration channelClientConfiguration) {
        this.workerGroup = workerGroup;
        this.maxPermitsUDP = channelClientConfiguration.maxPermitsUDP();
        this.maxPermitsTCP = channelClientConfiguration.maxPermitsTCP();
        this.maxPermitsPermanentTCP = channelClientConfiguration.maxPermitsPermanentTCP();
        this.semaphoreUPD = new Semaphore(this.maxPermitsUDP);
        this.semaphoreTCP = new Semaphore(this.maxPermitsTCP);
        this.semaphorePermanentTCP = new Semaphore(this.maxPermitsPermanentTCP);
        this.channelClientConfiguration = channelClientConfiguration;
    }

    public int pendingRequests() {
        return this.queue.size();
    }

    public FutureChannelCreator create(RoutingConfiguration routingConfiguration, RequestP2PConfiguration requestP2PConfiguration, DHTBuilder<?> builder) {
        if (routingConfiguration == null && requestP2PConfiguration == null) {
            throw new IllegalArgumentException("Both routingConfiguration and requestP2PConfiguration cannot be null");
        }
        int nrConnectionsTCP = 0;
        int nrConnectionsUDP = 0;
        if (requestP2PConfiguration != null) {
            if (builder.isForceUDP()) {
                nrConnectionsUDP = requestP2PConfiguration.getParallel();
            } else {
                nrConnectionsTCP = requestP2PConfiguration.getParallel();
            }
        }
        if (routingConfiguration != null) {
            if (!builder.isForceTCP()) {
                nrConnectionsUDP = Math.max(nrConnectionsUDP, routingConfiguration.getParallel());
            } else {
                nrConnectionsTCP = Math.max(nrConnectionsTCP, routingConfiguration.getParallel());
            }
        }
        return this.create(nrConnectionsUDP, nrConnectionsTCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannelCreator create(final int permitsUDP, final int permitsTCP) {
        if (permitsUDP > this.maxPermitsUDP) {
            throw new IllegalArgumentException("cannot aquire more UDP connections (" + permitsUDP + ") than maximum " + this.maxPermitsUDP);
        }
        if (permitsTCP > this.maxPermitsTCP) {
            throw new IllegalArgumentException("cannot aquire more TCP connections (" + permitsTCP + ") than maximum " + this.maxPermitsTCP);
        }
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        this.read.lock();
        try {
            if (this.shutdown) {
                FutureChannelCreator futureChannelCreator2 = (FutureChannelCreator)futureChannelCreator.setFailed("shutting down");
                return futureChannelCreator2;
            }
            FutureDone<Void> futureChannelCreationDone = new FutureDone<Void>();
            futureChannelCreationDone.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    Reservation.this.semaphoreUPD.release(permitsUDP);
                    Reservation.this.semaphoreTCP.release(permitsTCP);
                }
            }, false);
            this.executor.execute(new WaitReservation(futureChannelCreator, futureChannelCreationDone, permitsUDP, permitsTCP));
            FutureChannelCreator futureChannelCreator3 = futureChannelCreator;
            return futureChannelCreator3;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannelCreator createPermanent(final int permitsPermanentTCP) {
        if (permitsPermanentTCP > this.maxPermitsPermanentTCP) {
            throw new IllegalArgumentException("cannot aquire more TCP connections (" + permitsPermanentTCP + ") than maximum " + this.maxPermitsPermanentTCP);
        }
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        this.read.lock();
        try {
            if (this.shutdown) {
                FutureChannelCreator futureChannelCreator2 = (FutureChannelCreator)futureChannelCreator.setFailed("shutting down");
                return futureChannelCreator2;
            }
            FutureDone futureChannelCreationDone = new FutureDone();
            futureChannelCreationDone.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    Reservation.this.semaphorePermanentTCP.release(permitsPermanentTCP);
                }
            }, false);
            this.executor.execute(new WaitReservationPermanent(futureChannelCreator, futureChannelCreationDone, permitsPermanentTCP));
            FutureChannelCreator futureChannelCreator3 = futureChannelCreator;
            return futureChannelCreator3;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> shutdown() {
        this.write.lock();
        try {
            if (this.shutdown) {
                this.shutdownFuture().setFailed("already shutting down");
                FutureDone<Void> futureDone = this.shutdownFuture();
                return futureDone;
            }
            this.shutdown = true;
        }
        finally {
            this.write.unlock();
        }
        for (Runnable r : this.executor.shutdownNow()) {
            Runnable wr;
            if (r instanceof WaitReservation) {
                wr = (WaitReservation)r;
                ((WaitReservation)wr).futureChannelCreator().setFailed("shutting down");
                continue;
            }
            wr = (WaitReservationPermanent)r;
            ((WaitReservationPermanent)wr).futureChannelCreator().setFailed("shutting down");
        }
        final int size = this.channelCreators.size();
        if (size == 0) {
            this.futureReservationDone.setDone();
        } else {
            final AtomicInteger completeCounter = new AtomicInteger(0);
            for (ChannelCreator channelCreator : this.channelCreators) {
                channelCreator.shutdownFuture().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                    @Override
                    public void operationComplete(FutureDone<Void> future) throws Exception {
                        if (completeCounter.incrementAndGet() == size) {
                            Reservation.this.semaphoreUPD.acquireUninterruptibly(Reservation.this.maxPermitsUDP);
                            Reservation.this.semaphoreTCP.acquireUninterruptibly(Reservation.this.maxPermitsTCP);
                            Reservation.this.semaphorePermanentTCP.acquireUninterruptibly(Reservation.this.maxPermitsPermanentTCP);
                            Reservation.this.shutdownFuture().setDone();
                        }
                    }
                });
                channelCreator.shutdown();
            }
        }
        return this.shutdownFuture();
    }

    public FutureDone<Void> shutdownFuture() {
        return this.futureReservationDone;
    }

    private void addToSet(final ChannelCreator channelCreator) {
        channelCreator.shutdownFuture().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(FutureDone<Void> future) throws Exception {
                Reservation.this.read.lock();
                try {
                    if (Reservation.this.shutdown) {
                        return;
                    }
                    Reservation.this.channelCreators.remove(channelCreator);
                }
                finally {
                    Reservation.this.read.unlock();
                }
            }
        });
        this.channelCreators.add(channelCreator);
    }

    private final class WaitReservationPermanent
    implements Runnable {
        private final FutureChannelCreator futureChannelCreator;
        private final FutureDone<Void> futureChannelCreationShutdown;
        private final int permitsPermanentTCP;

        private WaitReservationPermanent(FutureChannelCreator futureChannelCreator, FutureDone<Void> futureChannelCreationShutdown, int permitsPermanentTCP) {
            this.futureChannelCreator = futureChannelCreator;
            this.futureChannelCreationShutdown = futureChannelCreationShutdown;
            this.permitsPermanentTCP = permitsPermanentTCP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChannelCreator channelCreator;
            Reservation.this.read.lock();
            try {
                if (Reservation.this.shutdown) {
                    this.futureChannelCreator.setFailed("shutting down");
                    return;
                }
                try {
                    Reservation.this.semaphorePermanentTCP.acquire(this.permitsPermanentTCP);
                }
                catch (InterruptedException e) {
                    this.futureChannelCreator.setFailed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                channelCreator = new ChannelCreator(Reservation.this.workerGroup, this.futureChannelCreationShutdown, 0, this.permitsPermanentTCP, Reservation.this.channelClientConfiguration);
                Reservation.this.addToSet(channelCreator);
            }
            finally {
                Reservation.this.read.unlock();
            }
            this.futureChannelCreator.reserved(channelCreator);
        }

        private FutureChannelCreator futureChannelCreator() {
            return this.futureChannelCreator;
        }
    }

    private class WaitReservation
    implements Runnable {
        private final FutureChannelCreator futureChannelCreator;
        private final FutureDone<Void> futureChannelCreationShutdown;
        private final int permitsUDP;
        private final int permitsTCP;

        public WaitReservation(FutureChannelCreator futureChannelCreator, FutureDone<Void> futureChannelCreationShutdown, int permitsUDP, int permitsTCP) {
            this.futureChannelCreator = futureChannelCreator;
            this.futureChannelCreationShutdown = futureChannelCreationShutdown;
            this.permitsUDP = permitsUDP;
            this.permitsTCP = permitsTCP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChannelCreator channelCreator;
            Reservation.this.read.lock();
            try {
                if (Reservation.this.shutdown) {
                    this.futureChannelCreator.setFailed("shutting down");
                    return;
                }
                try {
                    Reservation.this.semaphoreUPD.acquire(this.permitsUDP);
                }
                catch (InterruptedException e) {
                    this.futureChannelCreator.setFailed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                try {
                    Reservation.this.semaphoreTCP.acquire(this.permitsTCP);
                }
                catch (InterruptedException e) {
                    Reservation.this.semaphoreUPD.release(this.permitsUDP);
                    this.futureChannelCreator.setFailed(e);
                    Reservation.this.read.unlock();
                    return;
                }
                channelCreator = new ChannelCreator(Reservation.this.workerGroup, this.futureChannelCreationShutdown, this.permitsUDP, this.permitsTCP, Reservation.this.channelClientConfiguration);
                Reservation.this.addToSet(channelCreator);
            }
            finally {
                Reservation.this.read.unlock();
            }
            this.futureChannelCreator.reserved(channelCreator);
        }

        private FutureChannelCreator futureChannelCreator() {
            return this.futureChannelCreator;
        }
    }
}

