/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.HeartBeat;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.ProgresHandler;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancel;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TomP2PCumulationTCP;
import net.tomp2p.message.TomP2POutbound;
import net.tomp2p.message.TomP2PSinglePacketUDP;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private final PeerStatusListener[] peerStatusListeners;
    private final ChannelClientConfiguration channelClientConfiguration;
    private final Dispatcher dispatcher;
    private final Random random;
    private PingBuilder pingBuilder;

    public Sender(Number160 peerId, PeerStatusListener[] peerStatusListeners, ChannelClientConfiguration channelClientConfiguration, Dispatcher dispatcher) {
        this.peerStatusListeners = peerStatusListeners;
        this.channelClientConfiguration = channelClientConfiguration;
        this.dispatcher = dispatcher;
        this.random = new Random(peerId.hashCode());
    }

    public ChannelClientConfiguration channelClientConfiguration() {
        return this.channelClientConfiguration;
    }

    public PingBuilder pingBuilder() {
        return this.pingBuilder;
    }

    public Sender pingBuilder(PingBuilder pingBuilder) {
        this.pingBuilder = pingBuilder;
        return this;
    }

    public void sendTCP(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleTCPSeconds, int connectTimeoutMillis, PeerConnection peerConnection) {
        if (futureResponse.isCompleted()) {
            return;
        }
        this.removePeerIfFailed(futureResponse, message);
        if (message.getSender().isRelayed()) {
            message.setPeerSocketAddresses(message.getSender().getPeerSocketAddresses());
        }
        if (peerConnection != null && peerConnection.channelFuture() != null && peerConnection.channelFuture().channel().isActive()) {
            ChannelFuture channelFuture = this.sendTCPPeerConnection(peerConnection, (ChannelHandler)handler, channelCreator, futureResponse);
            this.afterConnect(futureResponse, message, channelFuture, handler == null);
        } else if (channelCreator != null) {
            TimeoutFactory timeoutHandler = this.createTimeoutHandler(futureResponse, idleTCPSeconds, handler == null);
            InetSocketAddress recipient = null;
            if (message.getRecipient().isRelayed()) {
                this.handleRelay(handler, futureResponse, message, channelCreator, idleTCPSeconds, connectTimeoutMillis, peerConnection, timeoutHandler);
            } else {
                recipient = message.getRecipient().createSocketTCP();
                ChannelFuture channelFuture = this.sendTCPCreateChannel(recipient, channelCreator, peerConnection, (ChannelHandler)handler, timeoutHandler, connectTimeoutMillis, futureResponse);
                this.afterConnect(futureResponse, message, channelFuture, handler == null);
            }
        }
    }

    private void handleRelay(final SimpleChannelInboundHandler<Message> handler, final FutureResponse futureResponse, final Message message, final ChannelCreator channelCreator, final int idleTCPSeconds, final int connectTimeoutMillis, final PeerConnection peerConnection, final TimeoutFactory timeoutHandler) {
        FutureDone<PeerSocketAddress> futurePing = this.pingFirst(message.getRecipient().getPeerSocketAddresses(), this.pingBuilder);
        futurePing.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<PeerSocketAddress>>(){

            @Override
            public void operationComplete(final FutureDone<PeerSocketAddress> futureDone) throws Exception {
                if (futureDone.isSuccess()) {
                    InetSocketAddress recipient = PeerSocketAddress.createSocketTCP(futureDone.getObject());
                    ChannelFuture channelFuture = Sender.this.sendTCPCreateChannel(recipient, channelCreator, peerConnection, (ChannelHandler)handler, timeoutHandler, connectTimeoutMillis, futureResponse);
                    Sender.this.afterConnect(futureResponse, message, channelFuture, handler == null);
                    futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                        @Override
                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isFailed() && future.getResponse() != null && future.getResponse().getType() != Message.Type.USER1) {
                                this.clearInactivePeerSocketAddress(futureDone);
                                Sender.this.sendTCP((SimpleChannelInboundHandler<Message>)handler, futureResponse, message, channelCreator, idleTCPSeconds, connectTimeoutMillis, peerConnection);
                            }
                        }

                        private void clearInactivePeerSocketAddress(FutureDone<PeerSocketAddress> futureDone2) {
                            ArrayList<PeerSocketAddress> tmp = new ArrayList<PeerSocketAddress>();
                            for (PeerSocketAddress psa : message.getRecipient().getPeerSocketAddresses()) {
                                if (psa == null || psa.equals(futureDone2.getObject())) continue;
                                tmp.add(psa);
                            }
                            message.setPeerSocketAddresses(tmp);
                        }
                    });
                } else {
                    futureResponse.setFailed("no relay could be contacted");
                }
            }
        });
    }

    private FutureDone<PeerSocketAddress> pingFirst(Collection<PeerSocketAddress> peerSocketAddresses, PingBuilder pingBuilder) {
        final FutureDone<PeerSocketAddress> futureDone = new FutureDone<PeerSocketAddress>();
        BaseFuture[] forks = new BaseFuture[peerSocketAddresses.size()];
        int index = 0;
        for (PeerSocketAddress psa : peerSocketAddresses) {
            if (psa == null) continue;
            InetSocketAddress inetSocketAddress = PeerSocketAddress.createSocketUDP(psa);
            forks[index++] = pingBuilder.setInetAddress(inetSocketAddress.getAddress()).setPort(inetSocketAddress.getPort()).start();
        }
        FutureForkJoin<BaseFuture> ffk = new FutureForkJoin<BaseFuture>(1, true, new AtomicReferenceArray<BaseFuture>(forks));
        ffk.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<BaseFuture>>(){

            @Override
            public void operationComplete(FutureForkJoin<BaseFuture> future) throws Exception {
                if (future.isSuccess()) {
                    futureDone.setDone(((FutureResponse)future.getCompleted().get(0)).getResponse().getSender().peerSocketAddress());
                }
            }
        });
        return futureDone;
    }

    private ChannelFuture sendTCPCreateChannel(InetSocketAddress recipient, ChannelCreator channelCreator, PeerConnection peerConnection, ChannelHandler handler, TimeoutFactory timeoutHandler, int connectTimeoutMillis, FutureResponse futureResponse) {
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        int nrTCPHandlers;
        if (timeoutHandler != null) {
            nrTCPHandlers = peerConnection != null ? 10 : 7;
            handlers = new LinkedHashMap(nrTCPHandlers);
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutHandler.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutHandler.timeHandler()));
        } else {
            nrTCPHandlers = 3;
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>(3);
        }
        handlers.put("decoder", new Pair<Object, TomP2PCumulationTCP>(null, new TomP2PCumulationTCP(this.channelClientConfiguration.signatureFactory())));
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(false, this.channelClientConfiguration.signatureFactory())));
        if (peerConnection != null) {
            handlers.put("dispatcher", new Pair<Object, Dispatcher>(null, this.dispatcher));
        }
        if (timeoutHandler != null) {
            handlers.put("handler", new Pair<Object, ChannelHandler>(null, handler));
        }
        HeartBeat heartBeat = null;
        if (peerConnection != null) {
            heartBeat = new HeartBeat(peerConnection.heartBeatMillis(), TimeUnit.MILLISECONDS, this.pingBuilder);
            handlers.put("heartbeat", new Pair<Object, HeartBeat>(null, heartBeat));
        }
        ChannelFuture channelFuture = channelCreator.createTCP(recipient, connectTimeoutMillis, handlers, futureResponse);
        if (peerConnection != null && channelFuture != null) {
            peerConnection.channelFuture(channelFuture);
            heartBeat.peerConnection(peerConnection);
        }
        return channelFuture;
    }

    private ChannelFuture sendTCPPeerConnection(PeerConnection peerConnection, ChannelHandler handler, ChannelCreator channelCreator, FutureResponse futureResponse) {
        ChannelFuture channelFuture = peerConnection.channelFuture();
        if (channelCreator != null) {
            channelCreator.setupCloseListener(channelFuture, futureResponse);
        }
        ChannelPipeline pipeline = channelFuture.channel().pipeline();
        this.addOrReplace(pipeline, "dispatcher", "handler", handler);
        return channelFuture;
    }

    private boolean addOrReplace(ChannelPipeline pipeline, String before, String name, ChannelHandler channelHandler) {
        List names = pipeline.names();
        if (names.contains(name)) {
            pipeline.replace(name, name, channelHandler);
            return false;
        }
        if (before == null) {
            pipeline.addFirst(name, channelHandler);
        } else {
            pipeline.addBefore(before, name, channelHandler);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendUDP(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleUDPSeconds, boolean broadcast) {
        ChannelFuture channelFuture;
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        int nrTCPHandlers;
        boolean isFireAndForget;
        if (futureResponse.isCompleted()) {
            return;
        }
        this.removePeerIfFailed(futureResponse, message);
        if (message.getSender().isRelayed()) {
            message.setPeerSocketAddresses(message.getSender().getPeerSocketAddresses());
        }
        boolean bl = isFireAndForget = handler == null;
        if (isFireAndForget) {
            nrTCPHandlers = 3;
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>(3);
        } else {
            nrTCPHandlers = 7;
            handlers = new LinkedHashMap(7);
            TimeoutFactory timeoutHandler = this.createTimeoutHandler(futureResponse, idleUDPSeconds, isFireAndForget);
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutHandler.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutHandler.timeHandler()));
        }
        handlers.put("decoder", new Pair<Object, TomP2PSinglePacketUDP>(null, new TomP2PSinglePacketUDP(this.channelClientConfiguration.signatureFactory())));
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(false, this.channelClientConfiguration.signatureFactory())));
        if (!isFireAndForget) {
            handlers.put("handler", new Pair<Object, SimpleChannelInboundHandler<Message>>(null, handler));
        }
        if (message.getRecipient().isRelayed() && message.getCommand() != RPC.Commands.NEIGHBOR.getNr() && message.getCommand() != RPC.Commands.PING.getNr()) {
            LOG.warn("Tried to send UDP message to unreachable peers. Only TCP messages can be sent to unreachable peers: {}", (Object)message);
            futureResponse.setFailed("Tried to send UDP message to unreachable peers. Only TCP messages can be sent to unreachable peers");
            return;
        }
        if (message.getRecipient().isRelayed()) {
            ArrayList<PeerSocketAddress> psa = new ArrayList<PeerSocketAddress>(message.getRecipient().getPeerSocketAddresses());
            LOG.debug("send neighbor request to random relay peer {}", psa);
            if (psa.size() <= 0) {
                futureResponse.setFailed("Peer is relayed, but no relay given");
                return;
            }
            PeerSocketAddress ps = (PeerSocketAddress)psa.get(this.random.nextInt(psa.size()));
            PeerAddress recipient = message.getRecipient();
            message.setRecipient(recipient.changePeerSocketAddress(ps));
            channelFuture = channelCreator.createUDP(PeerSocketAddress.createSocketUDP(ps), broadcast, handlers, futureResponse);
        } else {
            channelFuture = channelCreator.createUDP(message.getRecipient().createSocketUDP(), broadcast, handlers, futureResponse);
        }
        this.afterConnect(futureResponse, message, channelFuture, handler == null);
    }

    private TimeoutFactory createTimeoutHandler(FutureResponse futureResponse, int idleMillis, boolean fireAndForget) {
        return fireAndForget ? null : new TimeoutFactory(futureResponse, idleMillis, this.peerStatusListeners, "Sender");
    }

    private void afterConnect(final FutureResponse futureResponse, final Message message, ChannelFuture channelFuture, final boolean fireAndForget) {
        if (channelFuture == null) {
            futureResponse.setFailed("could not create a " + (message.isUdp() ? "UDP" : "TCP") + " channel");
            return;
        }
        final Cancel connectCancel = Sender.createCancel(channelFuture);
        futureResponse.addCancel(connectCancel);
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture future) throws Exception {
                futureResponse.removeCancel(connectCancel);
                if (future.isSuccess()) {
                    futureResponse.setProgressHandler(new ProgresHandler(){

                        @Override
                        public void progres() {
                            ChannelFuture writeFuture = future.channel().writeAndFlush((Object)message);
                            Sender.this.afterSend(writeFuture, futureResponse, fireAndForget);
                        }
                    });
                    futureResponse.progressFirst();
                } else {
                    futureResponse.setFailed("Channel creation failed " + future.cause());
                    if (!(future.cause() instanceof CancellationException) && !(future.cause() instanceof ClosedChannelException)) {
                        LOG.warn("Channel creation failed ", future.cause());
                    }
                }
            }
        });
    }

    private void afterSend(ChannelFuture writeFuture, final FutureResponse futureResponse, final boolean fireAndForget) {
        final Cancel writeCancel = Sender.createCancel(writeFuture);
        writeFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                futureResponse.removeCancel(writeCancel);
                if (!future.isSuccess()) {
                    futureResponse.setFailedLater(future.cause());
                    Sender.this.reportFailed(futureResponse, future.channel().close());
                    LOG.warn("Failed to write channel the request {} {}", (Object)futureResponse.getRequest(), (Object)future.cause());
                }
                if (fireAndForget) {
                    futureResponse.setResponseLater(null);
                    LOG.debug("fire and forget, close channel now {}, {}", (Object)futureResponse.getRequest(), (Object)future.channel());
                    Sender.this.reportMessage(futureResponse, future.channel().close());
                }
            }
        });
    }

    private void reportFailed(final FutureResponse futureResponse, ChannelFuture close) {
        close.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.setResponseNow();
            }
        });
    }

    private void reportMessage(final FutureResponse futureResponse, ChannelFuture close) {
        close.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.setResponseNow();
            }
        });
    }

    private static Cancel createCancel(final ChannelFuture channelFuture) {
        return new Cancel(){

            @Override
            public void cancel() {
                channelFuture.cancel(true);
            }
        };
    }

    private void removePeerIfFailed(FutureResponse futureResponse, final Message message) {
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

            @Override
            public void operationComplete(BaseFuture future) throws Exception {
                if (future.isFailed() && !message.getRecipient().isRelayed()) {
                    for (PeerStatusListener peerStatusListener : Sender.this.peerStatusListeners) {
                        peerStatusListener.peerFailed(message.getRecipient(), PeerStatusListener.FailReason.Exception);
                    }
                }
            }
        });
    }
}

