/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerFilter;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.ConcurrentCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerMap
implements PeerStatusListener,
Maintainable {
    private static final Logger LOG = LoggerFactory.getLogger(PeerMap.class);
    private final int bagSizeVerified;
    private final int bagSizeOverflow;
    private final Number160 self;
    private final List<Map<Number160, PeerStatatistic>> peerMapVerified;
    private final List<Map<Number160, PeerStatatistic>> peerMapOverflow;
    private final ConcurrentCacheMap<Number160, PeerAddress> offlineMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> shutdownMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> exceptionMap;
    private final List<PeerMapChangeListener> peerMapChangeListeners = new ArrayList<PeerMapChangeListener>();
    private final Collection<PeerFilter> peerFilters;
    private final int offlineCount;
    private final Maintenance maintenance;
    private final boolean peerVerification;

    public PeerMap(PeerMapConfiguration peerMapConfiguration) {
        this.self = peerMapConfiguration.self();
        if (this.self == null || this.self.isZero()) {
            throw new IllegalArgumentException("Zero or null are not a valid IDs");
        }
        this.bagSizeVerified = peerMapConfiguration.bagSizeVerified();
        this.bagSizeOverflow = peerMapConfiguration.bagSizeOverflow();
        this.offlineCount = peerMapConfiguration.offlineCount();
        this.peerFilters = peerMapConfiguration.peerFilters();
        this.peerMapVerified = this.initFixedMap(this.bagSizeVerified, false);
        this.peerMapOverflow = this.initFixedMap(this.bagSizeOverflow, true);
        this.offlineMap = new ConcurrentCacheMap(peerMapConfiguration.offlineTimeout(), this.bagSizeVerified * 160);
        this.shutdownMap = new ConcurrentCacheMap(peerMapConfiguration.shutdownTimeout(), this.bagSizeVerified * 160);
        this.exceptionMap = new ConcurrentCacheMap(peerMapConfiguration.exceptionTimeout(), this.bagSizeVerified * 160);
        this.maintenance = peerMapConfiguration.maintenance().init(this.peerMapVerified, this.peerMapOverflow, this.offlineMap, this.shutdownMap, this.exceptionMap);
        this.peerVerification = peerMapConfiguration.isPeerVerification();
    }

    private List<Map<Number160, PeerStatatistic>> initFixedMap(int bagSize, boolean caching) {
        ArrayList tmp = new ArrayList();
        for (int i = 0; i < 160; ++i) {
            if (caching) {
                tmp.add(new CacheMap(bagSize, true));
                continue;
            }
            int memAlloc = Math.max(0, bagSize - (160 - i));
            tmp.add(new HashMap(memAlloc));
        }
        return Collections.unmodifiableList(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            this.peerMapChangeListeners.add(peerMapChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            this.peerMapChangeListeners.add(peerMapChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInsert(PeerAddress peerAddress, boolean verified) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerInserted(peerAddress, verified);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRemove(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerRemoved(peerAddress, storedPeerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpdate(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
        List<PeerMapChangeListener> list = this.peerMapChangeListeners;
        synchronized (list) {
            for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
                listener.peerUpdated(peerAddress, storedPeerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        Iterator<Map<Number160, PeerStatatistic>> i$ = this.peerMapVerified.iterator();
        while (i$.hasNext()) {
            Map<Number160, PeerStatatistic> map;
            Map<Number160, PeerStatatistic> map2 = map = i$.next();
            synchronized (map2) {
                size += map.size();
            }
        }
        return size;
    }

    public Number160 self() {
        return this.self;
    }

    private boolean reject(PeerAddress peerAddress) {
        if (this.peerFilters == null || this.peerFilters.size() == 0) {
            return false;
        }
        List<PeerAddress> all = this.getAll();
        for (PeerFilter peerFilter : this.peerFilters) {
            if (!peerFilter.reject(peerAddress, all, this.self)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer) {
        Map<Number160, PeerStatatistic> mapOverflow;
        boolean probablyDead;
        boolean thirdHand;
        boolean firstHand = referrer == null || !this.peerVerification;
        boolean secondHand = remotePeer.equals(referrer);
        boolean bl = thirdHand = !firstHand && !secondHand;
        if (firstHand) {
            this.offlineMap.remove(remotePeer.getPeerId());
            this.shutdownMap.remove(remotePeer.getPeerId());
        }
        if (remotePeer.getPeerId().isZero() || this.self().equals(remotePeer.getPeerId()) || this.reject(remotePeer)) {
            return false;
        }
        if (remotePeer.isFirewalledTCP() || remotePeer.isFirewalledUDP()) {
            return false;
        }
        boolean bl2 = probablyDead = this.offlineMap.containsKey(remotePeer.getPeerId()) || this.shutdownMap.containsKey(remotePeer.getPeerId()) || this.exceptionMap.containsKey(remotePeer.getPeerId());
        if (thirdHand && probablyDead) {
            LOG.debug("don't add {}", (Object)remotePeer.getPeerId());
            return false;
        }
        int classMember = this.classMember(remotePeer.getPeerId());
        PeerStatatistic oldPeerStatatistic = PeerMap.updateExistingVerifiedPeerAddress(this.peerMapVerified.get(classMember), remotePeer, firstHand);
        if (oldPeerStatatistic != null) {
            this.notifyUpdate(remotePeer, oldPeerStatatistic);
            return true;
        }
        if (firstHand) {
            Map<Number160, PeerStatatistic> map = this.peerMapVerified.get(classMember);
            boolean insterted = false;
            Map<Number160, PeerStatatistic> map2 = map;
            synchronized (map2) {
                if (map.containsKey(remotePeer.getPeerId())) {
                    return this.peerFound(remotePeer, referrer);
                }
                if (map.size() < this.bagSizeVerified) {
                    PeerStatatistic peerStatatistic = new PeerStatatistic(remotePeer);
                    peerStatatistic.successfullyChecked();
                    map.put(remotePeer.getPeerId(), peerStatatistic);
                    insterted = true;
                }
            }
            if (insterted) {
                Map<Number160, PeerStatatistic> mapOverflow2;
                Map<Number160, PeerStatatistic> map3 = mapOverflow2 = this.peerMapOverflow.get(classMember);
                synchronized (map3) {
                    mapOverflow2.remove(remotePeer.getPeerId());
                }
                this.notifyInsert(remotePeer, true);
                return true;
            }
        }
        Map<Number160, PeerStatatistic> map = mapOverflow = this.peerMapOverflow.get(classMember);
        synchronized (map) {
            PeerStatatistic peerStatatistic = mapOverflow.get(remotePeer.getPeerId());
            if (peerStatatistic == null) {
                peerStatatistic = new PeerStatatistic(remotePeer);
            }
            if (firstHand) {
                peerStatatistic.successfullyChecked();
            }
            mapOverflow.put(remotePeer.getPeerId(), peerStatatistic);
        }
        this.notifyInsert(remotePeer, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerFailed(PeerAddress remotePeer, PeerStatusListener.FailReason reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("peer " + remotePeer + " is offline");
        }
        if (remotePeer.getPeerId().isZero() || this.self().equals(remotePeer.getPeerId())) {
            return false;
        }
        int classMember = this.classMember(remotePeer.getPeerId());
        if (reason != PeerStatusListener.FailReason.Timeout) {
            if (reason == PeerStatusListener.FailReason.ProbablyOffline) {
                this.offlineMap.put(remotePeer.getPeerId(), remotePeer);
            } else if (reason == PeerStatusListener.FailReason.Shutdown) {
                this.shutdownMap.put(remotePeer.getPeerId(), remotePeer);
            } else {
                this.exceptionMap.put(remotePeer.getPeerId(), remotePeer);
            }
            Map<Number160, PeerStatatistic> tmp = this.peerMapOverflow.get(classMember);
            if (tmp != null) {
                Map<Number160, PeerStatatistic> map = tmp;
                synchronized (map) {
                    tmp.remove(remotePeer.getPeerId());
                }
            }
            if ((tmp = this.peerMapVerified.get(classMember)) != null) {
                PeerStatatistic peerStatatistic;
                boolean removed = false;
                Map<Number160, PeerStatatistic> map = tmp;
                synchronized (map) {
                    peerStatatistic = tmp.remove(remotePeer.getPeerId());
                    if (peerStatatistic != null) {
                        removed = true;
                    }
                }
                if (removed) {
                    this.notifyRemove(remotePeer, peerStatatistic);
                    return true;
                }
            }
            return false;
        }
        if (PeerMap.updatePeerStatistic(remotePeer, this.peerMapVerified.get(classMember), this.offlineCount)) {
            return this.peerFailed(remotePeer, PeerStatusListener.FailReason.ProbablyOffline);
        }
        if (PeerMap.updatePeerStatistic(remotePeer, this.peerMapOverflow.get(classMember), this.offlineCount)) {
            return this.peerFailed(remotePeer, PeerStatusListener.FailReason.ProbablyOffline);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(PeerAddress peerAddress) {
        Map<Number160, PeerStatatistic> tmp;
        int classMember = this.classMember(peerAddress.getPeerId());
        if (classMember == -1) {
            return false;
        }
        Map<Number160, PeerStatatistic> map = tmp = this.peerMapVerified.get(classMember);
        synchronized (map) {
            return tmp.containsKey(peerAddress.getPeerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOverflow(PeerAddress peerAddress) {
        Map<Number160, PeerStatatistic> tmp;
        int classMember = this.classMember(peerAddress.getPeerId());
        if (classMember == -1) {
            return false;
        }
        Map<Number160, PeerStatatistic> map = tmp = this.peerMapOverflow.get(classMember);
        synchronized (map) {
            return tmp.containsKey(peerAddress.getPeerId());
        }
    }

    public NavigableSet<PeerAddress> closePeers(int atLeast) {
        return this.closePeers(this.self, atLeast);
    }

    public NavigableSet<PeerAddress> closePeers(Number160 id, int atLeast) {
        return PeerMap.closePeers(this.self(), id, atLeast, this.peerMapVerified);
    }

    public static NavigableSet<PeerAddress> closePeers(Number160 self, Number160 other, int atLeast, List<Map<Number160, PeerStatatistic>> peerMap) {
        int i;
        TreeSet<PeerAddress> set = new TreeSet<PeerAddress>(PeerMap.createComparator(other));
        int classMember = PeerMap.classMember(self, other);
        if (classMember == -1) {
            for (int j = 0; j < 160; ++j) {
                Map<Number160, PeerStatatistic> tmp = peerMap.get(j);
                if (!PeerMap.fillSet(atLeast, set, tmp)) continue;
                return set;
            }
            return set;
        }
        Map<Number160, PeerStatatistic> tmp = peerMap.get(classMember);
        if (PeerMap.fillSet(atLeast, set, tmp)) {
            return set;
        }
        boolean last = false;
        for (i = 0; i < classMember; ++i) {
            tmp = peerMap.get(i);
            last = PeerMap.fillSet(atLeast, set, tmp);
        }
        if (last) {
            return set;
        }
        for (i = classMember + 1; i < 160; ++i) {
            tmp = peerMap.get(i);
            PeerMap.fillSet(atLeast, set, tmp);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("I'm node ");
        sb.append(this.self()).append("\n");
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerStatatistic> tmp;
            Map<Number160, PeerStatatistic> map = tmp = this.peerMapVerified.get(i);
            synchronized (map) {
                if (tmp.size() > 0) {
                    sb.append("class:").append(i).append("->\n");
                    for (PeerStatatistic node : tmp.values()) {
                        sb.append("node:").append(node.getPeerAddress()).append(",");
                    }
                }
                continue;
            }
        }
        return sb.toString();
    }

    public Comparator<PeerAddress> createComparator() {
        return PeerMap.createComparator(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerAddress> getAll() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerStatatistic>> i$ = this.peerMapVerified.iterator();
        while (i$.hasNext()) {
            Map<Number160, PeerStatatistic> map;
            Map<Number160, PeerStatatistic> map2 = map = i$.next();
            synchronized (map2) {
                for (PeerStatatistic peerStatatistic : map.values()) {
                    all.add(peerStatatistic.getPeerAddress());
                }
            }
        }
        return all;
    }

    public List<Map<Number160, PeerStatatistic>> peerMapVerified() {
        return this.peerMapVerified;
    }

    public List<Map<Number160, PeerStatatistic>> peerMapOverflow() {
        return this.peerMapOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerAddress> getAllOverflow() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerStatatistic>> i$ = this.peerMapOverflow.iterator();
        while (i$.hasNext()) {
            Map<Number160, PeerStatatistic> map;
            Map<Number160, PeerStatatistic> map2 = map = i$.next();
            synchronized (map2) {
                for (PeerStatatistic peerStatatistic : map.values()) {
                    all.add(peerStatatistic.getPeerAddress());
                }
            }
        }
        return all;
    }

    public boolean isPeerRemovedTemporarly(PeerAddress peerAddress) {
        return this.offlineMap.containsKey(peerAddress.getPeerId()) || this.shutdownMap.containsKey(peerAddress.getPeerId()) || this.exceptionMap.containsKey(peerAddress.getPeerId());
    }

    @Override
    public PeerStatatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        return this.maintenance.nextForMaintenance(notInterestedAddresses);
    }

    private int classMember(Number160 remoteID) {
        return PeerMap.classMember(this.self(), remoteID);
    }

    public static int isCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.isKadCloser(id, rn, rn2);
    }

    public static int isCloser(Number160 id, Number160 rn, Number160 rn2) {
        return PeerMap.distance(id, rn).compareTo(PeerMap.distance(id, rn2));
    }

    public static int isKadCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.distance(id, rn.getPeerId()).compareTo(PeerMap.distance(id, rn2.getPeerId()));
    }

    public static Comparator<PeerAddress> createComparator(final Number160 id) {
        return new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress remotePeer, PeerAddress remotePeer2) {
                return PeerMap.isKadCloser(id, remotePeer, remotePeer2);
            }
        };
    }

    static int classMember(Number160 id1, Number160 id2) {
        return PeerMap.distance(id1, id2).bitLength() - 1;
    }

    static Number160 distance(Number160 id1, Number160 id2) {
        return id1.xor(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updatePeerStatistic(PeerAddress remotePeer, Map<Number160, PeerStatatistic> tmp, int maxFail) {
        if (tmp != null) {
            Map<Number160, PeerStatatistic> map = tmp;
            synchronized (map) {
                PeerStatatistic peerStatatistic = tmp.get(remotePeer.getPeerId());
                if (peerStatatistic != null && peerStatatistic.failed() >= maxFail) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PeerStatatistic updateExistingVerifiedPeerAddress(Map<Number160, PeerStatatistic> tmp, PeerAddress peerAddress, boolean firstHand) {
        Map<Number160, PeerStatatistic> map = tmp;
        synchronized (map) {
            PeerStatatistic old = tmp.get(peerAddress.getPeerId());
            if (old != null) {
                old.setPeerAddress(peerAddress);
                if (firstHand) {
                    old.successfullyChecked();
                }
                return old;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fillSet(int atLeast, SortedSet<PeerAddress> set, Map<Number160, PeerStatatistic> tmp) {
        Map<Number160, PeerStatatistic> map = tmp;
        synchronized (map) {
            for (PeerStatatistic peerStatatistic : tmp.values()) {
                set.add(peerStatatistic.getPeerAddress());
            }
        }
        return set.size() >= atLeast;
    }

    public int bagSizeVerified() {
        return this.bagSizeVerified;
    }

    public int bagSizeOverflow() {
        return this.bagSizeOverflow;
    }
}

