/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.tomp2p.peers.PeerAddress;

public class NeighborSet {
    private final int neighborLimit;
    private final Collection<PeerAddress> neighbors;

    public NeighborSet(int neighborLimit) {
        this.neighborLimit = neighborLimit;
        this.neighbors = new ArrayList<PeerAddress>();
    }

    public NeighborSet(int neighborLimit, Collection<PeerAddress> neighbors) {
        this.neighborLimit = neighborLimit;
        this.neighbors = neighbors;
        int serializedSize = 1;
        if (neighborLimit < 0) {
            return;
        }
        Iterator<PeerAddress> iterator = neighbors.iterator();
        while (iterator.hasNext()) {
            PeerAddress neighbor = iterator.next();
            if ((serializedSize += neighbor.size()) <= neighborLimit) continue;
            iterator.remove();
        }
    }

    public Collection<PeerAddress> neighbors() {
        return this.neighbors;
    }

    public void addResult(Collection<PeerAddress> neighbors) {
        this.neighbors.addAll(neighbors);
    }

    public void add(PeerAddress neighbor) {
        this.neighbors.add(neighbor);
    }

    public int size() {
        return this.neighbors.size();
    }

    public int neighborLimit() {
        return this.neighborLimit;
    }
}

