/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;

public class MultiByteBufferInputStream
extends InputStream {
    private final ByteBuf channelBuffer;

    public MultiByteBufferInputStream(ByteBuf channelBuffer) {
        this.channelBuffer = channelBuffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.channelBuffer.isReadable()) {
            return -1;
        }
        return this.channelBuffer.readUnsignedByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int len2 = this.channelBuffer.readableBytes();
        int read = Math.min(len, len2);
        this.channelBuffer.readBytes(b, off, read);
        return read;
    }
}

