/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class CacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 5937613180687142367L;
    private final int maxEntries;
    private final boolean updateEntryOnInsert;

    public CacheMap(int maxEntries, boolean updateEntryOnInsert) {
        this.maxEntries = maxEntries;
        this.updateEntryOnInsert = updateEntryOnInsert;
    }

    @Override
    public V put(K key, V value) {
        if (this.updateEntryOnInsert) {
            return super.put(key, value);
        }
        return this.putIfAbsent(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            return super.put(key, value);
        }
        return super.get(key);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxEntries;
    }
}

