/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.concurrent.ConcurrentHashMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;

public class IdentityManagement
implements PeerStatusListener {
    private final ConcurrentHashMap<Number160, PublicKey> peerIdentity = new ConcurrentHashMap();
    private final PeerAddress self;

    public IdentityManagement(PeerAddress self) {
        this.self = self;
    }

    public boolean checkIdentity(Number160 peerId, PublicKey publicKey) {
        PublicKey storedIdentity = this.peerIdentity.get(peerId);
        if (storedIdentity != null) {
            return storedIdentity.equals(publicKey);
        }
        if (publicKey != null) {
            if (this.peerIdentity.putIfAbsent(peerId, publicKey) != null) {
                return this.checkIdentity(peerId, publicKey);
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean peerFailed(PeerAddress peerAddress, PeerStatusListener.FailReason reason) {
        return false;
    }

    @Override
    public boolean peerFound(PeerAddress peerAddress, PeerAddress referrer) {
        return false;
    }

    public Number160 getSelf() {
        return this.self.getPeerId();
    }

    public PeerAddress getPeerAddress() {
        return this.self;
    }
}

