/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.builder.AddBuilder;
import net.tomp2p.p2p.builder.DigestBuilder;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.p2p.builder.RemoveBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageLayer;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StorageRPC.class);
    private static final Random RND = new Random();
    private final BloomfilterFactory factory;

    public StorageRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.PUT.getNr(), RPC.Commands.GET.getNr(), RPC.Commands.ADD.getNr(), RPC.Commands.REMOVE.getNr(), RPC.Commands.DIGEST.getNr(), RPC.Commands.DIGEST_BLOOMFILTER.getNr(), RPC.Commands.PUT_META.getNr(), RPC.Commands.DIGEST_META_VALUES.getNr());
        this.factory = peerBean.bloomfilterFactory();
    }

    public FutureResponse put(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Message.Type request = putBuilder.isProtectDomain() ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        return this.put(remotePeer, putBuilder, request, channelCreator);
    }

    public FutureResponse putIfAbsent(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Message.Type request = putBuilder.isProtectDomain() ? Message.Type.REQUEST_4 : Message.Type.REQUEST_3;
        return this.put(remotePeer, putBuilder, request, channelCreator);
    }

    private FutureResponse put(PeerAddress remotePeer, PutBuilder putBuilder, Message.Type type, ChannelCreator channelCreator) {
        Utils.nullCheck(remotePeer);
        DataMap dataMap = putBuilder.getDataMap() != null ? new DataMap(putBuilder.getDataMap()) : new DataMap(putBuilder.getLocationKey(), putBuilder.getDomainKey(), putBuilder.getVersionKey(), putBuilder.getDataMapContent());
        Message message = this.createMessage(remotePeer, RPC.Commands.PUT.getNr(), type);
        if (putBuilder.isSign()) {
            message.setPublicKeyAndSign(putBuilder.keyPair());
        }
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), putBuilder);
        if (!putBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse putMeta(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Utils.nullCheck(remotePeer);
        DataMap dataMap = putBuilder.getDataMap() != null ? new DataMap(putBuilder.getDataMap()) : new DataMap(putBuilder.getLocationKey(), putBuilder.getDomainKey(), putBuilder.getVersionKey(), putBuilder.getDataMapContent());
        Message.Type type = putBuilder.changePublicKey() != null ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        Message message = this.createMessage(remotePeer, RPC.Commands.PUT_META.getNr(), type);
        if (putBuilder.isSign()) {
            message.setPublicKeyAndSign(putBuilder.keyPair());
        } else if (type == Message.Type.REQUEST_2) {
            throw new IllegalAccessError("can only change public key if message is signed");
        }
        if (putBuilder.changePublicKey() != null) {
            message.setKey(putBuilder.getLocationKey());
            message.setKey(putBuilder.getDomainKey());
            message.setPublicKey(putBuilder.changePublicKey());
        } else {
            message.setDataMap(dataMap);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), putBuilder);
        if (!putBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse add(PeerAddress remotePeer, AddBuilder addBuilder, ChannelCreator channelCreator) {
        Utils.nullCheck(remotePeer, addBuilder.getLocationKey(), addBuilder.getDomainKey());
        Message.Type type = addBuilder.isProtectDomain() ? (addBuilder.isList() ? Message.Type.REQUEST_4 : Message.Type.REQUEST_2) : (addBuilder.isList() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>(addBuilder.getDataSet().size());
        if (addBuilder.getDataSet() != null) {
            for (Data data : addBuilder.getDataSet()) {
                if (addBuilder.isList()) {
                    Number160 hash = new Number160(addBuilder.random());
                    while (dataMap.containsKey(hash)) {
                        hash = new Number160(addBuilder.random());
                    }
                    dataMap.put(hash, data);
                    continue;
                }
                dataMap.put(data.hash(), data);
            }
        }
        Message message = this.createMessage(remotePeer, RPC.Commands.ADD.getNr(), type);
        if (addBuilder.isSign()) {
            message.setPublicKeyAndSign(addBuilder.keyPair());
        }
        message.setDataMap(new DataMap(addBuilder.getLocationKey(), addBuilder.getDomainKey(), addBuilder.getVersionKey(), dataMap));
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), addBuilder);
        if (!addBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse digest(PeerAddress remotePeer, DigestBuilder getBuilder, ChannelCreator channelCreator) {
        Byte command = getBuilder.isReturnBloomFilter() ? Byte.valueOf(RPC.Commands.DIGEST_BLOOMFILTER.getNr()) : (getBuilder.isReturnMetaValues() ? Byte.valueOf(RPC.Commands.DIGEST_META_VALUES.getNr()) : Byte.valueOf(RPC.Commands.DIGEST.getNr()));
        Message.Type type = getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_1 : (!getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_2 : (getBuilder.isAscending() && !getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_4));
        Message message = this.createMessage(remotePeer, command, type);
        if (getBuilder.isSign()) {
            message.setPublicKeyAndSign(getBuilder.keyPair());
        }
        if (getBuilder.to() != null && getBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(getBuilder.from());
            keys.add(getBuilder.to());
            message.setInteger(getBuilder.returnNr());
            message.setKeyCollection(new KeyCollection(keys));
        } else if (getBuilder.keys() == null) {
            if (getBuilder.getLocationKey() == null || getBuilder.getDomainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.setKey(getBuilder.getLocationKey());
            message.setKey(getBuilder.getDomainKey());
            if (getBuilder.contentKeys() != null) {
                message.setKeyCollection(new KeyCollection(getBuilder.getLocationKey(), getBuilder.getDomainKey(), getBuilder.getVersionKey(), getBuilder.contentKeys()));
            } else {
                message.setInteger(getBuilder.returnNr());
                if (getBuilder.getKeyBloomFilter() != null || getBuilder.getContentBloomFilter() != null) {
                    if (getBuilder.getKeyBloomFilter() != null) {
                        message.setBloomFilter(getBuilder.getKeyBloomFilter());
                    }
                    if (getBuilder.getContentBloomFilter() != null) {
                        message.setBloomFilter(getBuilder.getContentBloomFilter());
                    }
                }
            }
        } else {
            message.setKeyCollection(new KeyCollection(getBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), getBuilder);
        if (!getBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse get(PeerAddress remotePeer, GetBuilder getBuilder, ChannelCreator channelCreator) {
        Message.Type type = getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_1 : (!getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_2 : (getBuilder.isAscending() && !getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_4));
        Message message = this.createMessage(remotePeer, RPC.Commands.GET.getNr(), type);
        if (getBuilder.isSign()) {
            message.setPublicKeyAndSign(getBuilder.keyPair());
        }
        if (getBuilder.to() != null && getBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(getBuilder.from());
            keys.add(getBuilder.to());
            message.setInteger(getBuilder.returnNr());
            message.setKeyCollection(new KeyCollection(keys));
        } else if (getBuilder.keys() == null) {
            if (getBuilder.getLocationKey() == null || getBuilder.getDomainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.setKey(getBuilder.getLocationKey());
            message.setKey(getBuilder.getDomainKey());
            if (getBuilder.contentKeys() != null) {
                message.setKeyCollection(new KeyCollection(getBuilder.getLocationKey(), getBuilder.getDomainKey(), getBuilder.getVersionKey(), getBuilder.contentKeys()));
            } else {
                message.setInteger(getBuilder.returnNr());
                if (getBuilder.getKeyBloomFilter() != null || getBuilder.getContentBloomFilter() != null) {
                    if (getBuilder.getKeyBloomFilter() != null) {
                        message.setBloomFilter(getBuilder.getKeyBloomFilter());
                    }
                    if (getBuilder.getContentBloomFilter() != null) {
                        message.setBloomFilter(getBuilder.getContentBloomFilter());
                    }
                }
            }
        } else {
            message.setKeyCollection(new KeyCollection(getBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), getBuilder);
        if (!getBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse remove(PeerAddress remotePeer, RemoveBuilder removeBuilder, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, RPC.Commands.REMOVE.getNr(), removeBuilder.isReturnResults() ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (removeBuilder.isSign()) {
            message.setPublicKeyAndSign(removeBuilder.keyPair());
        }
        if (removeBuilder.to() != null && removeBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(removeBuilder.from());
            keys.add(removeBuilder.to());
            message.setInteger(0);
            message.setKeyCollection(new KeyCollection(keys));
        } else if (removeBuilder.keys() == null) {
            if (removeBuilder.getLocationKey() == null || removeBuilder.getDomainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.setKey(removeBuilder.getLocationKey());
            message.setKey(removeBuilder.getDomainKey());
            if (removeBuilder.contentKeys() != null) {
                message.setKeyCollection(new KeyCollection(removeBuilder.getLocationKey(), removeBuilder.getDomainKey(), removeBuilder.getVersionKey(), removeBuilder.contentKeys()));
            }
        } else {
            message.setKeyCollection(new KeyCollection(removeBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), removeBuilder);
        if (!removeBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getCommand() != RPC.Commands.ADD.getNr() && message.getCommand() != RPC.Commands.PUT.getNr() && message.getCommand() != RPC.Commands.GET.getNr() && message.getCommand() != RPC.Commands.REMOVE.getNr() && message.getCommand() != RPC.Commands.DIGEST.getNr() && message.getCommand() != RPC.Commands.DIGEST_BLOOMFILTER.getNr() && message.getCommand() != RPC.Commands.DIGEST_META_VALUES.getNr() && message.getCommand() != RPC.Commands.PUT_META.getNr()) {
            throw new IllegalArgumentException("Message content is wrong " + message.getCommand());
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (message.getCommand() == RPC.Commands.ADD.getNr()) {
            this.handleAdd(message, responseMessage, this.isDomainProtected(message));
        } else if (message.getCommand() == RPC.Commands.PUT.getNr()) {
            this.handlePut(message, responseMessage, this.isStoreIfAbsent(message), this.isDomainProtected(message));
        } else if (message.getCommand() == RPC.Commands.GET.getNr()) {
            this.handleGet(message, responseMessage);
        } else if (message.getCommand() == RPC.Commands.DIGEST.getNr() || message.getCommand() == RPC.Commands.DIGEST_BLOOMFILTER.getNr() || message.getCommand() == RPC.Commands.DIGEST_META_VALUES.getNr()) {
            this.handleDigest(message, responseMessage);
        } else if (message.getCommand() == RPC.Commands.REMOVE.getNr()) {
            this.handleRemove(message, responseMessage, message.getType() == Message.Type.REQUEST_2);
        } else if (message.getCommand() == RPC.Commands.PUT_META.getNr()) {
            this.handlePutMeta(message, responseMessage, message.getType() == Message.Type.REQUEST_2);
        } else {
            throw new IllegalArgumentException("Message content is wrong");
        }
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.peerBean().getKeyPair());
        }
        responder.response(responseMessage);
    }

    private boolean isDomainProtected(Message message) {
        boolean protectDomain = message.getPublicKey(0) != null && (message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_4);
        return protectDomain;
    }

    private boolean isStoreIfAbsent(Message message) {
        boolean absent = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return absent;
    }

    private boolean isList(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return partial;
    }

    private boolean isAscending(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_3;
        return partial;
    }

    private boolean isBloomFilterAnd(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2;
        return partial;
    }

    private void handlePutMeta(Message message, Message responseMessage, boolean isDomain) {
        HashMap<Number640, Byte> result;
        int dataSize;
        PublicKey publicKey = message.getPublicKey(0);
        DataMap toStore = message.getDataMap(0);
        if (isDomain) {
            dataSize = 1;
            result = new HashMap<Number640, Byte>(1);
            LOG.debug("received meta request to change domain");
            Number160 locationKey = message.getKey(0);
            Number160 domainKey = message.getKey(1);
            Number640 key = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            PublicKey publicKeyChange = message.getPublicKey(1);
            Enum<?> status = this.peerBean().storage().updateMeta(key.locationAndDomainKey(), publicKey, publicKeyChange);
            result.put(key, (byte)status.ordinal());
        } else {
            dataSize = toStore.size();
            result = new HashMap(dataSize);
            LOG.debug("received meta request to change entry");
            for (Map.Entry<Number640, Data> entry : toStore.dataMap().entrySet()) {
                entry.getValue().setMeta();
                Enum<?> status = this.peerBean().storage().updateMeta(publicKey, entry.getKey(), entry.getValue());
                result.put(entry.getKey(), (byte)status.ordinal());
            }
        }
        responseMessage.setType(result.size() == dataSize ? Message.Type.OK : Message.Type.PARTIALLY_OK);
        responseMessage.setKeyMapByte(new KeyMapByte(result));
    }

    private Message handlePut(Message message, Message responseMessage, boolean putIfAbsent, boolean protectDomain) throws IOException {
        PublicKey publicKey = message.getPublicKey(0);
        DataMap toStore = message.getDataMap(0);
        int dataSize = toStore.size();
        HashMap<Number640, Byte> result = new HashMap<Number640, Byte>(dataSize);
        for (Map.Entry<Number640, Data> entry : toStore.dataMap().entrySet()) {
            Enum<?> putStatus = this.doPut(putIfAbsent, protectDomain, publicKey, entry.getKey(), entry.getValue());
            result.put(entry.getKey(), (byte)putStatus.ordinal());
            if (putStatus != StorageLayer.PutStatus.OK || this.peerBean().replicationStorage() == null) continue;
            this.peerBean().replicationStorage().updateAndNotifyResponsibilities(entry.getKey().getLocationKey());
        }
        responseMessage.setType(result.size() == dataSize ? Message.Type.OK : Message.Type.PARTIALLY_OK);
        responseMessage.setKeyMapByte(new KeyMapByte(result));
        return responseMessage;
    }

    private Message handleAdd(Message message, Message responseMessage, boolean protectDomain) {
        Utils.nullCheck(message.getDataMap(0));
        HashMap<Number640, Byte> result = new HashMap<Number640, Byte>();
        DataMap dataMap = message.getDataMap(0);
        PublicKey publicKey = message.getPublicKey(0);
        boolean list = this.isList(message);
        for (Map.Entry<Number640, Data> entry : dataMap.dataMap().entrySet()) {
            Enum<?> status = StorageRPC.doAdd(protectDomain, entry, publicKey, list, this.peerBean());
            result.put(entry.getKey(), (byte)status.ordinal());
            if (status != StorageLayer.PutStatus.OK || this.peerBean().replicationStorage() == null) continue;
            this.peerBean().replicationStorage().updateAndNotifyResponsibilities(entry.getKey().getLocationKey());
        }
        responseMessage.setKeyMapByte(new KeyMapByte(result));
        return responseMessage;
    }

    private Enum<?> doPut(boolean putIfAbsent, boolean protectDomain, PublicKey publicKey, Number640 key, Data value) {
        LOG.debug("put data with key {} on {} with data {}", new Object[]{key, this.peerBean().serverPeerAddress(), value});
        return this.peerBean().storage().put(key, value, publicKey, putIfAbsent, protectDomain);
    }

    private static Enum<?> doAdd(boolean protectDomain, Map.Entry<Number640, Data> entry, PublicKey publicKey, boolean list, PeerBean peerBean) {
        LOG.debug("add list data with key {} on {}", (Object)entry.getKey(), (Object)peerBean.serverPeerAddress());
        if (list) {
            Enum<?> status;
            Number160 contentKey2 = new Number160(RND);
            Number640 key = new Number640(entry.getKey().getLocationKey(), entry.getKey().getDomainKey(), contentKey2, entry.getKey().getVersionKey());
            while ((status = peerBean.storage().put(key, entry.getValue(), publicKey, true, protectDomain)) == StorageLayer.PutStatus.FAILED_NOT_ABSENT) {
                contentKey2 = new Number160(RND);
            }
            return status;
        }
        return peerBean.storage().put(entry.getKey(), entry.getValue(), publicKey, false, protectDomain);
    }

    private Message handleGet(Message message, Message responseMessage) {
        Number160 locationKey = message.getKey(0);
        LOG.debug("get data with key {} on {}", (Object)locationKey, (Object)this.peerBean().serverPeerAddress());
        Number160 domainKey = message.getKey(1);
        KeyCollection contentKeys = message.getKeyCollection(0);
        SimpleBloomFilter<Number160> contentBloomFilter = message.getBloomFilter(0);
        SimpleBloomFilter<Number160> versionBloomFilter = message.getBloomFilter(1);
        Integer returnNr = message.getInteger(0);
        int limit = returnNr == null ? -1 : returnNr;
        boolean ascending = this.isAscending(message);
        boolean isRange = contentKeys != null && returnNr != null;
        boolean isCollection = contentKeys != null && returnNr == null;
        boolean isBloomFilterAnd = this.isBloomFilterAnd(message);
        Map<Number640, Data> result = this.doGet(locationKey, domainKey, contentKeys, contentBloomFilter, versionBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
        responseMessage.setDataMap(new DataMap(result));
        return responseMessage;
    }

    private Map<Number640, Data> doGet(Number160 locationKey, Number160 domainKey, KeyCollection contentKeys, SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isRange, boolean isCollection, boolean isBloomFilterAnd) {
        Map<Number640, Data> result;
        if (isCollection) {
            result = new HashMap<Number640, Data>();
            for (Number640 key : contentKeys.keys()) {
                Data data = this.peerBean().storage().get(key);
                if (data == null) continue;
                result.put(key, data);
            }
        } else if (isRange) {
            Iterator<Number640> iterator = contentKeys.keys().iterator();
            Number640 min = iterator.next();
            Number640 max = iterator.next();
            result = this.peerBean().storage().get(min, max, limit, ascending);
        } else if (contentBloomFilter != null || versionBloomFilter != null) {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            result = this.peerBean().storage().get(min, max, contentBloomFilter, versionBloomFilter, limit, ascending, isBloomFilterAnd);
        } else {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            result = this.peerBean().storage().get(min, max, limit, ascending);
        }
        return result;
    }

    private Message handleDigest(Message message, Message responseMessage) {
        boolean isReturnMetaValues;
        Number160 locationKey = message.getKey(0);
        LOG.debug("get data with key {} on {}", (Object)locationKey, (Object)this.peerBean().serverPeerAddress());
        Number160 domainKey = message.getKey(1);
        KeyCollection contentKeys = message.getKeyCollection(0);
        SimpleBloomFilter<Number160> contentBloomFilter = message.getBloomFilter(0);
        SimpleBloomFilter<Number160> versionBloomFilter = message.getBloomFilter(1);
        Integer returnNr = message.getInteger(0);
        int limit = returnNr == null ? -1 : returnNr;
        boolean ascending = this.isAscending(message);
        boolean isRange = contentKeys != null && returnNr != null;
        boolean isCollection = contentKeys != null && returnNr == null;
        boolean isBloomFilterAnd = this.isBloomFilterAnd(message);
        boolean isReturnBloomfilter = message.getCommand() == RPC.Commands.DIGEST_BLOOMFILTER.getNr();
        boolean bl = isReturnMetaValues = message.getCommand() == RPC.Commands.DIGEST_META_VALUES.getNr();
        if (isReturnMetaValues) {
            Map<Number640, Data> result = this.doGet(locationKey, domainKey, contentKeys, contentBloomFilter, versionBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
            DataMap dataMap = new DataMap(result, true);
            responseMessage.setDataMap(dataMap);
        } else {
            DigestInfo digestInfo = this.doDigest(locationKey, domainKey, contentKeys, contentBloomFilter, versionBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
            if (isReturnBloomfilter) {
                responseMessage.setBloomFilter(digestInfo.getContentKeyBloomFilter(this.factory));
                responseMessage.setBloomFilter(digestInfo.getVersionKeyBloomFilter(this.factory));
            } else {
                responseMessage.setKeyMap640Keys(new KeyMap640Keys(digestInfo.getDigests()));
            }
        }
        return responseMessage;
    }

    private DigestInfo doDigest(Number160 locationKey, Number160 domainKey, KeyCollection contentKeys, SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isRange, boolean isCollection, boolean isBloomFilterAnd) {
        DigestInfo digestInfo;
        if (isCollection) {
            digestInfo = this.peerBean().storage().digest(contentKeys.keys());
        } else if (isRange) {
            Iterator<Number640> iterator = contentKeys.keys().iterator();
            Number640 min = iterator.next();
            Number640 max = iterator.next();
            digestInfo = this.peerBean().storage().digest(min, max, limit, ascending);
        } else if (contentBloomFilter != null || versionBloomFilter != null) {
            Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
            digestInfo = this.peerBean().storage().digest(locationAndDomainKey, contentBloomFilter, versionBloomFilter, limit, ascending, isBloomFilterAnd);
        } else {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            digestInfo = this.peerBean().storage().digest(min, max, limit, ascending);
        }
        return digestInfo;
    }

    private Message handleRemove(Message message, Message responseMessage, boolean sendBackResults) {
        boolean isCollection;
        Number160 locationKey = message.getKey(0);
        Number160 domainKey = message.getKey(1);
        KeyCollection keys = message.getKeyCollection(0);
        PublicKey publicKey = message.getPublicKey(0);
        Map<Number640, Data> result1 = null;
        Map<Number640, Byte> result2 = null;
        Integer returnNr = message.getInteger(0);
        boolean isRange = keys != null && returnNr != null;
        boolean bl = isCollection = keys != null && returnNr == null;
        if (isCollection) {
            if (sendBackResults) {
                result1 = new HashMap<Number640, Data>(keys.size());
                for (Number640 key : keys.keys()) {
                    Pair<Data, Enum<?>> data = this.peerBean().storage().remove(key, publicKey, sendBackResults);
                    if (data.element0() == null) continue;
                    result1.put(key, data.element0());
                }
            } else {
                result2 = new HashMap<Number640, Byte>(keys.size());
                for (Number640 key : keys.keys()) {
                    Pair<Data, Enum<?>> data = this.peerBean().storage().remove(key, publicKey, sendBackResults);
                    result2.put(key, (byte)data.element1().ordinal());
                }
            }
        } else if (isRange) {
            Iterator<Number640> iterator = keys.keys().iterator();
            Number640 from = iterator.next();
            Number640 to = iterator.next();
            if (sendBackResults) {
                result1 = this.peerBean().storage().removeReturnData(from, to, publicKey);
            } else {
                result2 = this.peerBean().storage().removeReturnStatus(from, to, publicKey);
            }
        } else if (locationKey != null && domainKey != null) {
            Number640 from = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 to = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            if (sendBackResults) {
                result1 = this.peerBean().storage().removeReturnData(from, to, publicKey);
            } else {
                result2 = this.peerBean().storage().removeReturnStatus(from, to, publicKey);
            }
        } else {
            throw new IllegalArgumentException("Either two keys or a key set are necessary");
        }
        if (!sendBackResults) {
            responseMessage.setKeyMapByte(new KeyMapByte(result2));
        } else {
            responseMessage.setDataMap(new DataMap(result1));
        }
        return responseMessage;
    }
}

