/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerExchangeRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PeerExchangeRPC.class);
    public static final int SENT_PEERS_CACHE_SIZE = 1000;

    public PeerExchangeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.PEX.getNr());
    }

    public FutureResponse peerExchange(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, boolean isReplication, ChannelCreator channelCreator, ConnectionConfiguration connectionConfiguration) {
        TrackerData peers;
        Message message = this.createMessage(remotePeer, RPC.Commands.PEX.getNr(), isReplication ? Message.Type.REQUEST_FF_2 : Message.Type.REQUEST_FF_1);
        if (isReplication) {
            peers = this.peerBean().trackerStorage().meshPeers(locationKey, domainKey);
            LOG.debug("we got stored meshPeers size: {}", (Object)peers);
        } else {
            peers = this.peerBean().trackerStorage().activePeers(locationKey, domainKey);
            LOG.debug("we got stored activePeers size: {}", (Object)peers);
        }
        if (peers == null) {
            return new FutureResponse(null).setResponse(null);
        }
        peers = Utils.limit(peers, 35);
        message.setKey(locationKey);
        message.setKey(domainKey);
        if (peers.size() > 0) {
            LOG.debug("sent ({}) to {} / {}", new Object[]{message.getSender().getPeerId(), remotePeer.getPeerId(), peers.size()});
            message.setTrackerData(peers);
            FutureResponse futureResponse = new FutureResponse(message);
            RequestHandler<FutureResponse> requestHandler = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), connectionConfiguration);
            if (!connectionConfiguration.isForceTCP()) {
                return requestHandler.fireAndForgetUDP(channelCreator);
            }
            return requestHandler.sendTCP(channelCreator);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        futureResponse.setResponse();
        return futureResponse;
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getType() != Message.Type.REQUEST_FF_1 && message.getType() != Message.Type.REQUEST_FF_2 || message.getCommand() != RPC.Commands.PEX.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.getKey(0);
        Number160 domainKey = message.getKey(1);
        TrackerData tmp = message.getTrackerData(0);
        if (tmp != null && tmp.size() > 0 && locationKey != null && domainKey != null) {
            PeerAddress referrer = message.getSender();
            for (Map.Entry<PeerAddress, Data> entry : tmp.getPeerAddresses().entrySet()) {
                PeerAddress trackerEntry = entry.getKey();
                this.peerBean().trackerStorage().putReferred(locationKey, domainKey, trackerEntry, referrer, entry.getValue(), message.getType() == Message.Type.REQUEST_FF_1 ? TrackerStorage.ReferrerType.ACTIVE : TrackerStorage.ReferrerType.MESH);
                LOG.debug("Adding {} to the map. I'm {}", (Object)entry.getKey(), (Object)message.getRecipient());
            }
        }
        if (message.isUdp()) {
            responder.responseFireAndForget();
        } else {
            responder.response(this.createResponseMessage(message, Message.Type.OK));
        }
    }
}

