/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerFilter;

public class PeerMapConfiguration {
    private final Number160 self;
    private int bagSizeVerified;
    private int bagSizeOverflow;
    private int offlineTimeout;
    private int shutdownTimeout;
    private int exceptionTimeout;
    private int offlineCount;
    private Collection<PeerFilter> peerFilters = new ArrayList<PeerFilter>(2);
    private Maintenance maintenance;
    private boolean peerVerification;

    public PeerMapConfiguration(Number160 self) {
        this.self = self;
        this.bagSizeVerified = 10;
        this.bagSizeOverflow = 10;
        this.offlineTimeout = 60;
        this.shutdownTimeout = 20;
        this.exceptionTimeout = 120;
        this.offlineCount = 3;
        this.maintenance = new DefaultMaintenance(4, new int[]{2, 4, 8, 16, 32, 64});
        this.peerVerification = true;
    }

    public Number160 self() {
        return this.self;
    }

    public int bagSizeVerified() {
        return this.bagSizeVerified;
    }

    public PeerMapConfiguration bagSizeVerified(int bagSizeVerified) {
        this.bagSizeVerified = bagSizeVerified;
        return this;
    }

    public int bagSizeOverflow() {
        return this.bagSizeOverflow;
    }

    public PeerMapConfiguration bagSizeOverflow(int bagSizeOverflow) {
        this.bagSizeOverflow = bagSizeOverflow;
        return this;
    }

    public int offlineTimeout() {
        return this.offlineTimeout;
    }

    public PeerMapConfiguration offlineTimeout(int offlineTimeout) {
        this.offlineTimeout = offlineTimeout;
        return this;
    }

    public int offlineCount() {
        return this.offlineCount;
    }

    public PeerMapConfiguration offlineCount(int offlineCount) {
        this.offlineCount = offlineCount;
        return this;
    }

    public Collection<PeerFilter> peerFilters() {
        return this.peerFilters;
    }

    public PeerMapConfiguration addPeerFilter(PeerFilter peerFilter) {
        this.peerFilters.add(peerFilter);
        return this;
    }

    public Maintenance maintenance() {
        return this.maintenance;
    }

    public PeerMapConfiguration maintenance(Maintenance maintenance) {
        this.maintenance = maintenance;
        return this;
    }

    public int shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public PeerMapConfiguration shutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public int exceptionTimeout() {
        return this.exceptionTimeout;
    }

    public PeerMapConfiguration exceptionTimeout(int exceptionTimeout) {
        this.exceptionTimeout = exceptionTimeout;
        return this;
    }

    public boolean isPeerVerification() {
        return this.peerVerification;
    }

    public PeerMapConfiguration peerNoVerification() {
        this.peerVerification = false;
        return this;
    }

    public PeerMapConfiguration peerVerification(boolean reerVerification) {
        this.peerVerification = reerVerification;
        return this;
    }
}

