/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.tomp2p.peers.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.utils.ConcurrentCacheMap;
import net.tomp2p.utils.Timings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaintenance
implements Maintenance {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMaintenance.class);
    private final int peerUrgency;
    private final int[] intervalSeconds;
    private final List<Map<Number160, PeerStatatistic>> peerMapVerified;
    private final List<Map<Number160, PeerStatatistic>> peerMapNonVerified;
    private final ConcurrentCacheMap<Number160, PeerAddress> offlineMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> shutdownMap;
    private final ConcurrentCacheMap<Number160, PeerAddress> exceptionMap;

    private DefaultMaintenance(List<Map<Number160, PeerStatatistic>> peerMapVerified, List<Map<Number160, PeerStatatistic>> peerMapNonVerified, ConcurrentCacheMap<Number160, PeerAddress> offlineMap, ConcurrentCacheMap<Number160, PeerAddress> shutdownMap, ConcurrentCacheMap<Number160, PeerAddress> exceptionMap, int peerUrgency, int[] intervalSeconds) {
        this.peerMapVerified = peerMapVerified;
        this.peerMapNonVerified = peerMapNonVerified;
        this.offlineMap = offlineMap;
        this.shutdownMap = shutdownMap;
        this.exceptionMap = exceptionMap;
        this.peerUrgency = peerUrgency;
        this.intervalSeconds = intervalSeconds;
    }

    public DefaultMaintenance(int peerUrgency, int[] intervalSeconds) {
        this.peerMapVerified = null;
        this.peerMapNonVerified = null;
        this.offlineMap = null;
        this.shutdownMap = null;
        this.exceptionMap = null;
        this.peerUrgency = peerUrgency;
        this.intervalSeconds = intervalSeconds;
    }

    @Override
    public Maintenance init(List<Map<Number160, PeerStatatistic>> peerMapVerified, List<Map<Number160, PeerStatatistic>> peerMapNonVerified, ConcurrentCacheMap<Number160, PeerAddress> offlineMap, ConcurrentCacheMap<Number160, PeerAddress> shutdownMap, ConcurrentCacheMap<Number160, PeerAddress> exceptionMap) {
        return new DefaultMaintenance(peerMapVerified, peerMapNonVerified, offlineMap, shutdownMap, exceptionMap, this.peerUrgency, this.intervalSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerStatatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        if (this.peerMapVerified == null || this.peerMapNonVerified == null || this.offlineMap == null || this.shutdownMap == null || this.exceptionMap == null) {
            throw new IllegalArgumentException("did not initialize this maintenance class");
        }
        int peersBefore = 0;
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerStatatistic> mapNonVerified;
            PeerStatatistic readyForMaintenance;
            Map<Number160, PeerStatatistic> mapVerified = this.peerMapVerified.get(i);
            boolean urgent = false;
            Map<Number160, PeerStatatistic> map = mapVerified;
            synchronized (map) {
                int size = mapVerified.size();
                urgent = this.isUrgent(i, size, peersBefore += size);
            }
            if (urgent && (readyForMaintenance = this.next(mapNonVerified = this.peerMapNonVerified.get(i))) != null && !notInterestedAddresses.contains(readyForMaintenance.getPeerAddress())) {
                LOG.debug("check peer {} from the non verified map", (Object)readyForMaintenance.getPeerAddress());
                return readyForMaintenance;
            }
            PeerStatatistic readyForMaintenance2 = this.next(mapVerified);
            if (readyForMaintenance2 == null || notInterestedAddresses.contains(readyForMaintenance2.getPeerAddress())) continue;
            return readyForMaintenance2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerStatatistic next(Map<Number160, PeerStatatistic> map) {
        Map<Number160, PeerStatatistic> map2 = map;
        synchronized (map2) {
            for (PeerStatatistic peerStatatistic : map.values()) {
                if (!this.needMaintenance(peerStatatistic)) continue;
                return peerStatatistic;
            }
        }
        return null;
    }

    protected boolean isUrgent(int bagIndex, int bagSize, int peersBefore) {
        return bagSize < this.peerUrgency;
    }

    protected boolean needMaintenance(PeerStatatistic peerStatatistic) {
        int index;
        int onlineSec = peerStatatistic.onlineTime() / 1000;
        if (onlineSec <= 0) {
            index = 0;
        } else {
            index = this.intervalSeconds.length - 1;
            for (int i = 0; i < this.intervalSeconds.length; ++i) {
                if (this.intervalSeconds[i] < onlineSec) continue;
                index = i;
                break;
            }
        }
        int time = this.intervalSeconds[index];
        long lastTimeWhenChecked = Timings.currentTimeMillis() - peerStatatistic.getLastSeenOnline();
        return lastTimeWhenChecked > TimeUnit.SECONDS.toMillis(time);
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }
}

