/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import net.tomp2p.futures.FutureSend;
import net.tomp2p.futures.ProgressListener;
import net.tomp2p.message.Buffer;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SendDirectBuilderI;

public class SendBuilder
extends DHTBuilder<SendBuilder>
implements SendDirectBuilderI {
    private static final FutureSend FUTURE_SHUTDOWN = (FutureSend)new FutureSend(null).setFailed("send builder - peer is shutting down");
    private Buffer buffer;
    private Object object;
    private boolean cancelOnFinish = false;
    private boolean streaming = false;
    private ProgressListener progressListener;

    public SendBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    public SendBuilder setBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public SendBuilder setObject(Object object) {
        this.object = object;
        return this;
    }

    public boolean isCancelOnFinish() {
        return this.cancelOnFinish;
    }

    public SendBuilder setCancelOnFinish(boolean cancelOnFinish) {
        this.cancelOnFinish = cancelOnFinish;
        return this;
    }

    public SendBuilder setCancelOnFinish() {
        this.cancelOnFinish = true;
        return this;
    }

    @Override
    public boolean isRaw() {
        return this.object == null;
    }

    public SendBuilder streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    @Override
    public boolean streaming() {
        return this.streaming;
    }

    @Override
    public SendBuilder setStreaming() {
        this.streaming = true;
        return this;
    }

    @Override
    public FutureSend start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("send-builder");
        return this.peer.getDistributedHashMap().direct(this);
    }

    public SendBuilder progressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    @Override
    public ProgressListener progressListener() {
        return this.progressListener;
    }
}

