/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.TrackerConfiguration;
import net.tomp2p.p2p.builder.AddTrackerBuilder;
import net.tomp2p.p2p.builder.GetTrackerBuilder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.TrackerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTracker {
    private static final Logger logger = LoggerFactory.getLogger(DistributedTracker.class);
    private final DistributedRouting routing;
    private final PeerBean peerBean;
    private final TrackerRPC trackerRPC;
    private final PeerExchangeRPC peerExchangeRPC;
    private final Random rnd;
    private final Number160 stableRandom;

    public DistributedTracker(PeerBean peerBean, DistributedRouting routing, TrackerRPC trackerRPC, PeerExchangeRPC peerExchangeRPC) {
        this.routing = routing;
        this.trackerRPC = trackerRPC;
        this.peerExchangeRPC = peerExchangeRPC;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.serverPeerAddress().getPeerId().hashCode());
        this.stableRandom = new Number160(this.rnd);
    }

    public FutureTracker get(final GetTrackerBuilder builder) {
        final FutureTracker futureTracker = new FutureTracker(builder.getEvaluatingScheme(), builder.getKnownPeers());
        builder.getFutureChannelCreator().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    if (builder.isUseSecondaryTrackers()) {
                        TrackerData meshPeers = DistributedTracker.this.peerBean.trackerStorage().meshPeers(builder.getLocationKey(), builder.getDomainKey());
                        TrackerData secondaryPeers = DistributedTracker.this.peerBean.trackerStorage().secondaryPeers(builder.getLocationKey(), builder.getDomainKey());
                        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(PeerMap.createComparator(DistributedTracker.this.stableRandom));
                        for (PeerAddress peerAddress : meshPeers.getPeerAddresses().keySet()) {
                            secondaryQueue.add(peerAddress);
                        }
                        for (PeerAddress peerAddress : secondaryPeers.getPeerAddresses().keySet()) {
                            secondaryQueue.add(peerAddress);
                        }
                        DistributedTracker.this.startLoop(builder, futureTracker, secondaryQueue, futureChannelCreator2.channelCreator());
                    } else {
                        final FutureRouting futureRouting = DistributedTracker.this.createRouting(builder, Message.Type.REQUEST_3, futureChannelCreator2.channelCreator());
                        futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                            @Override
                            public void operationComplete(FutureRouting future) throws Exception {
                                if (futureRouting.isSuccess()) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("found direct hits for tracker get: " + futureRouting.getDirectHits());
                                    }
                                    DistributedTracker.this.startLoop(builder, futureTracker, futureRouting.getDirectHits(), futureChannelCreator2.channelCreator());
                                } else {
                                    futureTracker.setFailed("routing failed");
                                }
                            }
                        });
                    }
                    Utils.addReleaseListener(futureChannelCreator2.channelCreator(), futureTracker);
                } else {
                    futureTracker.setFailed(futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void startLoop(final GetTrackerBuilder builder, FutureTracker futureTracker, NavigableSet<PeerAddress> queueToAsk, final ChannelCreator cc) {
        this.loop(builder.getLocationKey(), builder.getDomainKey(), queueToAsk, builder.getTrackerConfiguration(), futureTracker, true, builder.getKnownPeers(), new Operation(){

            @Override
            public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                if (logger.isDebugEnabled()) {
                    logger.debug("tracker get: " + remotePeer + " location=" + builder.getLocationKey() + " ");
                }
                FutureResponse futureResponse = DistributedTracker.this.trackerRPC.getFromTracker(remotePeer, builder, cc);
                if (logger.isDebugEnabled()) {
                    futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                        @Override
                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                logger.debug("found the following peers: " + future.getResponse().getTrackerData(0));
                            } else {
                                logger.debug("failed to find peers: " + future.getFailedReason());
                            }
                        }
                    });
                }
                return futureResponse;
            }
        });
    }

    public FutureLateJoin<FutureResponse> startPeerExchange(final Number160 locationKey, final Number160 domainKey, FutureChannelCreator futureChannelCreator, final ConnectionConfiguration configuration) {
        TrackerData activePeers = this.peerBean.trackerStorage().activePeers(locationKey, domainKey);
        final TrackerData activePeers2 = Utils.limitRandom(activePeers, 35);
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(activePeers2.size());
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    for (PeerAddress peerAddress : activePeers2.getPeerAddresses().keySet()) {
                        FutureResponse futureResponses = DistributedTracker.this.peerExchangeRPC.peerExchange(peerAddress, locationKey, domainKey, false, future.channelCreator(), configuration);
                        if (futureLateJoin.add(futureResponses)) continue;
                        break;
                    }
                    Utils.addReleaseListener(future.channelCreator(), futureLateJoin);
                } else {
                    futureLateJoin.setFailed(future);
                }
            }
        });
        return futureLateJoin;
    }

    public FutureTracker add(final AddTrackerBuilder builder) {
        final FutureTracker futureTracker = new FutureTracker();
        builder.getFutureChannelCreator().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    final FutureRouting futureRouting = DistributedTracker.this.createRouting(builder, Message.Type.REQUEST_1, futureChannelCreator2.channelCreator());
                    futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                        @Override
                        public void operationComplete(FutureRouting future) throws Exception {
                            if (futureRouting.isSuccess()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("found potential hits for tracker add: " + futureRouting.getPotentialHits());
                                }
                                DistributedTracker.this.loop(builder.getLocationKey(), builder.getDomainKey(), futureRouting.getPotentialHits(), builder.getTrackerConfiguration(), futureTracker, false, builder.getKnownPeers(), new Operation(){

                                    @Override
                                    public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                                        logger.debug("tracker add (me={}): {} location={}", new Object[]{DistributedTracker.this.peerBean.serverPeerAddress(), remotePeer, builder.getLocationKey()});
                                        return DistributedTracker.this.trackerRPC.addToTracker(remotePeer, builder, futureChannelCreator2.channelCreator());
                                    }
                                });
                            } else {
                                futureTracker.setFailed("routing failed");
                            }
                        }
                    });
                    Utils.addReleaseListener(futureChannelCreator2.channelCreator(), futureTracker);
                } else {
                    futureTracker.setFailed(futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void loop(Number160 locationKey, Number160 domainKey, NavigableSet<PeerAddress> queueToAsk, TrackerConfiguration trackerConfiguration, FutureTracker futureTracker, boolean isGet, Set<Number160> knownPeers, Operation operation) {
        FutureResponse[] futureResponses = new FutureResponse[trackerConfiguration.getParallel()];
        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(PeerMap.createComparator(this.stableRandom));
        this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, new HashSet<PeerAddress>(), new HashSet<PeerAddress>(), new HashMap<PeerAddress, TrackerData>(), operation, trackerConfiguration.getParallel(), new AtomicInteger(0), trackerConfiguration.getMaxFailure(), new AtomicInteger(0), trackerConfiguration.getMaxFullTrackers(), new AtomicInteger(0), trackerConfiguration.getAtLeastSucessfulRequestes(), trackerConfiguration.getAtLeastEntriesFromTrackers(), new AtomicInteger(0), trackerConfiguration.getMaxPrimaryTrackers(), new AtomicReferenceArray<FutureResponse>(futureResponses), futureTracker, knownPeers, isGet);
    }

    private void loopRec(final Number160 locationKey, final Number160 domainKey, final NavigableSet<PeerAddress> queueToAsk, final NavigableSet<PeerAddress> secondaryQueue, final Set<PeerAddress> alreadyAsked, final Set<PeerAddress> successAsked, final Map<PeerAddress, TrackerData> peerOnTracker, final Operation operation, final int parallel, final AtomicInteger nrFailures, final int maxFailures, final AtomicInteger trackerFull, final int maxTrackerFull, final AtomicInteger successfulRequests, final int atLeastSuccessfullRequests, final int atLeastEntriesFromTrackers, final AtomicInteger primaryTracker, final int maxPrimaryTracker, final AtomicReferenceArray<FutureResponse> futureResponses, final FutureTracker futureTracker, final Set<Number160> knownPeers, final boolean isGet) {
        final boolean cancelOnFinish = isGet;
        logger.debug("we can ask {} primary, and {} secondary.", (Object)queueToAsk.size(), (Object)secondaryQueue.size());
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses.get(i) == null) {
                boolean primary = true;
                PeerAddress next = null;
                if (primaryTracker.incrementAndGet() <= maxPrimaryTracker) {
                    next = isGet ? Utils.pollRandom(queueToAsk, this.rnd) : queueToAsk.pollFirst();
                }
                if (next == null) {
                    next = isGet ? Utils.pollRandom(secondaryQueue, this.rnd) : secondaryQueue.pollFirst();
                    primary = false;
                }
                if (next == null) continue;
                logger.debug("we are about to ask {}", (Object)next);
                alreadyAsked.add(next);
                ++active;
                futureResponses.set(i, operation.create(next, primary));
                continue;
            }
            if (futureResponses.get(i) == null) continue;
            ++active;
        }
        if (active == 0) {
            logger.debug("we finished1, we asked {}, but we could ask {} more nodes {}", new Object[]{alreadyAsked.size(), queueToAsk.size(), alreadyAsked});
            queueToAsk.addAll(secondaryQueue);
            futureTracker.setTrackers(queueToAsk, successAsked, peerOnTracker);
            if (cancelOnFinish) {
                DistributedTracker.cancel(futureResponses);
            }
            return;
        }
        FutureForkJoin<FutureResponse> fp = new FutureForkJoin<FutureResponse>(1, false, futureResponses);
        fp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean isPartial;
                boolean finished = false;
                FutureResponse futureResponse = future.getLast();
                boolean isFull = futureResponse != null && futureResponse.getResponse() != null && futureResponse.getResponse().getType() == Message.Type.DENIED;
                boolean bl = isPartial = futureResponse != null && futureResponse.getResponse() != null && futureResponse.getResponse().getType() == Message.Type.PARTIALLY_OK;
                if (future.isSuccess() || isFull) {
                    TrackerData newDataMap;
                    if (!isFull) {
                        successAsked.add(futureResponse.getRequest().getRecipient());
                    }
                    if ((newDataMap = futureResponse.getResponse().getTrackerData(0)) != null) {
                        Set<PeerAddress> newPeers = newDataMap.getPeerAddresses().keySet();
                        DistributedTracker.mergeDiff(secondaryQueue, newPeers, alreadyAsked, queueToAsk);
                        DistributedTracker.storeResult(peerOnTracker, newDataMap, futureResponse.getRequest().getRecipient(), knownPeers);
                    }
                    int successRequests = isFull ? successfulRequests.get() : successfulRequests.incrementAndGet();
                    finished = DistributedTracker.this.evaluate(peerOnTracker, successRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, isGet);
                    if (logger.isDebugEnabled()) {
                        logger.debug("evaluation result: finished=" + finished + ", " + peerOnTracker.size() + " / " + atLeastEntriesFromTrackers);
                    }
                    if (!finished && isPartial && TrackerRPC.isPrimary(futureResponse)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("partial1: " + futureResponse.getRequest().getRecipient());
                        }
                        queueToAsk.add(futureResponse.getRequest().getRecipient());
                    }
                    if (!finished && isPartial && TrackerRPC.isSecondary(futureResponse)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("partial2: " + futureResponse.getRequest().getRecipient());
                        }
                        secondaryQueue.add(futureResponse.getRequest().getRecipient());
                    }
                    if (!finished && isFull) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("tracker reported to be full. Check if finished due to full trackers.");
                        }
                        finished = trackerFull.incrementAndGet() >= maxTrackerFull;
                    }
                } else {
                    logger.debug("no success {}", (Object)future.getFailedReason());
                    boolean bl2 = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    HashSet<PeerAddress> potentialTrackers = new HashSet<PeerAddress>(queueToAsk);
                    potentialTrackers.addAll(secondaryQueue);
                    if (logger.isDebugEnabled()) {
                        logger.debug("we finished2, we asked " + alreadyAsked.size() + ", but we could ask " + queueToAsk.size() + " more nodes (" + successfulRequests + "/" + atLeastSuccessfullRequests + ")");
                    }
                    futureTracker.setTrackers(potentialTrackers, successAsked, peerOnTracker);
                    if (cancelOnFinish) {
                        DistributedTracker.cancel(futureResponses);
                    }
                } else {
                    DistributedTracker.this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, alreadyAsked, successAsked, peerOnTracker, operation, parallel, nrFailures, maxFailures, trackerFull, maxTrackerFull, successfulRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, primaryTracker, maxPrimaryTracker, futureResponses, futureTracker, knownPeers, isGet);
                }
            }
        });
    }

    private boolean evaluate(Map<?, ?> peerOnTracker, int successfulRequests, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers, boolean isGet) {
        if (isGet) {
            return successfulRequests >= atLeastSuccessfulRequests || peerOnTracker.size() >= atLeastEntriesFromTrackers;
        }
        return successfulRequests >= atLeastSuccessfulRequests;
    }

    private FutureRouting createRouting(TrackerBuilder<?> builder, Message.Type type, ChannelCreator channelCreator) {
        RoutingBuilder routingBuilder = builder.createBuilder(builder.getRoutingConfiguration());
        routingBuilder.setLocationKey(builder.getLocationKey());
        routingBuilder.setDomainKey(builder.getDomainKey());
        routingBuilder.peerFilters(builder.peerFilters());
        return this.routing.route(routingBuilder, type, channelCreator);
    }

    private static void storeResult(Map<PeerAddress, TrackerData> peerOnTracker, TrackerData newDataMap, PeerAddress newDataProvider, Set<Number160> knownPeers) {
        if (knownPeers != null) {
            knownPeers.add(newDataProvider.getPeerId());
        }
        peerOnTracker.put(newDataProvider, newDataMap);
    }

    private static boolean mergeDiff(Set<PeerAddress> queueToAsk, Collection<PeerAddress> newPeers, Collection<PeerAddress> knownPeers1, Collection<PeerAddress> knownPeers2) {
        Collection<PeerAddress> result = Utils.difference(newPeers, new ArrayList(), knownPeers1, knownPeers2);
        return queueToAsk.addAll(result);
    }

    private static void cancel(AtomicReferenceArray<FutureResponse> futures) {
        int len = futures.length();
        for (int i = 0; i < len; ++i) {
            BaseFuture baseFuture = futures.get(i);
            if (baseFuture == null) continue;
            baseFuture.cancel();
        }
    }

    public static interface Operation {
        public FutureResponse create(PeerAddress var1, boolean var2);
    }
}

