/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.Iterator;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class TrackerData {
    public static final Data EMTPY_DATA = new Data(0, 0);
    private final Map<PeerAddress, Data> peerAddresses;
    private final PeerAddress referrer;
    private final boolean couldProvideMoreData;

    public TrackerData(Map<PeerAddress, Data> peerAddresses, PeerAddress referrer) {
        this(peerAddresses, referrer, false);
    }

    public TrackerData(Map<PeerAddress, Data> peerAddresses, PeerAddress referrer, boolean couldProvideMoreData) {
        this.peerAddresses = peerAddresses;
        this.referrer = referrer;
        this.couldProvideMoreData = couldProvideMoreData;
    }

    public Map<PeerAddress, Data> getPeerAddresses() {
        return this.peerAddresses;
    }

    public PeerAddress getReferrer() {
        return this.referrer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("p:").append(this.peerAddresses).append(",l:");
        return sb.toString();
    }

    public boolean couldProvideMoreData() {
        return this.couldProvideMoreData;
    }

    public int size() {
        return this.peerAddresses.size();
    }

    public Map<PeerAddress, Data> map() {
        return this.peerAddresses;
    }

    public void put(PeerAddress remotePeer, Data attachement) {
        this.peerAddresses.put(remotePeer, attachement == null ? EMTPY_DATA : attachement);
    }

    public Map.Entry<PeerAddress, Data> remove(Number160 remotePeerId) {
        Iterator<Map.Entry<PeerAddress, Data>> iterator = this.peerAddresses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PeerAddress, Data> entry = iterator.next();
            if (!entry.getKey().getPeerId().equals(remotePeerId)) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    public boolean containsKey(Number160 tmpKey) {
        for (Map.Entry<PeerAddress, Data> entry : this.peerAddresses.entrySet()) {
            if (!entry.getKey().getPeerId().equals(tmpKey)) continue;
            return true;
        }
        return false;
    }
}

