/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.Decoder;
import net.tomp2p.message.Message;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2PCumulationTCP
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TomP2PCumulationTCP.class);
    private final Decoder decoder;
    private AlternativeCompositeByteBuf cumulation = null;
    private int lastId = 0;

    public TomP2PCumulationTCP(SignatureFactory signatureFactory) {
        this.decoder = new Decoder(signatureFactory);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf buf = (ByteBuf)msg;
        InetSocketAddress sender = (InetSocketAddress)ctx.channel().remoteAddress();
        try {
            if (this.cumulation == null) {
                this.cumulation = AlternativeCompositeByteBuf.compBuffer(buf);
            } else {
                this.cumulation.addComponent(buf);
            }
            this.decoding(ctx, sender);
        }
        catch (Throwable t) {
            LOG.error("Error in TCP decoding", t);
            throw t;
        }
        finally {
            if (!this.cumulation.isReadable()) {
                this.cumulation.release();
                this.cumulation = null;
            }
        }
    }

    private void decoding(ChannelHandlerContext ctx, InetSocketAddress sender) {
        boolean finished = true;
        boolean moreData = true;
        while (finished && moreData) {
            finished = this.decoder.decode(ctx, this.cumulation, (InetSocketAddress)ctx.channel().localAddress(), sender);
            if (finished) {
                this.lastId = this.decoder.message().getMessageId();
                moreData = this.cumulation.readableBytes() > 0;
                ctx.fireChannelRead((Object)this.decoder.prepareFinish());
                continue;
            }
            if (this.lastId == this.decoder.message().getMessageId()) {
                finished = true;
                moreData = this.cumulation.readableBytes() > 0;
                ctx.fireChannelRead((Object)this.decoder.prepareFinish());
                continue;
            }
            if (!this.decoder.message().isStreaming()) continue;
            ctx.fireChannelRead((Object)this.decoder.message());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress sender = (InetSocketAddress)ctx.channel().remoteAddress();
        try {
            if (this.cumulation != null) {
                this.decoding(ctx, sender);
            }
        }
        catch (Throwable t) {
            LOG.error("Error in TCP (inactive) decoding", t);
            throw t;
        }
        finally {
            if (this.cumulation != null) {
                this.cumulation.release();
                this.cumulation = null;
            }
            ctx.fireChannelInactive();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Message msg = this.decoder.message();
        if (cause.getMessage().equals("Connection reset by peer")) {
            return;
        }
        if (cause.getMessage().equals("An existing connection was forcibly closed by the remote host")) {
            return;
        }
        if (msg == null && this.decoder.lastContent() == null) {
            LOG.error("exception in decoding TCP, not started decoding", cause);
        } else if (msg != null && !msg.isDone()) {
            LOG.error("exception in decoding TCP, decoding started", cause);
        }
    }
}

