/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.message.NumberType;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;

public class Message {
    private static final transient Random RND = new Random();
    public static final int CONTENT_TYPE_LENGTH = 8;
    private int messageId;
    private int version;
    private Type type;
    private byte command;
    private PeerAddress sender;
    private PeerAddress recipient;
    private int options = 0;
    private Content[] contentTypes = new Content[8];
    private final Queue<NumberType> contentRefencencs = new LinkedList<NumberType>();
    private List<NeighborSet> neighborsList = null;
    private List<Number160> keyList = null;
    private List<SimpleBloomFilter<Number160>> bloomFilterList = null;
    private List<DataMap> dataMapList = null;
    private List<Integer> integerList = null;
    private List<Long> longList = null;
    private List<KeyCollection> keyCollectionList = null;
    private List<KeyMap640Keys> keyMap640ListKeys = null;
    private List<KeyMapByte> keyMapByteList = null;
    private List<Buffer> bufferList = null;
    private List<TrackerData> trackerDataList = null;
    private List<PublicKey> publicKeyList = null;
    private List<PeerSocketAddress> peerSocketAddresses = null;
    private SignatureCodec signatureEncode = null;
    private transient boolean presetContentTypes = false;
    private transient PrivateKey privateKey;
    private transient InetSocketAddress senderSocket;
    private transient InetSocketAddress recipientSocket;
    private transient boolean udp = false;
    private transient boolean done = false;
    private transient boolean sign = false;
    private transient boolean content = false;
    private transient boolean verified = false;

    public Message() {
        this.messageId = RND.nextInt();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Message setMessageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public Message setVersion(int version) {
        this.version = version;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Message setType(Type type) {
        this.type = type;
        return this;
    }

    public byte getCommand() {
        return this.command;
    }

    public Message setCommand(byte command) {
        this.command = command;
        return this;
    }

    public PeerAddress getSender() {
        return this.sender;
    }

    public Message setSender(PeerAddress sender) {
        this.sender = sender;
        return this;
    }

    public PeerAddress getRecipient() {
        return this.recipient;
    }

    public Message setRecipient(PeerAddress recipient) {
        this.recipient = recipient;
        return this;
    }

    public Content[] getContentTypes() {
        return this.contentTypes;
    }

    public Message setContentType(Content contentType) {
        int reference = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.contentTypes[i] == null) {
                if (contentType == Content.PUBLIC_KEY_SIGNATURE && i != 0) {
                    throw new IllegalStateException("The public key needs to be the first to be set");
                }
                this.contentTypes[i] = contentType;
                this.contentRefencencs.add(new NumberType(reference, contentType));
                return this;
            }
            if (this.contentTypes[i] == contentType) {
                ++reference;
                continue;
            }
            if (this.contentTypes[i] != Content.PUBLIC_KEY_SIGNATURE && this.contentTypes[i] != Content.PUBLIC_KEY || contentType != Content.PUBLIC_KEY_SIGNATURE && contentType != Content.PUBLIC_KEY) continue;
            ++reference;
        }
        throw new IllegalStateException("Already set 8 content types");
    }

    public void restoreContentReferences() {
        HashMap<Content, Integer> refs = new HashMap<Content, Integer>(this.contentTypes.length * 2);
        for (Content contentType : this.contentTypes) {
            if (contentType == Content.EMPTY) {
                return;
            }
            int index = 0;
            if (contentType == Content.PUBLIC_KEY_SIGNATURE || contentType == Content.PUBLIC_KEY) {
                Integer i1 = (Integer)refs.get((Object)Content.PUBLIC_KEY_SIGNATURE);
                if (i1 != null) {
                    index = i1;
                } else {
                    i1 = (Integer)refs.get((Object)Content.PUBLIC_KEY);
                    if (i1 != null) {
                        index = i1;
                    }
                }
            }
            if (!refs.containsKey((Object)contentType)) {
                refs.put(contentType, index);
            } else {
                index = (Integer)refs.get((Object)contentType);
            }
            this.contentRefencencs.add(new NumberType(index, contentType));
            refs.put(contentType, index + 1);
        }
    }

    public Message setContentType(int index, Content contentType) {
        this.contentTypes[index] = contentType;
        return this;
    }

    public Message setContentTypes(Content[] contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    public Queue<NumberType> contentRefencencs() {
        return this.contentRefencencs;
    }

    public boolean hasContent() {
        return this.contentRefencencs.size() > 0 || this.content;
    }

    public Message hasContent(boolean content) {
        this.content = content;
        return this;
    }

    public boolean isRequest() {
        return this.type == Type.REQUEST_1 || this.type == Type.REQUEST_2 || this.type == Type.REQUEST_3 || this.type == Type.REQUEST_4 || this.type == Type.REQUEST_FF_1 || this.type == Type.REQUEST_FF_2;
    }

    public boolean isFireAndForget() {
        return this.type == Type.REQUEST_FF_1 || this.type == Type.REQUEST_FF_2;
    }

    public boolean isOk() {
        return this.type == Type.OK || this.type == Type.PARTIALLY_OK;
    }

    public boolean isNotOk() {
        return this.type == Type.NOT_FOUND || this.type == Type.DENIED;
    }

    public boolean isError() {
        return Message.isError(this.type);
    }

    public static boolean isError(Type type) {
        return type == Type.UNKNOWN_ID || type == Type.EXCEPTION || type == Type.CANCEL;
    }

    public Message setOptions(int options) {
        this.options = options;
        return this;
    }

    public int getOptions() {
        return this.options;
    }

    public Message setKeepAlive(boolean isKeepAlive) {
        this.options = isKeepAlive ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        return this;
    }

    public boolean isKeepAlive() {
        return (this.options & 1) > 0;
    }

    public Message setStreaming() {
        return this.streaming(true);
    }

    public Message streaming(boolean streaming) {
        this.options = streaming ? (this.options |= 2) : (this.options &= 0xFFFFFFFD);
        return this;
    }

    public boolean isStreaming() {
        return (this.options & 2) > 0;
    }

    public Message setKey(Number160 key) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.KEY);
        }
        if (this.keyList == null) {
            this.keyList = new ArrayList<Number160>(1);
        }
        this.keyList.add(key);
        return this;
    }

    public List<Number160> getKeyList() {
        if (this.keyList == null) {
            return Collections.emptyList();
        }
        return this.keyList;
    }

    public Number160 getKey(int index) {
        if (this.keyList == null || index > this.keyList.size() - 1) {
            return null;
        }
        return this.keyList.get(index);
    }

    public Message setBloomFilter(SimpleBloomFilter<Number160> bloomFilter) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.BLOOM_FILTER);
        }
        if (this.bloomFilterList == null) {
            this.bloomFilterList = new ArrayList<SimpleBloomFilter<Number160>>(1);
        }
        this.bloomFilterList.add(bloomFilter);
        return this;
    }

    public List<SimpleBloomFilter<Number160>> getBloomFilterList() {
        if (this.bloomFilterList == null) {
            return Collections.emptyList();
        }
        return this.bloomFilterList;
    }

    public SimpleBloomFilter<Number160> getBloomFilter(int index) {
        if (this.bloomFilterList == null || index > this.bloomFilterList.size() - 1) {
            return null;
        }
        return this.bloomFilterList.get(index);
    }

    public Message setPublicKeyAndSign(KeyPair keyPair) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.PUBLIC_KEY_SIGNATURE);
        }
        this.setPublicKey0(keyPair.getPublic());
        this.privateKey = keyPair.getPrivate();
        return this;
    }

    public Message setInteger(int integer) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.INTEGER);
        }
        if (this.integerList == null) {
            this.integerList = new ArrayList<Integer>(1);
        }
        this.integerList.add(integer);
        return this;
    }

    public List<Integer> getIntegerList() {
        if (this.integerList == null) {
            return Collections.emptyList();
        }
        return this.integerList;
    }

    public Integer getInteger(int index) {
        if (this.integerList == null || index > this.integerList.size() - 1) {
            return null;
        }
        return this.integerList.get(index);
    }

    public Message setLong(long long0) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.LONG);
        }
        if (this.longList == null) {
            this.longList = new ArrayList<Long>(1);
        }
        this.longList.add(long0);
        return this;
    }

    public List<Long> getLongList() {
        if (this.longList == null) {
            return Collections.emptyList();
        }
        return this.longList;
    }

    public Long getLong(int index) {
        if (this.longList == null || index > this.longList.size() - 1) {
            return null;
        }
        return this.longList.get(index);
    }

    public Message setNeighborsSet(NeighborSet neighborSet) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.SET_NEIGHBORS);
        }
        if (this.neighborsList == null) {
            this.neighborsList = new ArrayList<NeighborSet>(1);
        }
        this.neighborsList.add(neighborSet);
        return this;
    }

    public List<NeighborSet> getNeighborsSetList() {
        if (this.neighborsList == null) {
            return Collections.emptyList();
        }
        return this.neighborsList;
    }

    public NeighborSet getNeighborsSet(int index) {
        if (this.neighborsList == null || index > this.neighborsList.size() - 1) {
            return null;
        }
        return this.neighborsList.get(index);
    }

    public Message setDataMap(DataMap dataMap) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.MAP_KEY640_DATA);
        }
        if (this.dataMapList == null) {
            this.dataMapList = new ArrayList<DataMap>(1);
        }
        this.dataMapList.add(dataMap);
        return this;
    }

    public List<DataMap> getDataMapList() {
        if (this.dataMapList == null) {
            return Collections.emptyList();
        }
        return this.dataMapList;
    }

    public DataMap getDataMap(int index) {
        if (this.dataMapList == null || index > this.dataMapList.size() - 1) {
            return null;
        }
        return this.dataMapList.get(index);
    }

    public Message setKeyCollection(KeyCollection key) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.SET_KEY640);
        }
        if (this.keyCollectionList == null) {
            this.keyCollectionList = new ArrayList<KeyCollection>(1);
        }
        this.keyCollectionList.add(key);
        return this;
    }

    public List<KeyCollection> getKeyCollectionList() {
        if (this.keyCollectionList == null) {
            return Collections.emptyList();
        }
        return this.keyCollectionList;
    }

    public KeyCollection getKeyCollection(int index) {
        if (this.keyCollectionList == null || index > this.keyCollectionList.size() - 1) {
            return null;
        }
        return this.keyCollectionList.get(index);
    }

    public Message setKeyMap640Keys(KeyMap640Keys keyMap) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.MAP_KEY640_KEYS);
        }
        if (this.keyMap640ListKeys == null) {
            this.keyMap640ListKeys = new ArrayList<KeyMap640Keys>(1);
        }
        this.keyMap640ListKeys.add(keyMap);
        return this;
    }

    public List<KeyMap640Keys> getKeyMapKeys640List() {
        if (this.keyMap640ListKeys == null) {
            return Collections.emptyList();
        }
        return this.keyMap640ListKeys;
    }

    public KeyMap640Keys getKeyMap640Keys(int index) {
        if (this.keyMap640ListKeys == null || index > this.keyMap640ListKeys.size() - 1) {
            return null;
        }
        return this.keyMap640ListKeys.get(index);
    }

    public Message setKeyMapByte(KeyMapByte keyMap) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.MAP_KEY640_BYTE);
        }
        if (this.keyMapByteList == null) {
            this.keyMapByteList = new ArrayList<KeyMapByte>(1);
        }
        this.keyMapByteList.add(keyMap);
        return this;
    }

    public List<KeyMapByte> getKeyMapByteList() {
        if (this.keyMapByteList == null) {
            return Collections.emptyList();
        }
        return this.keyMapByteList;
    }

    public KeyMapByte getKeyMapByte(int index) {
        if (this.keyMapByteList == null || index > this.keyMapByteList.size() - 1) {
            return null;
        }
        return this.keyMapByteList.get(index);
    }

    public Message setPublicKey(PublicKey publicKey) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.PUBLIC_KEY);
        }
        if (this.publicKeyList == null) {
            this.publicKeyList = new ArrayList<PublicKey>(1);
        }
        this.publicKeyList.add(publicKey);
        return this;
    }

    private Message setPublicKey0(PublicKey publicKey) {
        if (this.publicKeyList == null) {
            this.publicKeyList = new ArrayList<PublicKey>(1);
        }
        this.publicKeyList.add(publicKey);
        return this;
    }

    public List<PublicKey> getPublicKeyList() {
        if (this.publicKeyList == null) {
            return Collections.emptyList();
        }
        return this.publicKeyList;
    }

    public PublicKey getPublicKey(int index) {
        if (this.publicKeyList == null || index > this.publicKeyList.size() - 1) {
            return null;
        }
        return this.publicKeyList.get(index);
    }

    public Message setPeerSocketAddresses(Collection<PeerSocketAddress> peerSocketAddresses) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.SET_PEER_SOCKET);
        }
        if (this.peerSocketAddresses == null) {
            this.peerSocketAddresses = new ArrayList<PeerSocketAddress>(peerSocketAddresses.size());
        }
        this.peerSocketAddresses.addAll(peerSocketAddresses);
        return this;
    }

    public List<PeerSocketAddress> getPeerSocketAddresses() {
        if (this.peerSocketAddresses == null) {
            return Collections.emptyList();
        }
        return this.peerSocketAddresses;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Message setBuffer(Buffer byteBuf) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.BYTE_BUFFER);
        }
        if (this.bufferList == null) {
            this.bufferList = new ArrayList<Buffer>(1);
        }
        this.bufferList.add(byteBuf);
        return this;
    }

    public List<Buffer> getBufferList() {
        if (this.bufferList == null) {
            return Collections.emptyList();
        }
        return this.bufferList;
    }

    public Buffer getBuffer(int index) {
        if (this.bufferList == null || index > this.bufferList.size() - 1) {
            return null;
        }
        return this.bufferList.get(index);
    }

    public Message setTrackerData(TrackerData trackerData) {
        if (!this.presetContentTypes) {
            this.setContentType(Content.SET_TRACKER_DATA);
        }
        if (this.trackerDataList == null) {
            this.trackerDataList = new ArrayList<TrackerData>(1);
        }
        this.trackerDataList.add(trackerData);
        return this;
    }

    public List<TrackerData> getTrackerDataList() {
        if (this.trackerDataList == null) {
            return Collections.emptyList();
        }
        return this.trackerDataList;
    }

    public TrackerData getTrackerData(int index) {
        if (this.trackerDataList == null || index > this.trackerDataList.size() - 1) {
            return null;
        }
        return this.trackerDataList.get(index);
    }

    public Message receivedSignature(SignatureCodec signatureEncode) {
        this.signatureEncode = signatureEncode;
        return this;
    }

    public SignatureCodec receivedSignature() {
        return this.signatureEncode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("msgid=");
        return sb.append(this.getMessageId()).append(",t=").append(this.type.toString()).append(",c=").append(RPC.Commands.find(this.command).toString()).append(",").append(this.isUdp() ? "udp" : "tcp").append(",s=").append(this.sender).append(",r=").append(this.recipient).toString();
    }

    public Message presetContentTypes(boolean presetContentTypes) {
        this.presetContentTypes = presetContentTypes;
        return this;
    }

    public Message senderSocket(InetSocketAddress senderSocket) {
        this.senderSocket = senderSocket;
        return this;
    }

    public InetSocketAddress senderSocket() {
        return this.senderSocket;
    }

    public Message recipientSocket(InetSocketAddress recipientSocket) {
        this.recipientSocket = recipientSocket;
        return this;
    }

    public InetSocketAddress recipientSocket() {
        return this.recipientSocket;
    }

    public Message setHintSign() {
        this.sign = true;
        return this;
    }

    public boolean isSign() {
        return this.sign || this.privateKey != null;
    }

    public Message udp(boolean udp) {
        this.udp = udp;
        return this;
    }

    public boolean isUdp() {
        return this.udp;
    }

    public Message verified(boolean verified) {
        this.verified = verified;
        return this;
    }

    public boolean verified() {
        return this.verified;
    }

    public Message setVerified() {
        this.verified = true;
        return this;
    }

    public Message done(boolean done) {
        this.done = done;
        return this;
    }

    public Message setDone() {
        this.done = true;
        return this;
    }

    public boolean isDone() {
        return this.done;
    }

    public static enum Type {
        REQUEST_1,
        REQUEST_2,
        REQUEST_3,
        REQUEST_4,
        REQUEST_FF_1,
        REQUEST_FF_2,
        OK,
        PARTIALLY_OK,
        NOT_FOUND,
        DENIED,
        UNKNOWN_ID,
        EXCEPTION,
        CANCEL,
        USER1,
        USER2;

    }

    public static enum Content {
        EMPTY,
        KEY,
        MAP_KEY640_DATA,
        MAP_KEY640_KEYS,
        SET_KEY640,
        SET_NEIGHBORS,
        BYTE_BUFFER,
        LONG,
        INTEGER,
        PUBLIC_KEY_SIGNATURE,
        SET_TRACKER_DATA,
        BLOOM_FILTER,
        MAP_KEY640_BYTE,
        PUBLIC_KEY,
        SET_PEER_SOCKET,
        USER1;

    }
}

