/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageLayer;

public class FutureRemove
extends FutureDHT<FutureRemove> {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, Map<Number640, Byte>> rawKeys640;
    private Map<PeerAddress, Map<Number640, Data>> rawData;
    private boolean minReached;
    private Map<Number640, Integer> result;
    private final int dataSize;

    public FutureRemove(DHTBuilder<?> builder) {
        this(builder, 0, new VotingSchemeDHT(), 1);
    }

    public FutureRemove(DHTBuilder<?> builder, int dataSize) {
        this(builder, 0, new VotingSchemeDHT(), dataSize);
    }

    public FutureRemove(DHTBuilder<?> builder, int min, EvaluatingSchemeDHT evaluationScheme, int dataSize) {
        super(builder);
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.dataSize = dataSize;
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoredKeys(Map<PeerAddress, Map<Number640, Byte>> rawKeys640) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys640 = rawKeys640;
            int size = rawKeys640 == null ? 0 : rawKeys640.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected > 0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvgStoredKeys() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.rawKeys640.size();
            int total = 0;
            for (Map<Number640, Byte> map : this.rawKeys640.values()) {
                if (map == null) continue;
                total += map.size();
            }
            return (double)total / (double)size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedData(Map<PeerAddress, Map<Number640, Data>> rawData) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            int size = rawData.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Byte>> getRawKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawKeys640;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number640> getEvalKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate6(this.rawKeys640);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Data>> getRawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> getDataMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Integer> getResult() {
        Object object = this.lock;
        synchronized (object) {
            if (this.result == null) {
                if (this.rawKeys640 != null) {
                    this.result = this.evaluate0(this.rawKeys640);
                } else if (this.rawData != null) {
                    this.result = this.evaluate1(this.rawData);
                } else {
                    return Collections.emptyMap();
                }
            }
            return this.result;
        }
    }

    private Map<Number640, Integer> evaluate0(Map<PeerAddress, Map<Number640, Byte>> rawResult2) {
        HashMap<Number640, Integer> result = new HashMap<Number640, Integer>();
        for (Map<Number640, Byte> map : rawResult2.values()) {
            for (Map.Entry<Number640, Byte> entry : map.entrySet()) {
                if (entry.getValue().intValue() != StorageLayer.PutStatus.OK.ordinal()) continue;
                Integer integer = (Integer)result.get(entry.getKey());
                if (integer == null) {
                    result.put(entry.getKey(), 1);
                    continue;
                }
                result.put(entry.getKey(), integer + 1);
            }
        }
        return result;
    }

    private Map<Number640, Integer> evaluate1(Map<PeerAddress, Map<Number640, Data>> rawData) {
        HashMap<Number640, Integer> result = new HashMap<Number640, Integer>();
        for (Map<Number640, Data> map : rawData.values()) {
            for (Map.Entry<Number640, Data> entry : map.entrySet()) {
                Integer integer = (Integer)result.get(entry.getKey());
                if (integer == null) {
                    result.put(entry.getKey(), 1);
                    continue;
                }
                result.put(entry.getKey(), integer + 1);
            }
        }
        return result;
    }

    @Override
    public boolean isSuccess() {
        if (!super.isSuccess()) {
            return false;
        }
        if (this.rawKeys640 != null) {
            return this.checkResults(this.getResult(), this.rawKeys640.size(), this.dataSize);
        }
        if (this.rawData != null) {
            return this.checkResults(this.getResult(), this.rawData.size(), this.dataSize);
        }
        return false;
    }

    private boolean checkResults(Map<Number640, Integer> result2, int peerReports, int dataSize) {
        for (Map.Entry<Number640, Integer> entry : result2.entrySet()) {
            if (entry.getValue() == peerReports) continue;
            return false;
        }
        return result2.size() >= dataSize;
    }
}

