/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.DSASignatureCodec;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.p2p.PeerMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSASignatureFactory
implements SignatureFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DSASignatureFactory.class);

    private Signature signatureInstance() {
        try {
            return Signature.getInstance("SHA1withDSA");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("could not find algorithm", (Throwable)e);
            return null;
        }
    }

    @Override
    public PublicKey decodePublicKey(byte[] me) {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(me);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("could not find algorithm", (Throwable)e);
            return null;
        }
        catch (InvalidKeySpecException e) {
            LOG.error("wrong keyspec", (Throwable)e);
            return null;
        }
    }

    @Override
    public PublicKey decodePublicKey(ByteBuf buf) {
        if (buf.readableBytes() < 2) {
            return null;
        }
        int len = buf.getUnsignedShort(buf.readerIndex());
        if (buf.readableBytes() - 2 < len) {
            return null;
        }
        buf.skipBytes(2);
        if (len <= 0) {
            return PeerMaker.EMPTY_PUBLICKEY;
        }
        byte[] me = new byte[len];
        buf.readBytes(me);
        return this.decodePublicKey(me);
    }

    @Override
    public void encodePublicKey(PublicKey publicKey, ByteBuf buf) {
        byte[] data = publicKey.getEncoded();
        buf.writeShort(data.length);
        buf.writeBytes(data);
    }

    @Override
    public SignatureCodec sign(PrivateKey privateKey, ByteBuf buf) throws InvalidKeyException, SignatureException, IOException {
        Signature signature = this.signatureInstance();
        signature.initSign(privateKey);
        for (ByteBuffer buffer : buf.nioBuffers()) {
            signature.update(buffer);
        }
        byte[] signatureData = signature.sign();
        DSASignatureCodec decodedSignature = new DSASignatureCodec();
        decodedSignature.decode(signatureData);
        return decodedSignature;
    }

    @Override
    public boolean verify(PublicKey publicKey, ByteBuf buf, SignatureCodec signatureEncoded) throws SignatureException, InvalidKeyException, IOException {
        Signature signature = this.signatureInstance();
        signature.initVerify(publicKey);
        for (ByteBuffer buffer : buf.nioBuffers()) {
            signature.update(buffer);
        }
        byte[] signatureReceived = signatureEncoded.encode();
        return signature.verify(signatureReceived);
    }

    @Override
    public Signature update(PublicKey receivedPublicKey, ByteBuffer[] byteBuffers) throws InvalidKeyException, SignatureException {
        Signature signature = this.signatureInstance();
        signature.initVerify(receivedPublicKey);
        int arrayLength = byteBuffers.length;
        for (int i = 0; i < arrayLength; ++i) {
            signature.update(byteBuffers[i]);
        }
        return signature;
    }

    @Override
    public SignatureCodec signatureCodec() {
        return new DSASignatureCodec();
    }
}

