/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.Collection;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.BaseRelayServer;
import net.tomp2p.relay.RelayServerConfig;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.AndroidRelayServer;
import net.tomp2p.relay.android.gcm.GCMSenderRPC;
import net.tomp2p.relay.android.gcm.IGCMSender;
import net.tomp2p.relay.android.gcm.RemoteGCMSender;
import net.tomp2p.relay.buffer.MessageBufferConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRelayServerConfig
extends RelayServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidRelayServerConfig.class);
    private final MessageBufferConfiguration bufferConfig;
    private final String gcmAuthenticationKey;
    private final int gcmRetries;
    protected IGCMSender gcmSender;

    public AndroidRelayServerConfig(String gcmAuthenticationKey, int gcmRetries, MessageBufferConfiguration bufferConfig) {
        this.gcmAuthenticationKey = gcmAuthenticationKey;
        this.gcmRetries = gcmRetries;
        this.bufferConfig = bufferConfig;
    }

    public AndroidRelayServerConfig(MessageBufferConfiguration bufferConfig) {
        this(null, 0, bufferConfig);
    }

    public void start(Peer peer) {
        if (this.gcmAuthenticationKey != null) {
            this.gcmSender = new GCMSenderRPC(peer, this.gcmAuthenticationKey, this.gcmRetries);
            LOG.debug("GCM server started on {}", (Object)peer.peerAddress());
        }
    }

    public BaseRelayServer createServer(Message message, PeerConnection peerConnection, Responder responder, Peer peer) {
        if (message.bufferList().size() < 1) {
            LOG.error("Device {} did not send any GCM registration id", (Object)peerConnection.remotePeer());
            responder.response(this.createResponse(message, Message.Type.DENIED, peer.peerBean().serverPeerAddress()));
            return null;
        }
        String registrationId = RelayUtils.decodeString((Buffer)message.buffer(0));
        if (registrationId == null) {
            LOG.error("Cannot decode the registrationID from the message");
            responder.response(this.createResponse(message, Message.Type.DENIED, peer.peerBean().serverPeerAddress()));
            return null;
        }
        Integer mapUpdateInterval = message.intAt(1);
        if (mapUpdateInterval == null) {
            LOG.error("Android device did not send the peer map update interval.");
            responder.response(this.createResponse(message, Message.Type.DENIED, peer.peerBean().serverPeerAddress()));
            return null;
        }
        IGCMSender sender = null;
        if (message.neighborsSetList().isEmpty()) {
            sender = this.gcmSender;
            if (sender == null) {
                LOG.error("This relay is unable to serve unreachable Android devices because no GCM Authentication Key is configured");
                responder.response(this.createResponse(message, Message.Type.DENIED, peer.peerBean().serverPeerAddress()));
                return null;
            }
        } else {
            Collection gcmServers = message.neighborsSet(0).neighbors();
            sender = new RemoteGCMSender(peer, gcmServers);
        }
        LOG.debug("Hello Android device! You'll be relayed over GCM. {}", (Object)message);
        AndroidRelayServer androidServer = new AndroidRelayServer(peer, peerConnection.remotePeer(), this.bufferConfig, registrationId, sender, mapUpdateInterval);
        responder.response(this.createResponse(message, Message.Type.OK, peer.peerBean().serverPeerAddress()));
        return androidServer;
    }
}

