/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayClient;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.AndroidRelayClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRelayClientConfig
extends RelayClientConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidRelayClientConfig.class);
    private final String registrationId;
    private Collection<PeerAddress> gcmServers;
    private final AtomicBoolean gcmServersChanged;

    public AndroidRelayClientConfig(String registrationId) {
        this(registrationId, 60);
    }

    public AndroidRelayClientConfig(String registrationId, int peerMapUpdateIntervalS) {
        super(RelayType.ANDROID, peerMapUpdateIntervalS, 120, 2);
        assert (registrationId != null);
        this.registrationId = registrationId;
        this.gcmServers = Collections.emptySet();
        this.gcmServersChanged = new AtomicBoolean(false);
    }

    public String registrationId() {
        return this.registrationId;
    }

    public Collection<PeerAddress> gcmServers() {
        return this.gcmServers;
    }

    public RelayClientConfig gcmServers(Set<PeerAddress> gcmServers) {
        if (gcmServers == null) {
            this.gcmServers = Collections.emptySet();
        } else {
            this.gcmServers = gcmServers;
            this.gcmServersChanged.set(true);
        }
        return this;
    }

    public void prepareSetupMessage(Message message) {
        message.buffer(RelayUtils.encodeString((String)this.registrationId));
        message.intValue(this.peerMapUpdateInterval());
        if (this.gcmServers != null && !this.gcmServers.isEmpty()) {
            message.neighborsSet(new NeighborSet(-1, this.gcmServers));
        }
    }

    public void prepareMapUpdateMessage(Message message) {
        if (this.gcmServersChanged.get()) {
            LOG.debug("Sending updated GCM server list as well");
            message.neighborsSet(new NeighborSet(-1, this.gcmServers));
            this.gcmServersChanged.set(false);
        }
    }

    public BaseRelayClient createClient(PeerConnection connection, Peer peer) {
        return new AndroidRelayClient(connection.remotePeer(), peer);
    }
}

