/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.buffer.BufferedRelayClient;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRelayClient
extends BufferedRelayClient {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidRelayClient.class);
    private static final int MAX_FAIL_COUNT = 5;
    private int reachRelayFailCounter = 0;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public AndroidRelayClient(PeerAddress relayAddress, Peer peer) {
        super(relayAddress, peer);
    }

    public FutureResponse sendToRelay(Message message) {
        if (this.shutdown.get()) {
            return (FutureResponse)new FutureResponse(message).failed("Relay connection is already shut down");
        }
        return RelayUtils.connectAndSend((Peer)this.peer, (Message)message);
    }

    public FutureDone<Void> sendBufferRequest() {
        if (this.shutdown.get()) {
            return (FutureDone)new FutureDone().failed("Relay connection is already shut down");
        }
        LOG.debug("Sending buffer request to relay {}", (Object)this.relayAddress());
        final FutureDone futureDone = new FutureDone();
        Message message = new Message().recipient(this.relayAddress()).sender(this.peer.peerBean().serverPeerAddress()).command(RPC.Commands.RELAY.getNr()).type(Message.Type.REQUEST_4).version(this.peer.connectionBean().p2pId()).keepAlive(false);
        FutureResponse response = this.sendToRelay(message);
        response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse futureResponse) throws Exception {
                if (futureResponse.isSuccess()) {
                    AndroidRelayClient.this.reachRelayFailCounter = 0;
                    LOG.debug("Successfully got the buffer from relay {}", (Object)AndroidRelayClient.this.relayAddress());
                    AndroidRelayClient.this.onReceiveMessageBuffer(futureResponse.responseMessage(), futureDone);
                } else {
                    LOG.error("Cannot get the buffer from relay {}. Reason: {}", (Object)AndroidRelayClient.this.relayAddress(), (Object)futureResponse.failedReason());
                    futureDone.failed((BaseFuture)futureResponse);
                    AndroidRelayClient.this.failedToContactRelay();
                }
            }
        });
        return futureDone;
    }

    public FutureDone<Void> shutdown() {
        this.shutdown.set(true);
        return new FutureDone().done();
    }

    private void failedToContactRelay() {
        LOG.warn("Failed to contact the relay peer. Increase the counter to detect long-term disconnections");
        ++this.reachRelayFailCounter;
        if (this.reachRelayFailCounter > 5) {
            LOG.error("The relay {} was not reachable for {} send attempts", (Object)this.relayAddress(), (Object)this.reachRelayFailCounter);
            this.notifyCloseListeners();
        }
    }

    public void onMapUpdateFailed() {
        this.failedToContactRelay();
    }

    public void onMapUpdateSuccess() {
        this.reachRelayFailCounter = 0;
    }
}

