/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.android.gcm.FutureGCM;
import net.tomp2p.relay.android.gcm.IGCMSender;
import net.tomp2p.relay.android.gcm.RemoteGCMSender;
import net.tomp2p.relay.buffer.BufferedRelayServer;
import net.tomp2p.relay.buffer.MessageBufferConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRelayServer
extends BufferedRelayServer {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidRelayServer.class);
    private final String registrationId;
    private final IGCMSender sender;
    private final int mapUpdateIntervalMS;
    private final AtomicLong lastUpdate;

    public AndroidRelayServer(Peer peer, PeerAddress unreachablePeer, MessageBufferConfiguration bufferConfig, String registrationId, IGCMSender sender, int mapUpdateIntervalS) {
        super(peer, unreachablePeer, RelayType.ANDROID, bufferConfig);
        this.registrationId = registrationId;
        this.sender = sender;
        this.mapUpdateIntervalMS = (int)((double)(mapUpdateIntervalS * 1000) * 1.5);
        this.lastUpdate = new AtomicLong(System.currentTimeMillis());
    }

    public void onBufferFull() {
        this.sender.send(new FutureGCM(this.registrationId, this.relayPeerId(), this.unreachablePeerAddress()));
    }

    protected void onBufferCollected() {
        this.lastUpdate.set(System.currentTimeMillis());
    }

    protected void peerMapUpdated(Message requestMessage, Message preparedResponse) {
        this.lastUpdate.set(System.currentTimeMillis());
        LOG.trace("Timeout for {} refreshed", (Object)this.registrationId);
        if (requestMessage.neighborsSet(1) != null && this.sender instanceof RemoteGCMSender) {
            RemoteGCMSender remoteGCMSender = (RemoteGCMSender)this.sender;
            remoteGCMSender.gcmServers(requestMessage.neighborsSet(1).neighbors());
            LOG.debug("Received update of the GCM servers");
        }
        super.peerMapUpdated(requestMessage, preparedResponse);
    }

    protected boolean isAlive() {
        if (this.lastUpdate.get() + (long)this.mapUpdateIntervalMS > System.currentTimeMillis()) {
            LOG.trace("Device {} seems to be alive", (Object)this.registrationId);
            return true;
        }
        LOG.warn("Device {} did not send any messages for a long time", (Object)this.registrationId);
        this.notifyOfflineListeners();
        return false;
    }
}

