/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.tomp2p.dht.Storage;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMemory
implements Storage {
    public static final int DEFAULT_STORAGE_CHECK_INTERVAL = 60000;
    public static final int DEFAULT_MAX_VERSIONS = -1;
    private static final Logger LOG = LoggerFactory.getLogger(StorageMemory.class);
    private final NavigableMap<Number640, Data> dataMap = new ConcurrentSkipListMap<Number640, Data>();
    private final Map<Number640, Long> timeoutMap = new ConcurrentHashMap<Number640, Long>();
    private final ConcurrentSkipListMap<Long, Set<Number640>> timeoutMapRev = new ConcurrentSkipListMap();
    private final Map<Number320, PublicKey> protectedMap = new ConcurrentHashMap<Number320, PublicKey>();
    private final Map<Number480, PublicKey> entryMap = new ConcurrentHashMap<Number480, PublicKey>();
    private final Map<Number160, Number160> responsibilityMap = new ConcurrentHashMap<Number160, Number160>();
    private final Map<Number160, Set<Number160>> responsibilityMapRev = new ConcurrentHashMap<Number160, Set<Number160>>();
    final int storageCheckIntervalMillis;
    final int maxVersions;

    public StorageMemory() {
        this(60000, -1);
    }

    public StorageMemory(int storageCheckIntervalMillis) {
        this(storageCheckIntervalMillis, -1);
    }

    public StorageMemory(int storageCheckIntervalMillis, int maxVersions) {
        this.storageCheckIntervalMillis = storageCheckIntervalMillis;
        this.maxVersions = maxVersions;
    }

    @Override
    public Data put(Number640 key, Data value) {
        Data oldData = this.dataMap.put(key, value);
        if (this.maxVersions > 0) {
            NavigableMap<Number640, Data> versions = this.dataMap.subMap(new Number640(key.locationKey(), key.domainKey(), key.contentKey(), Number160.ZERO), true, new Number640(key.locationKey(), key.domainKey(), key.contentKey(), Number160.MAX_VALUE), true);
            while (!versions.isEmpty() && ((Number640)versions.firstKey()).versionKey().timestamp() + (long)this.maxVersions <= ((Number640)versions.lastKey()).versionKey().timestamp()) {
                Map.Entry<Number640, Data> entry = versions.pollFirstEntry();
                Data removed = this.remove(entry.getKey(), false);
                if (removed != null) {
                    removed.release();
                }
                this.removeTimeout(entry.getKey());
            }
        }
        return oldData;
    }

    @Override
    public Data get(Number640 key) {
        return (Data)this.dataMap.get(key);
    }

    @Override
    public boolean contains(Number640 key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public int contains(Number640 fromKey, Number640 toKey) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        return tmp.size();
    }

    @Override
    public Data remove(Number640 key, boolean returnData) {
        return (Data)this.dataMap.remove(key);
    }

    @Override
    public NavigableMap<Number640, Data> remove(Number640 fromKey, Number640 toKey) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(fromKey, true, toKey, true);
        ConcurrentSkipListMap<Number640, Data> retVal = new ConcurrentSkipListMap<Number640, Data>((SortedMap<Number640, Data>)tmp);
        tmp.clear();
        return retVal;
    }

    @Override
    public NavigableMap<Number640, Data> subMap(Number640 fromKey, Number640 toKey, int limit, boolean ascending) {
        Object clone = ((ConcurrentSkipListMap)this.dataMap).clone();
        NavigableMap<Number640, Data> tmp = clone.subMap(fromKey, true, toKey, true);
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        if (limit < 0) {
            return ascending ? tmp : tmp.descendingMap();
        }
        Iterator iterator = ascending ? tmp.entrySet().iterator() : tmp.descendingMap().entrySet().iterator();
        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
            Map.Entry entry = iterator.next();
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    @Override
    public NavigableMap<Number640, Data> map() {
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        for (Map.Entry entry : this.dataMap.entrySet()) {
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    @Override
    public void addTimeout(Number640 key, long expiration) {
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Set<Number640> tmp = this.putIfAbsent2(expiration, Collections.newSetFromMap(new ConcurrentHashMap()));
        tmp.add(key);
        if (oldExpiration == null) {
            return;
        }
        this.removeRevTimeout(key, oldExpiration);
    }

    @Override
    public void removeTimeout(Number640 key) {
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        this.removeRevTimeout(key, expiration);
    }

    private void removeRevTimeout(Number640 key, Long expiration) {
        Set<Number640> tmp = this.timeoutMapRev.get(expiration);
        if (tmp != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    @Override
    public Collection<Number640> subMapTimeout(long to) {
        SortedMap tmp = this.timeoutMapRev.subMap((Object)0L, (Object)to);
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        for (Set set : tmp.values()) {
            toRemove.addAll(set);
        }
        return toRemove;
    }

    @Override
    public boolean protectDomain(Number320 key, PublicKey publicKey) {
        this.protectedMap.put(key, publicKey);
        return true;
    }

    @Override
    public boolean isDomainProtectedByOthers(Number320 key, PublicKey publicKey) {
        PublicKey other = this.protectedMap.get(key);
        if (other == null) {
            LOG.debug("domain {} not protected", (Object)key);
            return false;
        }
        boolean retVal = !other.equals(publicKey);
        LOG.debug("domain {} protected: {}", (Object)key, (Object)retVal);
        return retVal;
    }

    private Set<Number640> putIfAbsent2(long expiration, Set<Number640> hashSet) {
        Set<Number640> timeouts = this.timeoutMapRev.putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    @Override
    public Number160 findPeerIDsForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.responsibilityMapRev.get(peerID);
    }

    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        boolean hasChanged;
        Number160 oldPeerID = this.responsibilityMap.put(locationKey, peerId);
        if (oldPeerID != null) {
            if (oldPeerID.equals((Object)peerId)) {
                hasChanged = false;
            } else {
                this.removeRevResponsibility(oldPeerID, locationKey);
                hasChanged = true;
            }
        } else {
            hasChanged = true;
        }
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs == null) {
            contentIDs = new HashSet<Number160>();
            this.responsibilityMapRev.put(peerId, contentIDs);
        }
        contentIDs.add(locationKey);
        LOG.debug("Update {} is responsible for key {}.", (Object)peerId, (Object)locationKey);
        return hasChanged;
    }

    @Override
    public void removeResponsibility(Number160 locationKey) {
        Number160 peerId = this.responsibilityMap.remove(locationKey);
        if (peerId != null) {
            this.removeRevResponsibility(peerId, locationKey);
            LOG.debug("Remove responsiblity for {}.", (Object)locationKey);
        }
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            }
        }
    }

    @Override
    public void close() {
        this.dataMap.clear();
        this.protectedMap.clear();
        this.timeoutMap.clear();
        this.timeoutMapRev.clear();
    }

    @Override
    public boolean protectEntry(Number480 key, PublicKey publicKey) {
        this.entryMap.put(key, publicKey);
        return true;
    }

    @Override
    public boolean isEntryProtectedByOthers(Number480 key, PublicKey publicKey) {
        PublicKey other = this.entryMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    @Override
    public int storageCheckIntervalMillis() {
        return this.storageCheckIntervalMillis;
    }
}

