/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.tomp2p.storage.AlternativeCompositeByteBuf;

public class DataBuffer {
    private final List<ByteBuf> buffers;

    public DataBuffer() {
        this(1);
    }

    public DataBuffer(int nrArrays) {
        this.buffers = new ArrayList<ByteBuf>(nrArrays);
    }

    public DataBuffer(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public DataBuffer(byte[] buffer, int offset, int length) {
        this.buffers = new ArrayList<ByteBuf>(1);
        if (length > 0) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)length);
            this.buffers.add(buf);
        }
    }

    public DataBuffer(ByteBuf buf) {
        this.buffers = new ArrayList<ByteBuf>(1);
        if (buf.isReadable()) {
            this.buffers.add(buf.slice());
            buf.retain();
        }
    }

    private DataBuffer(List<ByteBuf> buffers) {
        this.buffers = new ArrayList<ByteBuf>(buffers.size());
        for (ByteBuf buf : buffers) {
            if (!buf.isReadable()) continue;
            this.buffers.add(buf.duplicate());
            buf.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer add(DataBuffer dataBuffer) {
        List<ByteBuf> list = dataBuffer.buffers;
        synchronized (list) {
            for (ByteBuf buf : dataBuffer.buffers) {
                if (!buf.isReadable()) continue;
                this.buffers.add(buf.duplicate());
                buf.retain();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer shallowCopy() {
        DataBuffer db;
        List<ByteBuf> list = this.buffers;
        synchronized (list) {
            db = new DataBuffer(this.buffers);
        }
        return db;
    }

    public List<ByteBuffer> bufferList() {
        DataBuffer copy = this.shallowCopy();
        ArrayList<ByteBuffer> nioBuffers = new ArrayList<ByteBuffer>(copy.buffers.size());
        for (ByteBuf buf : copy.buffers) {
            for (ByteBuffer bb : buf.nioBuffers()) {
                nioBuffers.add(bb);
            }
        }
        return nioBuffers;
    }

    public int length() {
        int length = 0;
        DataBuffer copy = this.shallowCopy();
        for (ByteBuf buffer : copy.buffers) {
            length += buffer.writerIndex();
        }
        return length;
    }

    public ByteBuf toByteBuf() {
        DataBuffer copy = this.shallowCopy();
        return Unpooled.wrappedBuffer((ByteBuf[])copy.buffers.toArray(new ByteBuf[0]));
    }

    public ByteBuf[] toByteBufs() {
        DataBuffer copy = this.shallowCopy();
        return copy.buffers.toArray(new ByteBuf[0]);
    }

    public int transferTo(AlternativeCompositeByteBuf buf) {
        DataBuffer copy = this.shallowCopy();
        int transferred = 0;
        for (ByteBuf buffer : copy.buffers) {
            buf.addComponent(buffer);
            transferred += buffer.readableBytes();
        }
        return transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferFrom(ByteBuf buf, int max) {
        int readable = buf.readableBytes();
        int index = buf.readerIndex();
        int length = Math.min(max, readable);
        if (length == 0) {
            return 0;
        }
        int transferred = 0;
        if (buf instanceof AlternativeCompositeByteBuf) {
            List<ByteBuf> decoms = ((AlternativeCompositeByteBuf)buf).decompose(index, length);
            for (ByteBuf decom : decoms) {
                if (!decom.isReadable()) continue;
                List<ByteBuf> list = this.buffers;
                synchronized (list) {
                    this.buffers.add(decom);
                }
                transferred += decom.readableBytes();
                decom.retain();
            }
        } else {
            ByteBuf slice = buf.slice(index, length);
            if (slice.isReadable()) {
                List<ByteBuf> list = this.buffers;
                synchronized (list) {
                    this.buffers.add(slice);
                }
                transferred += slice.readableBytes();
                slice.retain();
            }
        }
        buf.skipBytes(length);
        return transferred;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataBuffer)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DataBuffer m = (DataBuffer)obj;
        return Arrays.equals(m.bytes(), this.bytes());
    }

    protected void finalize() throws Throwable {
        try {
            for (ByteBuf buf : this.buffers) {
                buf.release();
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer release() {
        List<ByteBuf> list = this.buffers;
        synchronized (list) {
            for (ByteBuf buf : this.buffers) {
                buf.release();
            }
            this.buffers.clear();
        }
        return this;
    }

    public byte[] bytes() {
        List<ByteBuffer> bufs = this.bufferList();
        int size = 0;
        for (ByteBuffer buf : bufs) {
            size += buf.remaining();
        }
        byte[] retVal = new byte[size];
        int offset = 0;
        for (ByteBuffer bb : bufs) {
            int length = bb.remaining();
            bb.get(retVal, offset, length);
            offset += length;
        }
        return retVal;
    }

    public Object lockObject() {
        return this.buffers;
    }
}

