/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnounceRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AnnounceRPC.class);

    public AnnounceRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.LOCAL_ANNOUNCE.getNr());
    }

    public FutureResponse broadcast(PeerAddress remotePeer, ConnectionConfiguration configuration, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, RPC.Commands.LOCAL_ANNOUNCE.getNr(), Message.Type.REQUEST_FF_1);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> requestHandler = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
        LOG.debug("send ANNOUNCE BROADCAST message {}", (Object)message);
        return requestHandler.fireAndForgetBroadcastUDP(channelCreator);
    }

    public FutureResponse ping(PeerAddress remotePeer, ConnectionConfiguration configuration, ChannelCreator channelCreator) {
        final Message message = this.createMessage(remotePeer, RPC.Commands.LOCAL_ANNOUNCE.getNr(), Message.Type.REQUEST_1);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> requestHandler = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
        LOG.debug("send ANNOUNCE PING message {}", (Object)message);
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    AnnounceRPC.this.peerBean().localMap().peerFound(message.recipient(), null);
                }
            }
        });
        return requestHandler.sendBroadcastUDP(channelCreator);
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.command() != RPC.Commands.LOCAL_ANNOUNCE.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        LOG.debug("received ANNOUNCE message {}", (Object)message);
        if (message.type() == Message.Type.REQUEST_FF_1) {
            responder.responseFireAndForget();
            this.peerBean().localMap().peerFound(message.sender(), message.sender());
        } else if (message.type() == Message.Type.REQUEST_1) {
            if (message.recipient().peerId().equals(this.peerBean().serverPeerAddress().peerId())) {
                responder.response(this.createResponseMessage(message, Message.Type.OK));
            }
            this.peerBean().localMap().peerFound(message.sender(), message.sender());
        }
    }
}

