/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.RTT;
import net.tomp2p.utils.FIFOCache;

public class PeerStatistic {
    public static final int RTT_CACHE_SIZE = 5;
    private final AtomicLong lastSeenOnline = new AtomicLong(0L);
    private final long created = System.currentTimeMillis();
    private final AtomicInteger successfullyChecked = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private final Number160 peerId;
    private PeerAddress peerAddress;
    private boolean local;
    private FIFOCache<RTT> rttCache = new FIFOCache(5);
    private long numberOfResponses = 0L;

    public PeerStatistic(PeerAddress peerAddress) {
        if (peerAddress == null) {
            throw new IllegalArgumentException("PeerAddress cannot be null.");
        }
        this.peerId = peerAddress.peerId();
        this.peerAddress = peerAddress;
    }

    public int successfullyChecked() {
        this.lastSeenOnline.set(System.currentTimeMillis());
        this.failed.set(0);
        return this.successfullyChecked.incrementAndGet();
    }

    public long lastSeenOnline() {
        return this.lastSeenOnline.get();
    }

    public int successfullyCheckedCounter() {
        return this.successfullyChecked.get();
    }

    public int failed() {
        return this.failed.incrementAndGet();
    }

    public long created() {
        return this.created;
    }

    public int onlineTime() {
        return (int)(this.lastSeenOnline.get() - this.created);
    }

    public long getNumberOfResponses() {
        return this.numberOfResponses;
    }

    public void increaseNumberOfResponses() {
        ++this.numberOfResponses;
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public PeerAddress peerAddress(PeerAddress peerAddress) {
        if (!this.peerId.equals(peerAddress.peerId())) {
            throw new IllegalArgumentException("Can only update PeerAddress with the same peer ID.");
        }
        PeerAddress previousPeerAddress = this.peerAddress;
        this.peerAddress = peerAddress;
        return previousPeerAddress;
    }

    public PeerStatistic local() {
        this.setLocal(true);
        return this;
    }

    public boolean isLocal() {
        return this.local;
    }

    public PeerStatistic setLocal(boolean local) {
        this.local = local;
        return this;
    }

    public PeerStatistic addRTT(RTT rtt) {
        if (rtt != null && rtt.getRtt() > 0L) {
            if (this.containsEstimates()) {
                if (!rtt.isEstimated()) {
                    this.rttCache.clear();
                }
                this.rttCache.add(rtt);
                return this;
            }
            if (!rtt.isEstimated() || this.rttCache.isEmpty()) {
                this.rttCache.add(rtt);
                return this;
            }
        }
        return this;
    }

    public boolean containsEstimates() {
        return !this.rttCache.isEmpty() && ((RTT)this.rttCache.peek()).isEstimated();
    }

    public RTT getLatestRTT() {
        if (this.rttCache.isEmpty()) {
            return null;
        }
        return this.rttCache.peekTail();
    }

    public long getMeanRTT() {
        if (this.rttCache.isEmpty()) {
            return -1L;
        }
        long sum = 0L;
        for (RTT next : this.rttCache) {
            sum += next.getRtt();
        }
        return sum / (long)this.rttCache.size();
    }

    public int getRTTCount() {
        return this.rttCache.size();
    }

    public int hashCode() {
        return this.peerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PeerStatistic)) {
            return false;
        }
        PeerStatistic p = (PeerStatistic)obj;
        return p.peerId.equals(this.peerId);
    }
}

