/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.futures.FutureSuccessEvaluatorCommunication;
import net.tomp2p.message.Message;
import net.tomp2p.peers.RTT;

public class FutureResponse
extends BaseFutureImpl<FutureResponse> {
    private final Message requestMessage;
    private final FutureSuccessEvaluator futureSuccessEvaluator;
    private Message responseMessage;
    private boolean reponseLater = false;
    private final RTT roundTripTime = new RTT();

    public FutureResponse(Message requestMessage) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication());
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator) {
        this.requestMessage = requestMessage;
        this.futureSuccessEvaluator = futureSuccessEvaluator;
        this.self(this);
    }

    public FutureResponse emptyResponse() {
        return this.response(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse response(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return this;
            }
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.type().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        this.notifyListeners();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean responseLater(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.type().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failedLater(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        cause.printStackTrace(printWriter);
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.reponseLater = true;
            this.reason = stringWriter.toString();
            this.type = BaseFuture.FutureType.FAILED;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse responseNow() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.reponseLater && !this.completed) {
                this.failed("No future set beforehand, probably an early shutdown / timeout, or use setFailedLater() or setResponseLater()");
                return this;
            }
            if (!super.completedAndNotify()) {
                return this;
            }
        }
        this.notifyListeners();
        return this;
    }

    @Override
    protected boolean completedAndNotify() {
        if (this.reponseLater) {
            return false;
        }
        return super.completedAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message responseMessage() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestMessage;
        }
    }

    public boolean startRTTMeasurement(boolean isUDP) {
        return this.getRoundTripTime().beginTimeMeasurement(isUDP);
    }

    public boolean stopRTTMeasurement() {
        return this.getRoundTripTime().stopTimeMeasurement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("future response state:");
        sb.append(",type:").append(this.type.name()).append(",msg:").append(this.requestMessage.command()).append(",reason:").append(this.reason);
        return sb.toString();
    }

    public RTT getRoundTripTime() {
        return this.roundTripTime;
    }
}

