/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.tomp2p.connection.HolePInitiator;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.p2p.MaintenanceTask;
import net.tomp2p.peers.LocalMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.peers.RTT;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.storage.DigestStorage;
import net.tomp2p.storage.DigestTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerBean {
    private static final Logger LOG = LoggerFactory.getLogger(PeerBean.class);
    private KeyPair keyPair;
    private PeerAddress serverPeerAddress;
    private PeerMap peerMap;
    private List<PeerStatusListener> peerStatusListeners = new ArrayList<PeerStatusListener>(1);
    private BloomfilterFactory bloomfilterFactory;
    private MaintenanceTask maintenanceTask;
    private DigestStorage digestStorage;
    private DigestTracker digestTracker;
    private HolePInitiator holePunchInitiator;
    private int holePNumberOfHoles;
    private int holePNumberOfPunches;
    private LocalMap localMap;
    private ConcurrentHashMap<Number160, PeerConnection> openPeerConnections = new ConcurrentHashMap();

    public PeerBean(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public PeerAddress serverPeerAddress() {
        return this.serverPeerAddress;
    }

    public PeerBean serverPeerAddress(PeerAddress serverPeerAddress) {
        this.serverPeerAddress = serverPeerAddress;
        return this;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public PeerBean keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public PeerMap peerMap() {
        return this.peerMap;
    }

    public PeerBean peerMap(PeerMap peerMap) {
        this.peerMap = peerMap;
        return this;
    }

    public List<PeerStatusListener> peerStatusListeners() {
        return this.peerStatusListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerBean notifyPeerFound(PeerAddress sender, PeerAddress reporter, PeerConnection peerConnection, RTT roundTripTime) {
        List<PeerStatusListener> list = this.peerStatusListeners;
        synchronized (list) {
            for (PeerStatusListener peerStatusListener : this.peerStatusListeners) {
                peerStatusListener.peerFound(sender, reporter, peerConnection, roundTripTime);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerBean addPeerStatusListener(PeerStatusListener peerStatusListener) {
        List<PeerStatusListener> list = this.peerStatusListeners;
        synchronized (list) {
            this.peerStatusListeners.add(peerStatusListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerBean removePeerStatusListener(PeerStatusListener peerStatusListener) {
        List<PeerStatusListener> list = this.peerStatusListeners;
        synchronized (list) {
            this.peerStatusListeners.remove(peerStatusListener);
        }
        return this;
    }

    public PeerBean bloomfilterFactory(BloomfilterFactory bloomfilterFactory) {
        this.bloomfilterFactory = bloomfilterFactory;
        return this;
    }

    public BloomfilterFactory bloomfilterFactory() {
        return this.bloomfilterFactory;
    }

    public PeerBean maintenanceTask(MaintenanceTask maintenanceTask) {
        this.maintenanceTask = maintenanceTask;
        return this;
    }

    public MaintenanceTask maintenanceTask() {
        return this.maintenanceTask;
    }

    public PeerBean digestStorage(DigestStorage digestStorage) {
        this.digestStorage = digestStorage;
        return this;
    }

    public DigestStorage digestStorage() {
        return this.digestStorage;
    }

    public PeerBean digestTracker(DigestTracker digestTracker) {
        this.digestTracker = digestTracker;
        return this;
    }

    public DigestTracker digestTracker() {
        return this.digestTracker;
    }

    public PeerBean holePunchInitiator(HolePInitiator holePunchInitiator) {
        this.holePunchInitiator = holePunchInitiator;
        return this;
    }

    public HolePInitiator holePunchInitiator() {
        return this.holePunchInitiator;
    }

    public ConcurrentHashMap<Number160, PeerConnection> openPeerConnections() {
        return this.openPeerConnections;
    }

    public PeerConnection peerConnection(Number160 peerId) {
        PeerConnection peerConnection = this.openPeerConnections.get(peerId);
        if (peerConnection != null) {
            return peerConnection;
        }
        LOG.error("There was no PeerConnection for peerId = " + peerId);
        return null;
    }

    public PeerBean localMap(LocalMap localMap) {
        this.localMap = localMap;
        return this;
    }

    public LocalMap localMap() {
        return this.localMap;
    }

    public PeerBean holePNumberOfHoles(int holePNumberOfHoles) {
        this.holePNumberOfHoles = holePNumberOfHoles;
        return this;
    }

    public int holePNumberOfHoles() {
        return this.holePNumberOfHoles;
    }

    public PeerBean holePNumberOfPunches(int holePNumberOfPunches) {
        this.holePNumberOfPunches = holePNumberOfPunches;
        return this;
    }

    public int holePNumberOfPunches() {
        return this.holePNumberOfPunches;
    }
}

