/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.tcp;

import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.BaseRelayServer;
import net.tomp2p.relay.RelayServerConfig;
import net.tomp2p.relay.tcp.TCPRelayServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPRelayServerConfig
extends RelayServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TCPRelayServerConfig.class);

    @Override
    public void start(Peer peer) {
    }

    @Override
    public BaseRelayServer createServer(Message message, PeerConnection peerConnection, Responder responder, Peer peer) {
        if (peer.peerAddress().isRelayed()) {
            LOG.warn("I cannot be a relay since I'm relayed as well! {}", (Object)message);
            responder.response(this.createResponse(message, Message.Type.DENIED, peer.peerBean().serverPeerAddress()));
            return null;
        }
        LOG.debug("Hello unreachable peer! You'll be relayed over an open TCP connection.");
        TCPRelayServer tcpForwarder = new TCPRelayServer(peerConnection, peer);
        responder.response(this.createResponse(message, Message.Type.OK, peer.peerBean().serverPeerAddress()));
        return tcpForwarder;
    }
}

