/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.HolePInitiator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.HolePInitiatorImpl;
import net.tomp2p.holep.HolePRPC;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayServerConfig;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.tcp.TCPRelayServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerBuilderNAT {
    private static final Logger LOG = LoggerFactory.getLogger(PeerBuilderNAT.class);
    private final Peer peer;
    private boolean manualPorts = false;
    private Map<RelayType, RelayServerConfig> relayServerConfigurations;
    private static final int DEFAULT_NUMBER_OF_HOLEP_HOLES = 3;
    private int holePNumberOfHoles = 3;
    private static final int DEFAULT_NUMBER_OF_HOLE_PUNCHES = 3;
    private int holePNumberOfPunches = 3;

    public PeerBuilderNAT(Peer peer) {
        this.peer = peer;
        this.relayServerConfigurations = new HashMap<RelayType, RelayServerConfig>();
        this.relayServerConfigurations.put(RelayType.OPENTCP, new TCPRelayServerConfig());
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public PeerBuilderNAT manualPorts() {
        return this.manualPorts(true);
    }

    public PeerBuilderNAT manualPorts(boolean manualPorts) {
        this.manualPorts = manualPorts;
        return this;
    }

    public Map<RelayType, RelayServerConfig> relayServerConfigurations() {
        return this.relayServerConfigurations;
    }

    public PeerBuilderNAT relayServerConfigurations(Map<RelayType, RelayServerConfig> relayServerConfigurations) {
        this.relayServerConfigurations = relayServerConfigurations;
        return this;
    }

    public PeerBuilderNAT addRelayServerConfiguration(RelayType relayType, RelayServerConfig configuration) {
        this.relayServerConfigurations.put(relayType, configuration);
        return this;
    }

    public PeerBuilderNAT holePNumberOfHoles(int holePNumberOfHoles) {
        if (holePNumberOfHoles < 1 || holePNumberOfHoles > 100) {
            LOG.error("The specified number of holes is invalid. holePNumberOfHoles must be between 1 and 100. The value is changed back to the default value (which is currently 3)");
            return this;
        }
        this.holePNumberOfHoles = holePNumberOfHoles;
        return this;
    }

    public int holePNumberOfHoles() {
        return this.holePNumberOfHoles;
    }

    public PeerBuilderNAT holePNumberOfHolePunches(int holePNumberOfPunches) {
        this.holePNumberOfPunches = holePNumberOfPunches;
        return this;
    }

    public int holePNumberOfPunches() {
        return this.holePNumberOfPunches;
    }

    public PeerNAT start() {
        final NATUtils natUtils = new NATUtils();
        RconRPC rconRPC = new RconRPC(this.peer);
        HolePRPC holePunchRPC = new HolePRPC(this.peer);
        this.peer.peerBean().holePunchInitiator((HolePInitiator)new HolePInitiatorImpl(this.peer));
        this.peer.peerBean().holePNumberOfHoles(this.holePNumberOfHoles);
        this.peer.peerBean().holePNumberOfPunches(this.holePNumberOfPunches);
        if (this.relayServerConfigurations == null) {
            this.relayServerConfigurations = new HashMap<RelayType, RelayServerConfig>(0);
        } else {
            for (RelayServerConfig config : this.relayServerConfigurations.values()) {
                config.start(this.peer);
            }
        }
        RelayRPC relayRPC = new RelayRPC(this.peer, rconRPC, holePunchRPC, this.relayServerConfigurations);
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                natUtils.shutdown();
                return new FutureDone().done();
            }
        });
        return new PeerNAT(this.peer, natUtils, relayRPC, this.manualPorts);
    }
}

