/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep.strategy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.holep.DuplicatesHandler;
import net.tomp2p.holep.HolePInitiatorImpl;
import net.tomp2p.holep.HolePScheduler;
import net.tomp2p.holep.strategy.HolePStrategy;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHolePStrategy
implements HolePStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHolePStrategy.class);
    private final int numberOfHoles;
    private final int idleUDPSeconds;
    private List<FutureResponse> futureResponses = new ArrayList<FutureResponse>();
    private PeerAddress originalSender;
    protected final Peer peer;
    protected final Message originalMessage;
    protected volatile List<ChannelFuture> channelFutures = new ArrayList<ChannelFuture>();
    protected volatile List<Pair<Integer, Integer>> portMappings = new ArrayList<Pair<Integer, Integer>>();

    protected AbstractHolePStrategy(Peer peer, int numberOfHoles, int idleUDPSeconds, Message originalMessage) {
        this.peer = peer;
        this.numberOfHoles = numberOfHoles;
        this.idleUDPSeconds = idleUDPSeconds;
        this.originalMessage = originalMessage;
        LOG.trace("new HolePuncher created, originalMessage {}", (Object)originalMessage.toString());
    }

    protected abstract void doPortGuessingTargetPeer(Message var1, FutureDone<Message> var2) throws Exception;

    protected abstract void doPortGuessingInitiatingPeer(Message var1, FutureDone<Message> var2, List<ChannelFuture> var3) throws Exception;

    protected List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> prepareHandlers(boolean initiator, FutureDone<Message> futureDone) {
        ArrayList<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> handlerList = new ArrayList<Map<String, Pair<EventExecutorGroup, ChannelHandler>>>(this.numberOfHoles);
        if (initiator) {
            for (int i = 0; i < this.numberOfHoles; ++i) {
                this.futureResponses.add(new FutureResponse(this.originalMessage));
                SimpleChannelInboundHandler<Message> inboundHandler = this.createAfterHolePHandler(futureDone);
                Map handlers = this.peer.connectionBean().sender().configureHandlers(inboundHandler, this.futureResponses.get(i), this.idleUDPSeconds, false);
                handlerList.add(handlers);
            }
        } else {
            DuplicatesHandler inboundHandler = new DuplicatesHandler(this.peer.connectionBean().dispatcher());
            for (int i = 0; i < this.numberOfHoles; ++i) {
                this.futureResponses.add(new FutureResponse(this.originalMessage));
                Map handlers = this.peer.connectionBean().sender().configureHandlers((SimpleChannelInboundHandler)inboundHandler, this.futureResponses.get(i), this.idleUDPSeconds, false);
                handlerList.add(handlers);
            }
        }
        return handlerList;
    }

    protected FutureDone<List<ChannelFuture>> createChannelFutures(List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> handlersList, final FutureDone<Message> mainFutureDone, int numberOfHoles) {
        final FutureDone fDoneChannelFutures = new FutureDone();
        final AtomicInteger countDown = new AtomicInteger(numberOfHoles);
        final ArrayList channelFutures = new ArrayList();
        for (int i = 0; i < numberOfHoles; ++i) {
            final FutureResponse futureResponse = this.futureResponses.get(i);
            final Map<String, Pair<EventExecutorGroup, ChannelHandler>> handlers = handlersList.get(i);
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 0);
            Utils.addReleaseListener((FutureChannelCreator)fcc, (BaseFuture)futureResponse);
            fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        ChannelFuture cF = future.channelCreator().createUDP(false, handlers, futureResponse);
                        cF.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    channelFutures.add(future);
                                } else {
                                    mainFutureDone.failed("Error while creating the ChannelFutures!");
                                }
                                countDown.decrementAndGet();
                                if (countDown.get() == 0) {
                                    fDoneChannelFutures.done((Object)channelFutures);
                                }
                            }
                        });
                    } else {
                        countDown.decrementAndGet();
                        mainFutureDone.failed("Error while creating the ChannelFutures!");
                    }
                }
            });
        }
        return fDoneChannelFutures;
    }

    @Override
    public FutureDone<Message> initiateHolePunch(final FutureDone<Message> mainFutureDone, final FutureResponse originalFutureResponse) {
        if (((HolePInitiatorImpl)this.peer.peerBean().holePunchInitiator()).isTestCase()) {
            mainFutureDone.failed("Gandalf says: You shall not pass!!!");
            return mainFutureDone;
        }
        FutureDone<List<ChannelFuture>> fDoneChannelFutures = this.createChannelFutures(this.prepareHandlers(true, mainFutureDone), mainFutureDone, this.numberOfHoles);
        fDoneChannelFutures.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<List<ChannelFuture>>>(){

            public void operationComplete(FutureDone<List<ChannelFuture>> future) throws Exception {
                if (future.isSuccess()) {
                    final List futures = (List)future.object();
                    FutureDone initMessage = AbstractHolePStrategy.this.createInitMessage(futures);
                    initMessage.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Message>>(){

                        public void operationComplete(FutureDone<Message> future) throws Exception {
                            if (future.isSuccess()) {
                                Message initMessage = (Message)future.object();
                                AbstractHolePStrategy.this.sendHolePInitMessage((FutureDone<Message>)mainFutureDone, originalFutureResponse, futures, initMessage);
                            } else {
                                mainFutureDone.failed("The creation of the initMessage failed!");
                            }
                        }
                    });
                } else {
                    mainFutureDone.failed("No ChannelFuture could be created!");
                }
            }
        });
        return mainFutureDone;
    }

    @Override
    public FutureDone<Message> replyHolePunch() {
        this.originalSender = (PeerAddress)((NeighborSet)this.originalMessage.neighborsSetList().get(0)).neighbors().toArray()[0];
        final FutureDone replyMessageFuture = new FutureDone();
        final AbstractHolePStrategy thisInstance = this;
        FutureDone<List<ChannelFuture>> rmfChannelFutures = this.createChannelFutures(this.prepareHandlers(false, (FutureDone<Message>)replyMessageFuture), (FutureDone<Message>)replyMessageFuture, this.numberOfHoles);
        rmfChannelFutures.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<List<ChannelFuture>>>(){

            public void operationComplete(FutureDone<List<ChannelFuture>> future) throws Exception {
                if (future.isSuccess()) {
                    AbstractHolePStrategy.this.channelFutures = (List)future.object();
                    final FutureDone replyMessageFuture2 = AbstractHolePStrategy.this.createReplyMessage();
                    replyMessageFuture2.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Message>>(){

                        public void operationComplete(FutureDone<Message> future) throws Exception {
                            if (future.isSuccess()) {
                                Message replyMessage = (Message)future.object();
                                Thread holePunchScheduler = new Thread(new HolePScheduler(AbstractHolePStrategy.this.peer.peerBean().holePNumberOfPunches(), thisInstance));
                                holePunchScheduler.start();
                                replyMessageFuture.done((Object)replyMessage);
                            } else {
                                replyMessageFuture2.failed("No ReplyMessage could be created!");
                            }
                        }
                    });
                } else {
                    replyMessageFuture.failed("No ChannelFuture could be created!");
                }
            }
        });
        return replyMessageFuture;
    }

    @Override
    public void tryConnect() throws Exception {
        if (this.channelFutures.size() != this.portMappings.size()) {
            throw new Exception("the number of channels does not match the number of ports!");
        }
        for (int i = 0; i < this.channelFutures.size(); ++i) {
            Message dummyMessage = this.createDummyMessage(i);
            FutureResponse futureResponse = new FutureResponse(dummyMessage);
            LOG.debug("FIRE! remotePort: " + dummyMessage.recipient().udpPort() + ", localPort: " + dummyMessage.sender().udpPort());
            this.peer.connectionBean().sender().afterConnect(futureResponse, dummyMessage, this.channelFutures.get(i), false);
        }
    }

    private void sendHolePInitMessage(final FutureDone<Message> mainFutureDone, final FutureResponse originalFutureResponse, final List<ChannelFuture> futures, final Message initMessage) {
        FutureChannelCreator fChannelCreator = this.peer.connectionBean().reservation().create(1, 0);
        fChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse holePFutureResponse = new FutureResponse(AbstractHolePStrategy.this.originalMessage);
                    holePFutureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (!future.isSuccess()) {
                                mainFutureDone.failed("No port information could be exchanged");
                            }
                        }
                    });
                    Utils.addReleaseListener((FutureChannelCreator)future, (BaseFuture)holePFutureResponse);
                    AbstractHolePStrategy.this.peer.connectionBean().sender().sendUDP(AbstractHolePStrategy.this.createHolePHandler(futures, (FutureDone<Message>)mainFutureDone, originalFutureResponse), holePFutureResponse, initMessage, future.channelCreator(), AbstractHolePStrategy.this.idleUDPSeconds, false);
                    LOG.debug("ChannelFutures successfully created. Initialization of hole punching started.");
                } else {
                    mainFutureDone.failed("The creation of the channelCreator for to send the initMessage failed!");
                }
            }
        });
    }

    private SimpleChannelInboundHandler<Message> createHolePHandler(final List<ChannelFuture> futures, final FutureDone<Message> futureDone, final FutureResponse originalFutureResponse) {
        SimpleChannelInboundHandler<Message> holePunchInboundHandler = new SimpleChannelInboundHandler<Message>(){

            protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                List portList = AbstractHolePStrategy.this.checkReplyValues(msg, (FutureDone<Message>)futureDone);
                if (portList != null) {
                    int numberOfConnectionAttempts = portList.size() / 2;
                    AtomicInteger countDown = new AtomicInteger(numberOfConnectionAttempts);
                    for (int i = 0; i < portList.size(); ++i) {
                        FutureResponse holePFutureResponse = this.handleFutureResponse(originalFutureResponse, portList, i, countDown, numberOfConnectionAttempts);
                        int localport = this.extractLocalPort((FutureDone<Message>)futureDone, portList, i);
                        ChannelFuture channelFuture = AbstractHolePStrategy.this.extractChannelFuture(futures, localport);
                        if (channelFuture == null) {
                            futureDone.failed("Something went wrong with the portmappings!");
                        }
                        Message sendMessage = AbstractHolePStrategy.this.createSendOriginalMessage((Integer)portList.get(++i - 1), (Integer)portList.get(i));
                        AbstractHolePStrategy.this.peer.connectionBean().sender().afterConnect(holePFutureResponse, sendMessage, channelFuture, false);
                        LOG.debug("originalMessage has been sent to the other peer! {}", (Object)sendMessage);
                    }
                }
            }

            private FutureResponse handleFutureResponse(final FutureResponse originalFutureResponse2, List<Integer> portList, int index, final AtomicInteger countDown, final int numberOfConnectionAttempts) {
                int listIndex = index / 2;
                FutureResponse holePFutureResponse = (FutureResponse)AbstractHolePStrategy.this.futureResponses.get(listIndex);
                holePFutureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                    public void operationComplete(FutureResponse future) throws Exception {
                        if (future.isSuccess()) {
                            if (!originalFutureResponse2.isCompleted()) {
                                originalFutureResponse2.response(future.responseMessage());
                            }
                        } else {
                            countDown.decrementAndGet();
                            if (countDown.get() == 0) {
                                originalFutureResponse2.failed("All " + numberOfConnectionAttempts + " connection attempts failed!");
                            }
                        }
                    }
                });
                return holePFutureResponse;
            }

            private int extractLocalPort(FutureDone<Message> futureDone2, List<Integer> portList, int index) {
                int localport = -1;
                if (AbstractHolePStrategy.this.portMappings.isEmpty()) {
                    localport = portList.get(index);
                } else {
                    for (Pair<Integer, Integer> entry : AbstractHolePStrategy.this.portMappings) {
                        if (((Integer)entry.element0()).intValue() != portList.get(index).intValue()) continue;
                        localport = (Integer)entry.element1();
                    }
                }
                if (localport < 1) {
                    futureDone2.failed("No mapping available for port " + portList.get(index) + "!");
                }
                return localport;
            }
        };
        LOG.debug("new HolePunchHandler created, waiting now for answer from rendez-vous peer.");
        return holePunchInboundHandler;
    }

    private SimpleChannelInboundHandler<Message> createAfterHolePHandler(final FutureDone<Message> mainFutureDone) {
        SimpleChannelInboundHandler<Message> inboundHandler = new SimpleChannelInboundHandler<Message>(){

            protected synchronized void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                if (Message.Type.OK == msg.type() && AbstractHolePStrategy.this.originalMessage.command() == msg.command()) {
                    LOG.debug("Successfully transmitted the original message to peer:[" + msg.sender().toString() + "]. Now here's the reply:[" + msg.toString() + "]");
                    mainFutureDone.done((Object)msg);
                    ctx.close();
                } else if (Message.Type.REQUEST_3 == msg.type() && RPC.Commands.HOLEP.getNr() == msg.command()) {
                    LOG.debug("Holes successfully punched with ports = {localPort = " + msg.recipient().udpPort() + " , remotePort = " + msg.sender().udpPort() + "}!");
                } else {
                    LOG.debug("Holes punche not punched with ports = {localPort = " + msg.recipient().udpPort() + " , remotePort = " + msg.sender().udpPort() + "} yet!");
                }
            }
        };
        return inboundHandler;
    }

    private ChannelFuture extractChannelFuture(List<ChannelFuture> futures, int localPort) {
        for (ChannelFuture future : futures) {
            InetSocketAddress inetSocketAddress;
            if (future.channel().localAddress() == null || (inetSocketAddress = (InetSocketAddress)future.channel().localAddress()).getPort() != localPort) continue;
            return future;
        }
        return null;
    }

    private List<Integer> checkReplyValues(Message msg, FutureDone<Message> futureDone) {
        if (msg.command() == RPC.Commands.HOLEP.getNr() && msg.type() == Message.Type.OK) {
            List portList = null;
            try {
                portList = (List)Utils.decodeJavaObject((ByteBuf)msg.buffer(0).buffer());
            }
            catch (Exception e) {
                futureDone.failed("The decoding of the buffer threw an exception!");
                e.printStackTrace();
                return null;
            }
            if (!portList.isEmpty()) {
                int rawNumberOfHoles = portList.size();
                if (rawNumberOfHoles % 2 == 0) {
                    return portList;
                }
                futureDone.failed("The number of ports in the Buffer was odd! This should never happen");
            } else {
                futureDone.failed("IntList in replyMessage was null or Empty! No ports available!!!!");
            }
        } else {
            futureDone.failed("Could not acquire a connection via hole punching, got: " + msg);
        }
        return null;
    }

    protected Buffer encodePortList(List<Integer> portList) throws IOException {
        byte[] bytes = Utils.encodeJavaObject(portList);
        Buffer byteBuf = new Buffer(Unpooled.wrappedBuffer((byte[])bytes));
        return byteBuf;
    }

    private Message createSendOriginalMessage(int localPort, int remotePort) {
        PeerAddress sender = this.originalMessage.sender().changePorts(-1, localPort).changeFirewalledTCP(false).changeFirewalledUDP(false).changeRelayed(false);
        PeerAddress recipient = this.originalMessage.recipient().changePorts(-1, remotePort).changeFirewalledTCP(false).changeFirewalledUDP(false).changeRelayed(false);
        Message sendMessage = this.createHolePMessage(recipient, sender, this.originalMessage.command(), this.originalMessage.type());
        sendMessage.version(this.originalMessage.version());
        sendMessage.intValue(this.originalMessage.messageId());
        sendMessage.udp(true);
        sendMessage.expectDuplicate(true);
        for (Buffer buf : this.originalMessage.bufferList()) {
            sendMessage.buffer(new Buffer(buf.buffer().duplicate()));
        }
        return sendMessage;
    }

    private FutureDone<Message> createInitMessage(List<ChannelFuture> channelFutures) throws Exception {
        FutureDone initMessageFutureDone = new FutureDone();
        PeerSocketAddress socketAddress = Utils.extractRandomRelay((Message)this.originalMessage);
        PeerAddress recipient = this.originalMessage.recipient().changeAddress(socketAddress.inetAddress()).changePorts(socketAddress.tcpPort(), socketAddress.udpPort()).changeRelayed(false);
        Message initMessage = this.createHolePMessage(recipient, this.originalMessage.sender(), RPC.Commands.HOLEP.getNr(), Message.Type.REQUEST_1);
        initMessage.version(this.originalMessage.version());
        initMessage.udp(true);
        this.doPortGuessingInitiatingPeer(initMessage, (FutureDone<Message>)initMessageFutureDone, channelFutures);
        LOG.debug("Hole punch initMessage created {}", (Object)initMessage.toString());
        return initMessageFutureDone;
    }

    private Message createDummyMessage(int index) {
        int remotePort = (Integer)this.portMappings.get(index).element0();
        int localPort = (Integer)this.portMappings.get(index).element1();
        PeerAddress recipient = this.originalSender.changeFirewalledUDP(false).changeRelayed(false).changePorts(-1, remotePort);
        PeerAddress sender = this.peer.peerBean().serverPeerAddress().changePorts(-1, localPort);
        Message dummyMessage = this.createHolePMessage(recipient, sender, RPC.Commands.HOLEP.getNr(), Message.Type.REQUEST_3);
        dummyMessage.udp(true);
        return dummyMessage;
    }

    private FutureDone<Message> createReplyMessage() throws Exception {
        FutureDone replyMessageFuture2 = new FutureDone();
        Message replyMessage = this.createHolePMessage(this.originalMessage.sender(), this.peer.peerBean().serverPeerAddress(), RPC.Commands.HOLEP.getNr(), Message.Type.OK);
        replyMessage.messageId(this.originalMessage.messageId());
        this.doPortGuessingTargetPeer(replyMessage, (FutureDone<Message>)replyMessageFuture2);
        return replyMessageFuture2;
    }

    private Message createHolePMessage(PeerAddress recipient, PeerAddress sender, byte command, Message.Type type) {
        Message message = new Message();
        message.recipient(recipient);
        message.sender(sender);
        message.command(command);
        message.type(type);
        return message;
    }
}

