/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.Futures;
import net.tomp2p.holep.NATType;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATTypeDetection {
    private static final Logger LOG = LoggerFactory.getLogger(NATTypeDetection.class);
    private static final int SEQ_PORT_TOLERANCE = 5;
    private final Peer peer;

    public NATTypeDetection(Peer peer) {
        this.peer = peer;
    }

    public FutureDone<NATType> checkNATType(final PeerAddress relayPeer) {
        final FutureDone futureDone = new FutureDone();
        final FutureChannelCreator fcc1 = this.peer.connectionBean().reservation().create(1, 0);
        fcc1.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse1 = NATTypeDetection.this.peer.pingRPC().pingUDPDiscover(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                    FutureResponse futureResponse2 = NATTypeDetection.this.peer.pingRPC().pingUDPDiscover(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                    FutureDone fdd = Futures.whenAllSuccess((BaseFuture[])new FutureResponse[]{futureResponse1, futureResponse2});
                    Utils.addReleaseListener((FutureChannelCreator)fcc1, (BaseFuture)fdd);
                    fdd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<FutureResponse[]>>(){

                        public void operationComplete(FutureDone<FutureResponse[]> future) throws Exception {
                            if (future.isSuccess()) {
                                if (((FutureResponse[])future.object()).length != 2) {
                                    futureDone.failed("expected exactly two futures");
                                    return;
                                }
                                int port1 = ((FutureResponse[])future.object())[0].responseMessage().intAt(0);
                                int port2 = ((FutureResponse[])future.object())[1].responseMessage().intAt(0);
                                futureDone.failed("not implemented yet");
                            } else {
                                futureDone.failed("expected two successful futures", future);
                            }
                        }
                    });
                } else {
                    futureDone.failed("Could not emit NAT type! Channel creation failed", (BaseFuture)future);
                }
            }
        });
        return futureDone;
    }

    private NATType checkNATType(PeerSocketAddress senderPsa, PeerSocketAddress recipientPsa, PeerSocketAddress senderPsa2, PeerSocketAddress recipientPsa2) {
        if (this.peer.peerAddress().peerSocketAddress().inetAddress().equals(recipientPsa.inetAddress())) {
            LOG.debug("there is no NAT to be traversed!");
            return NATType.NO_NAT;
        }
        if (senderPsa.udpPort() == recipientPsa.udpPort() && senderPsa2.udpPort() == recipientPsa2.udpPort()) {
            LOG.debug("Port preserving NAT detected. UDP hole punching is possible");
            return NATType.PORT_PRESERVING;
        }
        if (Math.abs(recipientPsa2.udpPort() - recipientPsa.udpPort()) < 5) {
            LOG.debug("NAT with sequential port multiplexing detected. UDP hole punching is still possible");
            return NATType.NON_PRESERVING_SEQUENTIAL;
        }
        LOG.debug("Symmetric NAT detected (assumed since all other tests failed)");
        return NATType.NON_PRESERVING_OTHER;
    }
}

