/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BroadcastBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.ConcurrentCacheMap;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredBroadcastHandler
implements BroadcastHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StructuredBroadcastHandler.class);
    private static final int FROM_EACH_BAG = 3;
    private static final AtomicInteger broadcastCounter = new AtomicInteger(0);
    private final ConcurrentCacheMap<Number160, Boolean> cache = new ConcurrentCacheMap();
    private volatile Peer peer;

    @Override
    public StructuredBroadcastHandler init(Peer peer) {
        this.peer = peer;
        return this;
    }

    public int getBroadcastCounter() {
        return broadcastCounter.get();
    }

    @Override
    public StructuredBroadcastHandler receive(Message message) {
        if (this.peer == null) {
            throw new RuntimeException("Init never called. This should be done by the PeerBuilder");
        }
        Number160 messageKey = message.key(0);
        NavigableMap<Number640, Data> dataMap = message.dataMap(0) != null ? message.dataMap(0).dataMap() : null;
        int hopCount = message.intAt(0);
        int bucketNr = message.intAt(1);
        LOG.debug("I {} received a message", (Object)this.peer.peerID());
        if (this.twiceSeen(messageKey)) {
            LOG.debug("already forwarded this message in {}", (Object)this.peer.peerID());
            return this;
        }
        LOG.debug("got broadcast map {} from {}", dataMap, (Object)this.peer.peerID());
        broadcastCounter.incrementAndGet();
        if (hopCount < this.peer.peerBean().peerMap().nrFilledBags()) {
            if (hopCount == 0) {
                LOG.debug("zero hop");
                this.firstPeer(messageKey, dataMap, hopCount, message.isUdp());
            } else {
                LOG.debug("more hop");
                this.otherPeer(message.sender().peerId(), messageKey, dataMap, hopCount, message.isUdp(), bucketNr);
            }
        } else {
            LOG.debug("max hop reached in {}", (Object)this.peer.peerID());
        }
        LOG.debug("done");
        return this;
    }

    private boolean twiceSeen(Number160 messageKey) {
        Boolean isInCache = this.cache.putIfAbsent(messageKey, Boolean.TRUE);
        if (isInCache != null) {
            this.cache.put(messageKey, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private void firstPeer(Number160 messageKey, NavigableMap<Number640, Data> dataMap, int hopCounter, boolean isUDP) {
        List<PeerAddress> list = this.peer.peerBean().peerMap().fromEachBag(3, 160);
        for (PeerAddress peerAddress : list) {
            int bucketNr = PeerMap.classMember(peerAddress.peerId(), this.peer.peerID());
            this.doSend(messageKey, dataMap, hopCounter, isUDP, peerAddress, bucketNr);
        }
    }

    private void otherPeer(Number160 sender, Number160 messageKey, NavigableMap<Number640, Data> dataMap, int hopCounter, boolean isUDP, int bucketNr) {
        List<PeerAddress> list = this.peer.peerBean().peerMap().fromEachBag(3, bucketNr);
        for (PeerAddress peerAddress : list) {
            int bucketNr2 = PeerMap.classMember(peerAddress.peerId(), this.peer.peerID());
            this.doSend(messageKey, dataMap, hopCounter, isUDP, peerAddress, bucketNr2);
        }
    }

    private void doSend(final Number160 messageKey, final NavigableMap<Number640, Data> dataMap, final int hopCounter, final boolean isUDP, final PeerAddress peerAddress, final int bucketNr) {
        FutureChannelCreator frr = this.peer.connectionBean().reservation().create(isUDP ? 1 : 0, isUDP ? 0 : 1);
        frr.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    BroadcastBuilder broadcastBuilder = new BroadcastBuilder(StructuredBroadcastHandler.this.peer, messageKey);
                    broadcastBuilder.dataMap(dataMap);
                    broadcastBuilder.hopCounter(hopCounter + 1);
                    broadcastBuilder.udp(isUDP);
                    FutureResponse futureResponse = StructuredBroadcastHandler.this.peer.broadcastRPC().send(peerAddress, broadcastBuilder, future.channelCreator(), broadcastBuilder, bucketNr);
                    LOG.debug("send to {}", (Object)peerAddress);
                    System.err.println("send to " + peerAddress);
                    Utils.addReleaseListener(future.channelCreator(), futureResponse);
                } else {
                    Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                }
            }
        });
    }
}

