/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;

public class FutureLateJoin<K extends BaseFuture>
extends BaseFutureImpl<FutureLateJoin<K>>
implements BaseFuture {
    private final int nrMaxFutures;
    private final int minSuccess;
    private final List<K> futuresDone;
    private final List<K> futuresSubmitted;
    private K lastSuceessFuture;
    private int successCount = 0;

    public FutureLateJoin(int nrMaxFutures) {
        this(nrMaxFutures, nrMaxFutures);
    }

    public FutureLateJoin(int nrMaxFutures, int minSuccess) {
        this.nrMaxFutures = nrMaxFutures;
        this.minSuccess = minSuccess;
        this.futuresDone = new ArrayList<K>(nrMaxFutures);
        this.futuresSubmitted = new ArrayList<K>(nrMaxFutures);
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(K future) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return false;
            }
            this.futuresSubmitted.add(future);
            future.addListener(new BaseFutureAdapter<K>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(K future) throws Exception {
                    boolean done = false;
                    Object object = FutureLateJoin.this.lock;
                    synchronized (object) {
                        if (!FutureLateJoin.this.completed) {
                            if (future.isSuccess()) {
                                FutureLateJoin.this.successCount++;
                                FutureLateJoin.this.lastSuceessFuture = future;
                            }
                            FutureLateJoin.this.futuresDone.add(future);
                            done = FutureLateJoin.this.checkDone();
                        }
                    }
                    if (done) {
                        FutureLateJoin.this.notifyListeners();
                    }
                }
            });
            return true;
        }
    }

    private boolean checkDone() {
        if (this.futuresDone.size() >= this.nrMaxFutures || this.successCount >= this.minSuccess) {
            if (!this.completedAndNotify()) {
                return false;
            }
            boolean isSuccess = this.successCount >= this.minSuccess;
            this.type = isSuccess ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = isSuccess ? "Minimal number of futures received" : "Minimal number of futures *not* received (" + this.successCount + " of " + this.minSuccess + " reached)";
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> futuresDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.futuresDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K lastSuceessFuture() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastSuceessFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> futuresSubmitted() {
        Object object = this.lock;
        synchronized (object) {
            return this.futuresSubmitted;
        }
    }
}

