/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.peers.PeerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnection {
    private static final Logger LOG = LoggerFactory.getLogger(PeerConnection.class);
    public static final int HEART_BEAT_MILLIS = 2000;
    private final Semaphore oneConnection;
    private final PeerAddress remotePeer;
    private final ChannelCreator cc;
    private final boolean initiator;
    private final Map<FutureChannelCreator, FutureResponse> map;
    private final FutureDone<Void> closeFuture;
    private final int heartBeatMillis;
    private volatile ChannelFuture channelFuture;

    private PeerConnection(Semaphore oneConnection, PeerAddress remotePeer, ChannelCreator cc, boolean initiator, Map<FutureChannelCreator, FutureResponse> map, FutureDone<Void> closeFuture, int heartBeatMillis, ChannelFuture channelFuture) {
        this.oneConnection = oneConnection;
        this.remotePeer = remotePeer;
        this.cc = cc;
        this.initiator = initiator;
        this.map = map;
        this.closeFuture = closeFuture;
        this.heartBeatMillis = heartBeatMillis;
        this.channelFuture = channelFuture;
    }

    public PeerConnection(PeerAddress remotePeer, ChannelCreator cc, int heartBeatMillis) {
        this.remotePeer = remotePeer;
        this.cc = cc;
        this.heartBeatMillis = heartBeatMillis;
        this.initiator = true;
        this.oneConnection = new Semaphore(1);
        this.map = new LinkedHashMap<FutureChannelCreator, FutureResponse>();
        this.closeFuture = new FutureDone();
    }

    public PeerConnection(PeerAddress remotePeer, ChannelFuture channelFuture, int heartBeatMillis) {
        this.remotePeer = remotePeer;
        this.channelFuture = channelFuture;
        this.addCloseListener(channelFuture);
        this.cc = null;
        this.heartBeatMillis = heartBeatMillis;
        this.initiator = false;
        this.oneConnection = new Semaphore(1);
        this.map = new LinkedHashMap<FutureChannelCreator, FutureResponse>();
        this.closeFuture = new FutureDone();
    }

    public PeerConnection channelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
        this.addCloseListener(channelFuture);
        return this;
    }

    public int heartBeatMillis() {
        return this.heartBeatMillis;
    }

    public ChannelFuture channelFuture() {
        return this.channelFuture;
    }

    public FutureDone<Void> closeFuture() {
        return this.closeFuture;
    }

    private void addCloseListener(final ChannelFuture channelFuture) {
        channelFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> arg0) throws Exception {
                LOG.debug("about to close the connection {}, {}", (Object)channelFuture.channel(), (Object)(PeerConnection.this.initiator ? "initiator" : "from-disptacher"));
                PeerConnection.this.closeFuture.done();
            }
        });
    }

    public FutureDone<Void> close() {
        Channel channel;
        Channel channel2 = channel = this.channelFuture != null ? this.channelFuture.channel() : null;
        if (this.cc != null) {
            LOG.debug("close connection, we were the initiator {}", (Object)channel);
            FutureDone<Void> future = this.cc.shutdown();
            future.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                @Override
                public void operationComplete(FutureDone<Void> future) throws Exception {
                    PeerConnection.this.closeFuture.done();
                }
            });
        } else {
            LOG.debug("close connection, not the initiator {}", (Object)channel);
            this.channelFuture.channel().close();
        }
        return this.closeFuture;
    }

    public FutureChannelCreator acquire(FutureResponse futureResponse) {
        FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        return this.acquire(futureChannelCreator, futureResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureChannelCreator acquire(FutureChannelCreator futureChannelCreator, FutureResponse futureResponse) {
        LOG.debug("about to acquire peer connection for {}", (Object)this.remotePeer);
        if (this.oneConnection.tryAcquire()) {
            LOG.debug("acquired peer connection for {}", (Object)this.remotePeer);
            futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(FutureResponse future) throws Exception {
                    PeerConnection.this.oneConnection.release();
                    LOG.debug("released peer connection for {}", (Object)PeerConnection.this.remotePeer);
                    Map map = PeerConnection.this.map;
                    synchronized (map) {
                        Iterator iterator = PeerConnection.this.map.entrySet().iterator();
                        if (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            iterator.remove();
                            PeerConnection.this.acquire((FutureChannelCreator)entry.getKey(), (FutureResponse)entry.getValue());
                        }
                    }
                }
            });
            futureChannelCreator.reserved(this.cc);
            return futureChannelCreator;
        }
        Map<FutureChannelCreator, FutureResponse> map = this.map;
        synchronized (map) {
            this.map.put(futureChannelCreator, futureResponse);
        }
        return futureChannelCreator;
    }

    public ChannelCreator channelCreator() {
        return this.cc;
    }

    public PeerAddress remotePeer() {
        return this.remotePeer;
    }

    public boolean isOpen() {
        if (this.channelFuture != null) {
            return this.channelFuture.channel().isOpen();
        }
        return false;
    }

    public PeerConnection changeRemotePeer(PeerAddress remotePeer) {
        return new PeerConnection(this.oneConnection, remotePeer, this.cc, this.initiator, this.map, this.closeFuture, this.heartBeatMillis, this.channelFuture);
    }

    public int hashCode() {
        if (this.channelFuture != null) {
            return this.channelFuture.hashCode();
        }
        return this.remotePeer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PeerConnection)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PeerConnection p = (PeerConnection)obj;
        if (this.channelFuture != null) {
            return this.channelFuture.channel().equals(p.channelFuture.channel());
        }
        return this.remotePeer.equals(p.remotePeer);
    }
}

