/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelServerConfiguration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.DiscoverNetworkListener;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.DiscoverResults;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.DropConnectionInboundHandler;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.TomP2PCumulationTCP;
import net.tomp2p.message.TomP2POutbound;
import net.tomp2p.message.TomP2PSinglePacketUDP;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelServer
implements DiscoverNetworkListener {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelServer.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final Map<InetAddress, Channel> channelsTCP = Collections.synchronizedMap(new HashMap());
    private final Map<InetAddress, Channel> channelsUDP = Collections.synchronizedMap(new HashMap());
    private final FutureDone<Void> futureServerDone = new FutureDone();
    private final ChannelServerConfiguration channelServerConfiguration;
    private final Dispatcher dispatcher;
    private final List<PeerStatusListener> peerStatusListeners;
    private final DropConnectionInboundHandler tcpDropConnectionInboundHandler;
    private final DropConnectionInboundHandler udpDropConnectionInboundHandler;
    private final ChannelHandler udpDecoderHandler;
    private final DiscoverNetworks discoverNetworks;
    private boolean shutdown = false;
    private boolean broadcastAddressSupported = false;
    private boolean broadcastAddressTried = false;

    public ChannelServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, ChannelServerConfiguration channelServerConfiguration, Dispatcher dispatcher, List<PeerStatusListener> peerStatusListeners, ScheduledExecutorService timer) throws IOException {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.channelServerConfiguration = channelServerConfiguration;
        this.dispatcher = dispatcher;
        this.peerStatusListeners = peerStatusListeners;
        this.discoverNetworks = new DiscoverNetworks(5000, channelServerConfiguration.bindings(), timer);
        this.tcpDropConnectionInboundHandler = new DropConnectionInboundHandler(channelServerConfiguration.maxTCPIncomingConnections());
        this.udpDropConnectionInboundHandler = new DropConnectionInboundHandler(channelServerConfiguration.maxUDPIncomingConnections());
        this.udpDecoderHandler = new TomP2PSinglePacketUDP(channelServerConfiguration.signatureFactory(), channelServerConfiguration.byteBufAllocator());
        this.discoverNetworks.addDiscoverNetworkListener(this);
        if (timer != null) {
            this.discoverNetworks.start().awaitUninterruptibly();
        }
    }

    public DiscoverNetworks discoverNetworks() {
        return this.discoverNetworks;
    }

    public ChannelServerConfiguration channelServerConfiguration() {
        return this.channelServerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discoverNetwork(DiscoverResults discoverResults) {
        if (!this.channelServerConfiguration.isDisableBind()) {
            ChannelServer channelServer = this;
            synchronized (channelServer) {
                if (this.shutdown) {
                    return;
                }
                if (discoverResults.isListenAny()) {
                    this.listenAny();
                } else {
                    this.listenSpecificInetAddresses(discoverResults);
                }
            }
        }
    }

    private void listenAny() {
        InetSocketAddress tcpSocket = new InetSocketAddress(this.channelServerConfiguration.ports().tcpPort());
        boolean tcpStart = this.startupTCP(tcpSocket, this.channelServerConfiguration);
        if (!tcpStart) {
            LOG.warn("cannot bind TCP on socket {}", (Object)tcpSocket);
        } else {
            LOG.info("Listening TCP on socket {}", (Object)tcpSocket);
        }
        InetSocketAddress udpSocket = new InetSocketAddress(this.channelServerConfiguration.ports().udpPort());
        boolean udpStart = this.startupUDP(udpSocket, this.channelServerConfiguration, true);
        if (!udpStart) {
            LOG.warn("cannot bind UDP on socket {}", (Object)udpSocket);
        } else {
            LOG.info("Listening UDP on socket {}", (Object)udpSocket);
        }
    }

    private void listenSpecificInetAddresses(DiscoverResults discoverResults) {
        for (InetAddress inetAddress : discoverResults.newBroadcastAddresses()) {
            InetSocketAddress udpBroadcastSocket = new InetSocketAddress(inetAddress, this.channelServerConfiguration.ports().udpPort());
            this.broadcastAddressTried = true;
            boolean udpStartBroadcast = this.startupUDP(udpBroadcastSocket, this.channelServerConfiguration, false);
            if (udpStartBroadcast) {
                this.broadcastAddressSupported = true;
                LOG.info("Listening on broadcast address: {} on port udp: {}", (Object)udpBroadcastSocket, (Object)this.channelServerConfiguration.ports().udpPort());
                continue;
            }
            LOG.warn("cannot bind broadcast UDP {}", (Object)udpBroadcastSocket);
        }
        for (InetAddress inetAddress : discoverResults.removedFoundBroadcastAddresses()) {
            Channel channelUDP = this.channelsUDP.remove(inetAddress);
            if (channelUDP == null) continue;
            channelUDP.close().awaitUninterruptibly();
        }
        boolean udpStartBroadcast = false;
        if (!this.broadcastAddressSupported && this.broadcastAddressTried) {
            InetSocketAddress udpBroadcastSocket = new InetSocketAddress(this.channelServerConfiguration.ports().udpPort());
            LOG.info("Listening on wildcard broadcast address {}", (Object)udpBroadcastSocket);
            udpStartBroadcast = this.startupUDP(udpBroadcastSocket, this.channelServerConfiguration, true);
            if (!udpStartBroadcast) {
                LOG.warn("cannot bind wildcard broadcast UDP on socket {}", (Object)udpBroadcastSocket);
            }
        }
        for (InetAddress inetAddress : discoverResults.newAddresses()) {
            InetSocketAddress tcpSocket = new InetSocketAddress(inetAddress, this.channelServerConfiguration.ports().tcpPort());
            boolean tcpStart = this.startupTCP(tcpSocket, this.channelServerConfiguration);
            if (!tcpStart) {
                LOG.warn("cannot bind TCP on socket {}", (Object)tcpSocket);
            } else {
                LOG.info("Listening on address: {} on port tcp: {}", (Object)inetAddress, (Object)this.channelServerConfiguration.ports().tcpPort());
            }
            if (udpStartBroadcast) continue;
            InetSocketAddress udpSocket = new InetSocketAddress(inetAddress, this.channelServerConfiguration.ports().udpPort());
            boolean udpStart = this.startupUDP(udpSocket, this.channelServerConfiguration, false);
            if (!udpStart) {
                LOG.warn("cannot bind UDP on socket {}", (Object)udpSocket);
                continue;
            }
            LOG.info("Listening on address: {} on port udp: {}", (Object)inetAddress, (Object)this.channelServerConfiguration.ports().udpPort());
        }
        for (InetAddress inetAddress : discoverResults.removedFoundAddresses()) {
            Channel channelUDP;
            Channel channelTCP = this.channelsTCP.remove(inetAddress);
            if (channelTCP != null) {
                channelTCP.close().awaitUninterruptibly();
            }
            if ((channelUDP = this.channelsUDP.remove(inetAddress)) == null) continue;
            channelUDP.close().awaitUninterruptibly();
        }
    }

    @Override
    public void exception(Throwable throwable) {
        LOG.error("discovery problem", throwable);
    }

    boolean startupUDP(InetSocketAddress listenAddresses, ChannelServerConfiguration config, boolean broadcastFlag) {
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioDatagramChannel.class);
        if (broadcastFlag) {
            b.option(ChannelOption.SO_BROADCAST, (Object)true);
        }
        b.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(ConnectionBean.UDP_LIMIT));
        b.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator(ChannelServer.this.channelServerConfiguration.byteBufAllocator());
                for (Map.Entry entry : ChannelServer.this.handlers(false).entrySet()) {
                    if (!((Pair)entry.getValue()).isEmpty()) {
                        ch.pipeline().addLast((EventExecutorGroup)((Pair)entry.getValue()).element0(), (String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                        continue;
                    }
                    if (((Pair)entry.getValue()).element1() == null) continue;
                    ch.pipeline().addLast((String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                }
            }
        });
        ChannelFuture future = b.bind((SocketAddress)listenAddresses);
        this.channelsUDP.put(listenAddresses.getAddress(), future.channel());
        return this.handleFuture(future);
    }

    boolean startupTCP(InetSocketAddress listenAddresses, ChannelServerConfiguration config) {
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator(ChannelServer.this.channelServerConfiguration.byteBufAllocator());
                ChannelServer.bestEffortOptions(ch, ChannelOption.SO_LINGER, 0);
                ChannelServer.bestEffortOptions(ch, ChannelOption.TCP_NODELAY, true);
                for (Map.Entry entry : ChannelServer.this.handlers(true).entrySet()) {
                    if (!((Pair)entry.getValue()).isEmpty()) {
                        ch.pipeline().addLast((EventExecutorGroup)((Pair)entry.getValue()).element0(), (String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                        continue;
                    }
                    if (((Pair)entry.getValue()).element1() == null) continue;
                    ch.pipeline().addLast((String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                }
            }
        });
        ChannelFuture future = b.bind((SocketAddress)listenAddresses);
        this.channelsTCP.put(listenAddresses.getAddress(), future.channel());
        return this.handleFuture(future);
    }

    private static <T> void bestEffortOptions(Channel ch, ChannelOption<T> option, T value) {
        try {
            ch.config().setOption(option, value);
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    private Map<String, Pair<EventExecutorGroup, ChannelHandler>> handlers(boolean tcp) {
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        TimeoutFactory timeoutFactory = new TimeoutFactory(null, this.channelServerConfiguration.idleTCPSeconds(), this.peerStatusListeners, "Server");
        if (tcp) {
            int nrTCPHandlers = 8;
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>(8);
            handlers.put("dropconnection", new Pair<Object, DropConnectionInboundHandler>(null, this.tcpDropConnectionInboundHandler));
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutFactory.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutFactory.timeHandler()));
            handlers.put("decoder", new Pair<Object, TomP2PCumulationTCP>(null, new TomP2PCumulationTCP(this.channelServerConfiguration.signatureFactory(), this.channelServerConfiguration.byteBufAllocator())));
        } else {
            int nrUDPHandlers = 6;
            handlers = new LinkedHashMap(6);
            handlers.put("dropconnection", new Pair<Object, DropConnectionInboundHandler>(null, this.udpDropConnectionInboundHandler));
            handlers.put("decoder", new Pair<Object, ChannelHandler>(null, this.udpDecoderHandler));
        }
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(this.channelServerConfiguration.signatureFactory(), this.channelServerConfiguration.byteBufAllocator())));
        handlers.put("dispatcher", new Pair<Object, Dispatcher>(null, this.dispatcher));
        return this.channelServerConfiguration.pipelineFilter().filter(handlers, tcp, false);
    }

    private boolean handleFuture(ChannelFuture future) {
        try {
            future.await();
        }
        catch (InterruptedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("could not start UPD server", (Throwable)e);
            }
            return false;
        }
        boolean success = future.isSuccess();
        if (success) {
            return true;
        }
        LOG.debug("binding not successful", future.cause());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> shutdown() {
        ChannelServer channelServer = this;
        synchronized (channelServer) {
            this.shutdown = true;
        }
        this.discoverNetworks.stop();
        final int maxListeners = this.channelsTCP.size() + this.channelsUDP.size();
        if (maxListeners == 0) {
            this.shutdownFuture().done();
        }
        final AtomicInteger listenerCounter = new AtomicInteger(0);
        LOG.debug("shutdown servers");
        Map<InetAddress, Channel> map = this.channelsUDP;
        synchronized (map) {
            for (Channel channelUDP : this.channelsUDP.values()) {
                channelUDP.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        LOG.debug("shutdown TCP server");
                        if (listenerCounter.incrementAndGet() == maxListeners) {
                            ChannelServer.this.futureServerDone.done();
                        }
                    }
                });
            }
        }
        map = this.channelsTCP;
        synchronized (map) {
            for (Channel channelTCP : this.channelsTCP.values()) {
                channelTCP.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        LOG.debug("shutdown TCP channels");
                        if (listenerCounter.incrementAndGet() == maxListeners) {
                            ChannelServer.this.futureServerDone.done();
                        }
                    }
                });
            }
        }
        return this.shutdownFuture();
    }

    public FutureDone<Void> shutdownFuture() {
        return this.futureServerDone;
    }
}

