/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.AddTrackerBuilder;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.GetTrackerBuilder;
import net.tomp2p.tracker.TrackerBuilder;
import net.tomp2p.tracker.TrackerConfiguration;
import net.tomp2p.tracker.TrackerRPC;
import net.tomp2p.tracker.TrackerStorage;
import net.tomp2p.tracker.UtilsTracker;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedTracker.class);
    private static final int MIN_TRACKER_PEERS = 10;
    private final DistributedRouting routing;
    private final PeerBean peerBean;
    private final TrackerRPC trackerRPC;
    private final Random rnd;
    private final Number160 stableRandom;
    private final TrackerStorage trackerStorage;

    public DistributedTracker(PeerBean peerBean, DistributedRouting routing, TrackerRPC trackerRPC, TrackerStorage trackerStorage) {
        this.routing = routing;
        this.trackerRPC = trackerRPC;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.serverPeerAddress().peerId().hashCode());
        this.stableRandom = new Number160(this.rnd);
        this.trackerStorage = trackerStorage;
    }

    public FutureTracker get(final GetTrackerBuilder builder) {
        final FutureTracker futureTracker = new FutureTracker(builder.knownPeers());
        builder.futureChannelCreator().addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    Collection<Pair<PeerStatistic, Data>> value = DistributedTracker.this.trackerStorage.peers(new Number320(builder.locationKey(), builder.domainKey())).values();
                    TrackerData peers = new TrackerData(value);
                    TreeSet queue = new TreeSet(PeerMap.createXORAddressComparator((Number160)DistributedTracker.this.stableRandom));
                    if (peers != null && peers.peerAddresses() != null) {
                        queue.addAll(peers.peerAddresses().keySet());
                    }
                    if (queue.size() > 10) {
                        DistributedTracker.this.startLoop(builder, futureTracker, queue, futureChannelCreator2.channelCreator());
                    } else {
                        final FutureRouting futureRouting = DistributedTracker.this.createRouting(builder, Message.Type.REQUEST_3, futureChannelCreator2.channelCreator());
                        futureRouting.addListener((BaseFutureListener)new BaseFutureAdapter<FutureRouting>(){

                            public void operationComplete(FutureRouting future) throws Exception {
                                if (futureRouting.isSuccess()) {
                                    LOG.debug("found direct hits for tracker get: {}", (Object)futureRouting.directHits());
                                    DistributedTracker.this.startLoop(builder, futureTracker, futureRouting.directHits(), futureChannelCreator2.channelCreator());
                                } else {
                                    futureTracker.failed((BaseFuture)futureRouting);
                                }
                            }
                        });
                    }
                    UtilsTracker.addReleaseListener(futureChannelCreator2.channelCreator(), futureTracker);
                } else {
                    futureTracker.failed((BaseFuture)futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void startLoop(final GetTrackerBuilder builder, FutureTracker futureTracker, NavigableSet<PeerAddress> queueToAsk, final ChannelCreator cc) {
        this.loop(builder.locationKey(), builder.domainKey(), queueToAsk, builder.trackerConfiguration(), futureTracker, true, builder.knownPeers(), new Operation(){

            @Override
            public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                LOG.debug("tracker get: {} location= {}", (Object)remotePeer, (Object)builder.locationKey());
                return DistributedTracker.this.trackerRPC.getFromTracker(remotePeer, builder, cc);
            }
        });
    }

    public FutureTracker add(final AddTrackerBuilder builder) {
        final FutureTracker futureTracker = new FutureTracker(builder.knownPeers());
        builder.futureChannelCreator().addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    final FutureRouting futureRouting = DistributedTracker.this.createRouting(builder, Message.Type.REQUEST_1, futureChannelCreator2.channelCreator());
                    futureRouting.addListener((BaseFutureListener)new BaseFutureAdapter<FutureRouting>(){

                        public void operationComplete(FutureRouting future) throws Exception {
                            if (futureRouting.isSuccess()) {
                                LOG.debug("found potential hits for tracker add: {}", (Object)futureRouting.potentialHits());
                                DistributedTracker.this.loop(builder.locationKey(), builder.domainKey(), futureRouting.potentialHits(), builder.trackerConfiguration(), futureTracker, false, builder.knownPeers(), new Operation(){

                                    @Override
                                    public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                                        LOG.debug("tracker add (me={}): {} location={}", new Object[]{DistributedTracker.this.peerBean.serverPeerAddress(), remotePeer, builder.locationKey()});
                                        return DistributedTracker.this.trackerRPC.addToTracker(remotePeer, builder, futureChannelCreator2.channelCreator());
                                    }
                                });
                            } else {
                                futureTracker.failed((BaseFuture)futureRouting);
                            }
                        }
                    });
                    UtilsTracker.addReleaseListener(futureChannelCreator2.channelCreator(), futureTracker);
                } else {
                    futureTracker.failed((BaseFuture)futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void loop(Number160 locationKey, Number160 domainKey, NavigableSet<PeerAddress> queueToAsk, TrackerConfiguration trackerConfiguration, FutureTracker futureTracker, boolean isGet, Set<Number160> knownPeers, Operation operation) {
        FutureResponse[] futureResponses = new FutureResponse[trackerConfiguration.parallel()];
        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(PeerMap.createXORAddressComparator((Number160)this.stableRandom));
        this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, new HashSet<PeerAddress>(), new HashSet<PeerAddress>(), new HashMap<PeerAddress, TrackerData>(), operation, trackerConfiguration.parallel(), new AtomicInteger(0), trackerConfiguration.maxFailure(), new AtomicInteger(0), trackerConfiguration.maxFullTrackers(), new AtomicInteger(0), trackerConfiguration.atLeastSucessfulRequestes(), trackerConfiguration.atLeastEntriesFromTrackers(), new AtomicInteger(0), trackerConfiguration.maxPrimaryTrackers(), new AtomicReferenceArray<FutureResponse>(futureResponses), futureTracker, knownPeers, isGet);
    }

    private void loopRec(final Number160 locationKey, final Number160 domainKey, final NavigableSet<PeerAddress> queueToAsk, final NavigableSet<PeerAddress> secondaryQueue, final Set<PeerAddress> alreadyAsked, final Set<PeerAddress> successAsked, final Map<PeerAddress, TrackerData> peerOnTracker, final Operation operation, final int parallel, final AtomicInteger nrFailures, final int maxFailures, final AtomicInteger trackerFull, final int maxTrackerFull, final AtomicInteger successfulRequests, final int atLeastSuccessfullRequests, final int atLeastEntriesFromTrackers, final AtomicInteger primaryTracker, final int maxPrimaryTracker, final AtomicReferenceArray<FutureResponse> futureResponses, final FutureTracker futureTracker, final Set<Number160> knownPeers, final boolean isGet) {
        final boolean cancelOnFinish = isGet;
        LOG.debug("we can ask {} primary, and {} secondary.", (Object)queueToAsk.size(), (Object)secondaryQueue.size());
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses.get(i) == null) {
                boolean primary = true;
                PeerAddress next = null;
                if (primaryTracker.incrementAndGet() <= maxPrimaryTracker) {
                    next = isGet ? (PeerAddress)Utils.pollRandom(queueToAsk, (Random)this.rnd) : queueToAsk.pollFirst();
                }
                if (next == null) {
                    next = isGet ? (PeerAddress)Utils.pollRandom(secondaryQueue, (Random)this.rnd) : secondaryQueue.pollFirst();
                    primary = false;
                }
                if (next == null) continue;
                LOG.debug("we are about to ask {}", (Object)next);
                alreadyAsked.add(next);
                ++active;
                futureResponses.set(i, operation.create(next, primary));
                continue;
            }
            ++active;
        }
        if (active == 0) {
            LOG.debug("we finished1, we asked {}, but we could ask {} more nodes {}", new Object[]{alreadyAsked.size(), queueToAsk.size(), alreadyAsked});
            queueToAsk.addAll(secondaryQueue);
            futureTracker.trackers(queueToAsk, successAsked, peerOnTracker, null);
            if (cancelOnFinish) {
                DistributedTracker.cancel(futureResponses);
            }
            return;
        }
        FutureForkJoin fp = new FutureForkJoin(1, false, futureResponses);
        fp.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean isPartial;
                boolean finished = false;
                FutureResponse futureResponse = (FutureResponse)future.last();
                boolean isFull = futureResponse != null && futureResponse.responseMessage() != null && futureResponse.responseMessage().type() == Message.Type.DENIED;
                boolean bl = isPartial = futureResponse != null && futureResponse.responseMessage() != null && futureResponse.responseMessage().type() == Message.Type.PARTIALLY_OK;
                if (future.isSuccess() || isFull) {
                    TrackerData newDataMap;
                    if (!isFull) {
                        successAsked.add(futureResponse.request().recipient());
                    }
                    if ((newDataMap = futureResponse.responseMessage().trackerData(0)) != null) {
                        Set newPeers = newDataMap.peerAddresses().keySet();
                        DistributedTracker.mergeDiff(secondaryQueue, newPeers, alreadyAsked, queueToAsk);
                        DistributedTracker.storeResult(peerOnTracker, newDataMap, futureResponse.request().recipient(), knownPeers);
                        secondaryQueue.addAll(newPeers);
                    }
                    int successRequests = isFull ? successfulRequests.get() : successfulRequests.incrementAndGet();
                    finished = DistributedTracker.this.evaluate(peerOnTracker, successRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, isGet);
                    LOG.debug("evaluation result: finished={}, {} / {}", new Object[]{finished, peerOnTracker.size(), atLeastEntriesFromTrackers});
                    if (!finished && isPartial) {
                        LOG.debug("partial1: {}, secondaryQueue {}", (Object)futureResponse.request().recipient(), (Object)queueToAsk);
                        queueToAsk.add(futureResponse.request().recipient());
                    }
                    if (!finished && isFull) {
                        LOG.debug("tracker reported to be full. Check if finished due to full trackers.");
                        finished = trackerFull.incrementAndGet() >= maxTrackerFull;
                    }
                } else {
                    LOG.debug("no success {}", (Object)future.failedReason());
                    boolean bl2 = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    HashSet<PeerAddress> potentialTrackers = new HashSet<PeerAddress>(queueToAsk);
                    potentialTrackers.addAll(secondaryQueue);
                    LOG.debug("we finished2, we asked {}, but we could ask {} more nodes ({} / {})", new Object[]{alreadyAsked.size(), queueToAsk.size(), successfulRequests, atLeastSuccessfullRequests});
                    futureTracker.trackers(potentialTrackers, successAsked, peerOnTracker, (FutureDone<Void>)future.futuresCompleted());
                    if (cancelOnFinish) {
                        DistributedTracker.cancel(futureResponses);
                    }
                } else {
                    DistributedTracker.this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, alreadyAsked, successAsked, peerOnTracker, operation, parallel, nrFailures, maxFailures, trackerFull, maxTrackerFull, successfulRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, primaryTracker, maxPrimaryTracker, futureResponses, futureTracker, knownPeers, isGet);
                }
            }
        });
    }

    private boolean evaluate(Map<?, ?> peerOnTracker, int successfulRequests, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers, boolean isGet) {
        if (isGet) {
            return successfulRequests >= atLeastSuccessfulRequests || peerOnTracker.size() >= atLeastEntriesFromTrackers;
        }
        return successfulRequests >= atLeastSuccessfulRequests;
    }

    private FutureRouting createRouting(TrackerBuilder<?> builder, Message.Type type, ChannelCreator channelCreator) {
        RoutingBuilder routingBuilder = builder.createBuilder(builder.routingConfiguration());
        routingBuilder.locationKey(builder.locationKey());
        routingBuilder.domainKey(builder.domainKey());
        routingBuilder.peerMapFilters(builder.peerMapFilters());
        return this.routing.route(routingBuilder, type, channelCreator);
    }

    private static void storeResult(Map<PeerAddress, TrackerData> peerOnTracker, TrackerData newDataMap, PeerAddress newDataProvider, Set<Number160> knownPeers) {
        if (knownPeers != null) {
            knownPeers.add(newDataProvider.peerId());
        }
        peerOnTracker.put(newDataProvider, newDataMap);
    }

    private static boolean mergeDiff(Set<PeerAddress> queueToAsk, Collection<PeerAddress> newPeers, Collection<PeerAddress> knownPeers1, Collection<PeerAddress> knownPeers2) {
        ArrayList<PeerAddress> newPeers2 = new ArrayList<PeerAddress>(newPeers);
        Collection result = Utils.difference(newPeers2, new ArrayList(), (Collection[])new Collection[]{knownPeers1, knownPeers2});
        return queueToAsk.addAll(result);
    }

    private static void cancel(AtomicReferenceArray<FutureResponse> futures) {
        int len = futures.length();
        for (int i = 0; i < len; ++i) {
            BaseFuture baseFuture = (BaseFuture)futures.get(i);
            if (baseFuture == null) continue;
            baseFuture.cancel();
        }
    }

    public static interface Operation {
        public FutureResponse create(PeerAddress var1, boolean var2);
    }
}

