/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android.gcm;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.gcm.FutureGCM;
import net.tomp2p.relay.android.gcm.IGCMSender;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteGCMSender
implements IGCMSender {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteGCMSender.class);
    private static final int TIMEOUT_MS = 10000;
    private final Peer peer;
    private Collection<PeerAddress> gcmServers;

    public RemoteGCMSender(Peer peer, Collection<PeerAddress> gcmServers) {
        this.gcmServers = gcmServers;
        this.peer = peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final FutureGCM futureGCM) {
        ArrayList<PeerAddress> copy;
        Collection<PeerAddress> collection = this.gcmServers;
        synchronized (collection) {
            copy = new ArrayList<PeerAddress>(this.gcmServers);
        }
        if (copy.isEmpty()) {
            LOG.error("Cannot send GCM messages because no GCM server is known");
            futureGCM.failed("Cannot send GCM messages because no GCM server is known");
            return;
        }
        this.peer.connectionBean().timer().submit(new Runnable(){

            @Override
            public void run() {
                for (PeerAddress gcmServer : copy) {
                    LOG.debug("Try sending message to {}", (Object)gcmServer);
                    Message message = new Message().recipient(gcmServer).sender(RemoteGCMSender.this.peer.peerAddress()).command(RPC.Commands.GCM.getNr()).type(Message.Type.REQUEST_1).version(RemoteGCMSender.this.peer.p2pId()).buffer(RelayUtils.encodeString((String)futureGCM.registrationId()));
                    FutureResponse futureResponse = RelayUtils.connectAndSend((Peer)RemoteGCMSender.this.peer, (Message)message);
                    if (futureResponse.awaitUninterruptibly(10000L) && futureResponse.isSuccess()) {
                        LOG.debug("GCM server {} sent the message successfully", (Object)gcmServer);
                        return;
                    }
                    LOG.debug("GCM server {} did not accept the message. Reason: {}", (Object)futureResponse.failedReason());
                }
                LOG.error("Could not send the message to any of the GCM servers");
                futureGCM.failed("Could not send the message to any of the GCM servers");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gcmServers(Collection<PeerAddress> gcmServers) {
        Collection<PeerAddress> collection = this.gcmServers;
        synchronized (collection) {
            this.gcmServers = gcmServers;
        }
    }
}

