/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import net.tomp2p.connection.HolePInitiator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.holep.NATType;
import net.tomp2p.holep.NATTypeDetection;
import net.tomp2p.holep.strategy.HolePStrategy;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolePInitiatorImpl
implements HolePInitiator {
    private static final Logger LOG = LoggerFactory.getLogger(HolePInitiatorImpl.class);
    private final NATTypeDetection natTypeDetection;
    private Peer peer;
    private boolean testCase = false;

    public HolePInitiatorImpl(Peer peer) {
        this.peer = peer;
        this.natTypeDetection = new NATTypeDetection(peer);
    }

    public FutureDone<Message> handleHolePunch(int idleUDPSeconds, FutureResponse futureResponse, Message originalMessage) {
        FutureDone futureDone = new FutureDone();
        if (this.natTypeDetection.natType() == NATType.NON_PRESERVING_OTHER) {
            LOG.error("A symmetric NAT can't be traversed. No HolePunching possible!");
            return (FutureDone)futureDone.failed("A symmetric NAT can't be traversed. No HolePunching possible!");
        }
        HolePStrategy holePuncher = this.natType().holePuncher(this.peer, this.peer.peerBean().holePNumberOfHoles(), idleUDPSeconds, originalMessage);
        return holePuncher.initiateHolePunch((FutureDone<Message>)futureDone, futureResponse);
    }

    public void checkNatType(PeerAddress peerAddress) {
        this.natTypeDetection.checkNATType(peerAddress);
    }

    public NATType natType() {
        return this.natTypeDetection.natType();
    }

    public boolean isTestCase() {
        return this.testCase;
    }

    public void testCase(boolean testCase) {
        this.testCase = testCase;
    }
}

